/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.columns;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.db.TableColumnKey;
import mil.nga.geopackage.features.columns.GeometryColumnsDao;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.proj.Projection;
import mil.nga.sf.GeometryType;

@DatabaseTable(tableName="gpkg_geometry_columns", daoClass=GeometryColumnsDao.class)
public class GeometryColumns {
    public static final String TABLE_NAME = "gpkg_geometry_columns";
    public static final String COLUMN_TABLE_NAME = "table_name";
    public static final String COLUMN_COLUMN_NAME = "column_name";
    public static final String COLUMN_ID_1 = "table_name";
    public static final String COLUMN_ID_2 = "column_name";
    public static final String COLUMN_GEOMETRY_TYPE_NAME = "geometry_type_name";
    public static final String COLUMN_SRS_ID = "srs_id";
    public static final String COLUMN_Z = "z";
    public static final String COLUMN_M = "m";
    @DatabaseField(columnName="table_name", canBeNull=false, unique=true, foreign=true, foreignAutoRefresh=true)
    private Contents contents;
    @DatabaseField(columnName="table_name", id=true, canBeNull=false, uniqueCombo=true, readOnly=true)
    private String tableName;
    @DatabaseField(columnName="column_name", canBeNull=false, uniqueCombo=true)
    private String columnName;
    @DatabaseField(columnName="geometry_type_name", canBeNull=false)
    private String geometryTypeName;
    @DatabaseField(columnName="srs_id", canBeNull=false, foreign=true, foreignAutoRefresh=true)
    private SpatialReferenceSystem srs;
    @DatabaseField(columnName="srs_id", canBeNull=false, readOnly=true)
    private long srsId;
    @DatabaseField(columnName="z", canBeNull=false)
    private byte z;
    @DatabaseField(columnName="m", canBeNull=false)
    private byte m;

    public GeometryColumns() {
    }

    public GeometryColumns(GeometryColumns geometryColumns) {
        this.contents = geometryColumns.contents;
        this.tableName = geometryColumns.tableName;
        this.columnName = geometryColumns.columnName;
        this.geometryTypeName = geometryColumns.geometryTypeName;
        this.srs = geometryColumns.srs;
        this.srsId = geometryColumns.srsId;
        this.z = geometryColumns.z;
        this.m = geometryColumns.m;
    }

    public TableColumnKey getId() {
        return new TableColumnKey(this.tableName, this.columnName);
    }

    public void setId(TableColumnKey id) {
        this.tableName = id.getTableName();
        this.columnName = id.getColumnName();
    }

    public Contents getContents() {
        return this.contents;
    }

    public void setContents(Contents contents) {
        this.contents = contents;
        if (contents != null) {
            if (!contents.isFeaturesTypeOrUnknown()) {
                throw new GeoPackageException("The " + Contents.class.getSimpleName() + " of a " + GeometryColumns.class.getSimpleName() + " must have a data type of " + ContentsDataType.FEATURES.getName() + ". actual type: " + contents.getDataTypeName());
            }
            this.tableName = contents.getId();
        } else {
            this.tableName = null;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public GeometryType getGeometryType() {
        return GeometryType.fromName((String)this.geometryTypeName);
    }

    public void setGeometryType(GeometryType geometryType) {
        this.geometryTypeName = geometryType.getName();
    }

    public String getGeometryTypeName() {
        return this.geometryTypeName;
    }

    public SpatialReferenceSystem getSrs() {
        return this.srs;
    }

    public void setSrs(SpatialReferenceSystem srs) {
        this.srs = srs;
        this.srsId = srs != null ? srs.getId() : -1L;
    }

    public long getSrsId() {
        return this.srsId;
    }

    public void setSrsId(long srsId) {
        this.srsId = srsId;
    }

    public byte getZ() {
        return this.z;
    }

    public void setZ(byte z) {
        this.validateValues(COLUMN_Z, z);
        this.z = z;
    }

    public byte getM() {
        return this.m;
    }

    public void setM(byte m) {
        this.validateValues(COLUMN_M, m);
        this.m = m;
    }

    public Projection getProjection() {
        return this.getSrs().getProjection();
    }

    private void validateValues(String column, byte value) {
        if (value < 0 || value > 2) {
            throw new GeoPackageException(column + " value must be 0 for prohibited, 1 for mandatory, or 2 for optional");
        }
    }
}

