/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.DateConverter;
import mil.nga.geopackage.db.GeoPackageDataType;
import mil.nga.geopackage.db.Result;

public class ResultUtils {
    private static final Logger logger = Logger.getLogger(ResultUtils.class.getName());
    public static final int FIELD_TYPE_INTEGER = 1;
    public static final int FIELD_TYPE_FLOAT = 2;
    public static final int FIELD_TYPE_STRING = 3;
    public static final int FIELD_TYPE_BLOB = 4;
    public static final int FIELD_TYPE_NULL = 0;

    public static Object getValue(Result result, int index) {
        return ResultUtils.getValue(result, index, null);
    }

    public static Object getValue(Result result, int index, GeoPackageDataType dataType) {
        int type = result.getType(index);
        return ResultUtils.getValue(result, index, type, dataType);
    }

    public static Object getValue(Result result, int index, int type) {
        return ResultUtils.getValue(result, index, type, null);
    }

    public static Object getValue(Result result, int index, int type, GeoPackageDataType dataType) {
        Object value = null;
        switch (type) {
            case 1: {
                value = ResultUtils.getIntegerValue(result, index, dataType);
                break;
            }
            case 2: {
                value = ResultUtils.getFloatValue(result, index, dataType);
                break;
            }
            case 3: {
                String stringValue = result.getString(index);
                if (dataType != null && (dataType == GeoPackageDataType.DATE || dataType == GeoPackageDataType.DATETIME)) {
                    DateConverter converter = DateConverter.converter(dataType);
                    try {
                        value = converter.dateValue(stringValue);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Invalid " + dataType + " format: " + stringValue + ", String value used", e);
                        value = stringValue;
                    }
                    break;
                }
                value = stringValue;
                break;
            }
            case 4: {
                value = result.getBlob(index);
                break;
            }
        }
        return value;
    }

    public static Object getIntegerValue(Result result, int index, GeoPackageDataType dataType) {
        Comparable<Short> value = null;
        if (dataType == null) {
            dataType = GeoPackageDataType.INTEGER;
        }
        switch (dataType) {
            case BOOLEAN: {
                short booleanValue = result.getShort(index);
                value = booleanValue == 0 ? Boolean.FALSE : Boolean.TRUE;
                break;
            }
            case TINYINT: {
                value = (byte)result.getShort(index);
                break;
            }
            case SMALLINT: {
                value = result.getShort(index);
                break;
            }
            case MEDIUMINT: {
                value = result.getInt(index);
                break;
            }
            case INT: 
            case INTEGER: {
                value = result.getLong(index);
                break;
            }
            default: {
                throw new GeoPackageException("Data Type " + dataType + " is not an integer type");
            }
        }
        if (result.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Object getFloatValue(Result result, int index, GeoPackageDataType dataType) {
        Number value = null;
        if (dataType == null) {
            dataType = GeoPackageDataType.DOUBLE;
        }
        switch (dataType) {
            case FLOAT: {
                value = Float.valueOf(result.getFloat(index));
                break;
            }
            case INT: 
            case INTEGER: 
            case DOUBLE: 
            case REAL: {
                value = result.getDouble(index);
                break;
            }
            default: {
                throw new GeoPackageException("Data Type " + dataType + " is not a float type");
            }
        }
        if (result.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Object getValue(Object value, GeoPackageDataType dataType) {
        if (value != null && dataType != null) {
            try {
                switch (dataType) {
                    case BOOLEAN: {
                        if (value instanceof Boolean || !(value instanceof Number)) break;
                        short booleanValue = ((Number)value).shortValue();
                        value = booleanValue == 0 ? Boolean.FALSE : Boolean.TRUE;
                        break;
                    }
                    case DATE: 
                    case DATETIME: {
                        if (value instanceof Date || !(value instanceof String)) break;
                        DateConverter converter = DateConverter.converter(dataType);
                        value = converter.dateValue(value.toString());
                        break;
                    }
                    case INT: 
                    case INTEGER: {
                        if (value instanceof Long || !(value instanceof Number)) break;
                        value = ((Number)value).longValue();
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Invalid " + dataType + " format: " + value + ", " + value.getClass().getName() + " value used", e);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object buildSingleResult(Result result, int column, GeoPackageDataType dataType) {
        Object value = null;
        try {
            if (result.moveToNext()) {
                value = result.getValue(column, dataType);
            }
        }
        finally {
            result.close();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> buildSingleColumnResults(Result result, int column, GeoPackageDataType dataType, Integer limit) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            while (result.moveToNext()) {
                Object value = result.getValue(column, dataType);
                results.add(value);
                if (limit == null || results.size() < limit) continue;
                break;
            }
        }
        finally {
            result.close();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<Object>> buildResults(Result result, GeoPackageDataType[] dataTypes, Integer limit) {
        ArrayList<List<Object>> results = new ArrayList<List<Object>>();
        try {
            int columns = result.getColumnCount();
            while (result.moveToNext()) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 0; i < columns; ++i) {
                    row.add(result.getValue(i, dataTypes != null ? dataTypes[i] : null));
                }
                results.add(row);
                if (limit == null || results.size() < limit) continue;
                break;
            }
        }
        finally {
            result.close();
        }
        return results;
    }
}

