/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class S3ObjectAttributes {
    private final String bucket;
    private final Path path;
    private final String key;
    private final S3AEncryptionMethods serverSideEncryptionAlgorithm;
    private final String serverSideEncryptionKey;
    private final String eTag;
    private final String versionId;
    private final long len;

    public S3ObjectAttributes(String bucket, Path path, String key, S3AEncryptionMethods serverSideEncryptionAlgorithm, String serverSideEncryptionKey, String eTag, String versionId, long len) {
        this.bucket = bucket;
        this.path = path;
        this.key = key;
        this.serverSideEncryptionAlgorithm = serverSideEncryptionAlgorithm;
        this.serverSideEncryptionKey = serverSideEncryptionKey;
        this.eTag = eTag;
        this.versionId = versionId;
        this.len = len;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public S3AEncryptionMethods getServerSideEncryptionAlgorithm() {
        return this.serverSideEncryptionAlgorithm;
    }

    public String getServerSideEncryptionKey() {
        return this.serverSideEncryptionKey;
    }

    public String getETag() {
        return this.eTag;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public long getLen() {
        return this.len;
    }

    public Path getPath() {
        return this.path;
    }
}

