/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import java.io.IOException;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.coverage.CoverageDataImage;
import mil.nga.geopackage.extension.coverage.CoverageDataTiff;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.tiff.FileDirectory;
import mil.nga.tiff.Rasters;
import mil.nga.tiff.TIFFImage;
import mil.nga.tiff.TiffReader;
import mil.nga.tiff.TiffWriter;

public class CoverageDataTiffImage
implements CoverageDataImage {
    private final int width;
    private final int height;
    private byte[] imageBytes;
    private FileDirectory directory;
    private Rasters rasters;

    public CoverageDataTiffImage(TileRow tileRow) {
        this.imageBytes = tileRow.getTileData();
        TIFFImage tiffImage = TiffReader.readTiff((byte[])this.imageBytes);
        this.directory = tiffImage.getFileDirectory();
        CoverageDataTiff.validateImageType(this.directory);
        this.width = this.directory.getImageWidth().intValue();
        this.height = this.directory.getImageHeight().intValue();
    }

    public CoverageDataTiffImage(FileDirectory directory) {
        this.directory = directory;
        this.rasters = directory.getWriteRasters();
        this.width = directory.getImageWidth().intValue();
        this.height = directory.getImageHeight().intValue();
    }

    public byte[] getImageBytes() {
        if (this.imageBytes == null) {
            this.writeTiff();
        }
        return this.imageBytes;
    }

    public FileDirectory getDirectory() {
        return this.directory;
    }

    public Rasters getRasters() {
        if (this.rasters == null) {
            this.readPixels();
        }
        return this.rasters;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void writeTiff() {
        if (this.directory.getWriteRasters() != null) {
            TIFFImage tiffImage = new TIFFImage();
            tiffImage.add(this.directory);
            try {
                this.imageBytes = TiffWriter.writeTiffToBytes((TIFFImage)tiffImage);
            }
            catch (IOException e) {
                throw new GeoPackageException("Failed to write TIFF image", (Throwable)e);
            }
        }
    }

    public float getPixel(int x, int y) {
        float pixel = -1.0f;
        if (this.rasters == null) {
            this.readPixels();
        }
        if (this.rasters == null) {
            throw new GeoPackageException("Could not retrieve pixel value");
        }
        pixel = this.rasters.getFirstPixelSample(x, y).floatValue();
        return pixel;
    }

    private void readPixels() {
        if (this.directory != null) {
            this.rasters = this.directory.readRasters();
        }
    }
}

