/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.baremaps.data.collection.DataCollectionException;
import org.apache.baremaps.data.collection.DataMap;
import org.apache.baremaps.data.memory.Memory;
import org.apache.baremaps.data.type.FixedSizeDataType;

public class MemoryAlignedDataMap<E>
implements DataMap<Long, E> {
    private final FixedSizeDataType<E> dataType;
    private final Memory<?> memory;
    private final int valueShift;
    private final long segmentShift;
    private final long segmentMask;
    private final long upperBoundary;

    public MemoryAlignedDataMap(FixedSizeDataType<E> dataType, Memory<?> memory) {
        if (dataType.size() > memory.segmentSize()) {
            throw new DataCollectionException("The segment size is too small for the data type");
        }
        if ((dataType.size() & -dataType.size()) != dataType.size()) {
            throw new IllegalArgumentException("The data type size must be a fixed power of 2");
        }
        if (memory.segmentSize() % dataType.size() != 0) {
            throw new DataCollectionException("The segment size and data type size must be aligned");
        }
        this.dataType = dataType;
        this.memory = memory;
        this.valueShift = (int)(Math.log(dataType.size()) / Math.log(2.0));
        this.segmentShift = memory.segmentShift();
        this.segmentMask = memory.segmentMask();
        this.upperBoundary = this.segmentShift > 32L ? Long.MAX_VALUE >> this.valueShift : Long.MAX_VALUE >> (int)(32L - this.segmentShift + (long)this.valueShift);
    }

    private void checkBoundary(Long key) {
        Objects.requireNonNull(key, "Key couldn't be null");
        if (key < 0L || key > this.upperBoundary) {
            String msg = String.format("Key should between 0 and %d, but your key is %d", this.upperBoundary, key);
            throw new IndexOutOfBoundsException(msg);
        }
    }

    @Override
    public E put(Long key, E value) {
        this.checkBoundary(key);
        Objects.requireNonNull(value, "Value couldn't be null");
        long position = key << this.valueShift;
        int segmentIndex = (int)(position >>> (int)this.segmentShift);
        int segmentOffset = (int)(position & this.segmentMask);
        ByteBuffer segment = this.memory.segment(segmentIndex);
        Object previous = this.dataType.read(segment, segmentOffset);
        this.dataType.write(segment, segmentOffset, value);
        return (E)previous;
    }

    @Override
    public E get(Object key) {
        this.checkBoundary((long)((Long)key));
        long position = (Long)key << this.valueShift;
        int segmentIndex = (int)(position >>> (int)this.segmentShift);
        int segmentOffset = (int)(position & this.segmentMask);
        ByteBuffer segment = this.memory.segment(segmentIndex);
        return (E)this.dataType.read(segment, segmentOffset);
    }

    @Override
    public boolean containsKey(Object keyObject) {
        if (keyObject instanceof Long) {
            Long key = (Long)keyObject;
            return key >= 0L && key < this.size();
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<E> iterator = this.valueIterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long size() {
        return this.memory.size() / (long)this.dataType.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Long> keyIterator() {
        return new Iterator<Long>(){
            private final long size;
            private long index;
            {
                this.size = MemoryAlignedDataMap.this.size();
                this.index = 0L;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.index++;
            }
        };
    }

    @Override
    public Iterator<E> valueIterator() {
        return new Iterator<E>(){
            private final long size;
            private long index;
            {
                this.size = MemoryAlignedDataMap.this.size();
                this.index = 0L;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MemoryAlignedDataMap.this.get(this.index++);
            }
        };
    }

    @Override
    public Iterator<Map.Entry<Long, E>> entryIterator() {
        return new Iterator<Map.Entry<Long, E>>(){
            private final long size;
            private long index;
            {
                this.size = MemoryAlignedDataMap.this.size();
                this.index = 0L;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Map.Entry<Long, E> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                long key = this.index++;
                return Map.entry(key, MemoryAlignedDataMap.this.get(key));
            }
        };
    }
}

