/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.collection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.baremaps.data.collection.DataCollection;
import org.apache.baremaps.data.collection.DataCollectionException;
import org.apache.baremaps.data.memory.Memory;
import org.apache.baremaps.data.memory.OffHeapMemory;
import org.apache.baremaps.data.type.DataType;

public class AppendOnlyLog<E>
implements DataCollection<E> {
    private final DataType<E> dataType;
    private final Memory<?> memory;
    private final long segmentSize;
    private long offset;
    private long size;
    private final Lock lock = new ReentrantLock();

    public AppendOnlyLog(DataType<E> dataType) {
        this(dataType, new OffHeapMemory());
    }

    public AppendOnlyLog(DataType<E> dataType, Memory<?> memory) {
        this.dataType = dataType;
        this.memory = memory;
        this.segmentSize = memory.segmentSize();
        this.offset = 8L;
        this.size = memory.segment(0).getLong(0);
    }

    public long addPositioned(E value) {
        int valueSize = this.dataType.size(value);
        if ((long)valueSize > this.segmentSize) {
            throw new DataCollectionException("The value is too big to fit in a segment");
        }
        this.lock.lock();
        long position = this.offset;
        long segmentIndex = position / this.segmentSize;
        long segmentOffset = position % this.segmentSize;
        if (segmentOffset + (long)valueSize > this.segmentSize) {
            segmentOffset = 0L;
            position = ++segmentIndex * this.segmentSize;
        }
        this.offset = position + (long)valueSize;
        ++this.size;
        this.lock.unlock();
        ByteBuffer segment = this.memory.segment((int)segmentIndex);
        this.dataType.write(segment, (int)segmentOffset, value);
        return position;
    }

    public E getPositioned(long position) {
        long segmentIndex = position / this.segmentSize;
        long segmentOffset = position % this.segmentSize;
        ByteBuffer buffer = this.memory.segment((int)segmentIndex);
        return this.dataType.read(buffer, (int)segmentOffset);
    }

    @Override
    public boolean add(E e) {
        this.addPositioned(e);
        return true;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void clear() {
        try {
            this.memory.clear();
        }
        catch (IOException e) {
            throw new DataCollectionException(e);
        }
    }

    public AppendOnlyLogIterator iterator() {
        return new AppendOnlyLogIterator(this.size);
    }

    public class AppendOnlyLogIterator
    implements Iterator<E> {
        private final long size;
        private long index;
        private long position;

        private AppendOnlyLogIterator(long size) {
            this.size = size;
            this.index = 0L;
            this.position = 8L;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size;
        }

        @Override
        public E next() {
            int valueSize;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long segmentIndex = this.position / AppendOnlyLog.this.segmentSize;
            long segmentOffset = this.position % AppendOnlyLog.this.segmentSize;
            ByteBuffer segment = AppendOnlyLog.this.memory.segment((int)segmentIndex);
            try {
                valueSize = AppendOnlyLog.this.dataType.size(segment, (int)segmentOffset);
            }
            catch (IndexOutOfBoundsException e) {
                valueSize = 0;
            }
            if (segmentOffset + (long)valueSize > AppendOnlyLog.this.segmentSize || valueSize == 0) {
                segmentOffset = 0L;
                this.position = ++segmentIndex * AppendOnlyLog.this.segmentSize;
                segment = AppendOnlyLog.this.memory.segment((int)segmentIndex);
                valueSize = AppendOnlyLog.this.dataType.size(segment, (int)segmentOffset);
            }
            this.position += (long)valueSize;
            ++this.index;
            return AppendOnlyLog.this.dataType.read(segment, (int)segmentOffset);
        }

        public long getPosition() {
            return this.position;
        }
    }
}

