/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage;

import java.util.Collection;
import java.util.Comparator;
import java.util.OptionalLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.internal.FeatureUtilities;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.pending.geoapi.filter.SortBy;
import org.apache.sis.storage.AbstractFeatureSet;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.FeatureQuery;
import org.apache.sis.storage.FeatureSet;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.StoreUtilities;
import org.apache.sis.storage.internal.Resources;
import org.opengis.metadata.Metadata;

final class FeatureSubset
extends AbstractFeatureSet {
    private final FeatureSet source;
    private final FeatureQuery query;
    private DefaultFeatureType resultType;

    FeatureSubset(FeatureSet source, FeatureQuery query) {
        super(source);
        this.source = source;
        this.query = query;
    }

    @Override
    protected Metadata createMetadata() throws DataStoreException {
        MetadataBuilder builder = new MetadataBuilder();
        builder.addDefaultMetadata(this, this.listeners);
        builder.addLineage((CharSequence)Resources.formatInternational((short)76));
        builder.addProcessDescription((CharSequence)Resources.formatInternational((short)77, StoreUtilities.getLabel(this.source)));
        builder.addSource(this.source.getMetadata());
        return builder.build();
    }

    @Override
    public synchronized DefaultFeatureType getType() throws DataStoreException {
        if (this.resultType == null) {
            DefaultFeatureType type = this.source.getType();
            try {
                this.resultType = this.query.expectedType(type);
            }
            catch (IllegalArgumentException e) {
                throw new DataStoreContentException(Resources.forLocale(this.listeners.getLocale()).getString((short)55, type.getName()), e);
            }
        }
        return this.resultType;
    }

    @Override
    public Stream<AbstractFeature> features(boolean parallel) throws DataStoreException {
        FeatureQuery.NamedExpression[] projection;
        OptionalLong limit;
        long offset;
        SortBy<AbstractFeature> sortBy;
        Stream<AbstractFeature> stream = this.source.features(parallel);
        Filter<? super AbstractFeature> selection = this.query.getSelection();
        if (selection != null && !selection.equals((Object)Filter.include())) {
            stream = stream.filter((Predicate<AbstractFeature>)selection);
        }
        if ((sortBy = this.query.getSortBy()) != null) {
            stream = stream.sorted((Comparator<AbstractFeature>)sortBy);
        }
        if ((offset = this.query.getOffset()) > 0L) {
            stream = stream.skip(offset);
        }
        if ((limit = this.query.getLimit()).isPresent()) {
            stream = stream.limit(limit.getAsLong());
        }
        if ((projection = this.query.getStoredProjection()) != null) {
            Expression[] expressions = new Expression[projection.length];
            for (int i = 0; i < expressions.length; ++i) {
                expressions[i] = projection[i].expression;
            }
            DefaultFeatureType type = this.getType();
            String[] names = FeatureUtilities.getNames((Collection)type.getProperties(false));
            stream = stream.map(t -> {
                AbstractFeature f = type.newInstance();
                for (int i = 0; i < expressions.length; ++i) {
                    f.setPropertyValue(names[i], expressions[i].apply(t));
                }
                return f;
            });
        }
        return stream;
    }
}

