/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.Arrays;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.AbstractLinearTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.Matrix;

final class CopyTransform
extends AbstractLinearTransform {
    private static final long serialVersionUID = 5457032501070947956L;
    private final int srcDim;
    private final int[] indices;

    CopyTransform(int srcDim, int[] indices) {
        this.srcDim = srcDim;
        this.indices = indices;
    }

    static CopyTransform create(Matrix matrix) {
        int srcDim = matrix.getNumCol() - 1;
        int dstDim = matrix.getNumRow() - 1;
        for (int i = 0; i <= srcDim; ++i) {
            if (matrix.getElement(dstDim, i) == (double)(i == srcDim ? 1 : 0)) continue;
            return null;
        }
        int[] indices = new int[dstDim];
        for (int j = 0; j < dstDim; ++j) {
            if (matrix.getElement(j, srcDim) != 0.0) {
                return null;
            }
            boolean found = false;
            for (int i = 0; i < srcDim; ++i) {
                double elt = matrix.getElement(j, i);
                if (elt == 0.0) continue;
                if (elt != 1.0 || found) {
                    return null;
                }
                indices[j] = i;
                found = true;
            }
            if (found) continue;
            return null;
        }
        return new CopyTransform(srcDim, indices);
    }

    @Override
    public int getSourceDimensions() {
        return this.srcDim;
    }

    @Override
    public int getTargetDimensions() {
        return this.indices.length;
    }

    @Override
    public boolean isAffine() {
        return this.srcDim == this.indices.length;
    }

    @Override
    public boolean isIdentity() {
        if (this.srcDim != this.indices.length) {
            return false;
        }
        int i = this.indices.length;
        while (--i >= 0) {
            if (this.indices[i] == i) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) {
        this.transform(srcPts, srcOff, dstPts, dstOff, 1);
        return derivate ? this.derivative(null) : null;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        int[] indices = this.indices;
        int srcInc = srcDim = this.srcDim;
        int dstInc = dstDim = indices.length;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    dstOff += (numPts - 1) * dstDim;
                    srcInc = -srcInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
                    srcOff = 0;
                }
            }
        }
        if (srcPts != dstPts) {
            while (--numPts >= 0) {
                for (int i = 0; i < dstDim; ++i) {
                    dstPts[dstOff++] = srcPts[srcOff + indices[i]];
                }
                srcOff += srcDim;
            }
        } else {
            double[] buffer = new double[dstDim];
            while (--numPts >= 0) {
                for (int i = 0; i < dstDim; ++i) {
                    buffer[i] = srcPts[srcOff + indices[i]];
                }
                System.arraycopy(buffer, 0, dstPts, dstOff, dstDim);
                srcOff += srcInc;
                dstOff += dstInc;
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        int[] indices = this.indices;
        int srcInc = srcDim = this.srcDim;
        int dstInc = dstDim = indices.length;
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    dstOff += (numPts - 1) * dstDim;
                    srcInc = -srcInc;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
                    srcOff = 0;
                }
            }
        }
        if (srcPts != dstPts) {
            while (--numPts >= 0) {
                for (int i = 0; i < dstDim; ++i) {
                    dstPts[dstOff++] = srcPts[srcOff + indices[i]];
                }
                srcOff += srcDim;
            }
        } else {
            float[] buffer = new float[dstDim];
            while (--numPts >= 0) {
                for (int i = 0; i < dstDim; ++i) {
                    buffer[i] = srcPts[srcOff + indices[i]];
                }
                System.arraycopy(buffer, 0, dstPts, dstOff, dstDim);
                srcOff += srcInc;
                dstOff += dstInc;
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        int[] indices = this.indices;
        int srcDim = this.srcDim;
        int dstDim = indices.length;
        while (--numPts >= 0) {
            for (int i = 0; i < dstDim; ++i) {
                dstPts[dstOff++] = (float)srcPts[srcOff + indices[i]];
            }
            srcOff += srcDim;
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int[] indices = this.indices;
        int srcDim = this.srcDim;
        int dstDim = indices.length;
        while (--numPts >= 0) {
            for (int i = 0; i < dstDim; ++i) {
                dstPts[dstOff++] = srcPts[srcOff + indices[i]];
            }
            srcOff += srcDim;
        }
    }

    public double getElement(int row, int column) {
        return (row == this.indices.length ? this.srcDim : this.indices[row]) == column ? 1.0 : 0.0;
    }

    @Override
    public Matrix derivative(DirectPosition point) {
        MatrixSIS matrix = Matrices.createZero(this.indices.length, this.srcDim);
        for (int j = 0; j < this.indices.length; ++j) {
            matrix.setElement(j, this.indices[j], 1.0);
        }
        return matrix;
    }

    @Override
    final LinearTransform createInverse() {
        int srcDim = this.srcDim;
        int dstDim = this.indices.length;
        int[] reverse = new int[srcDim];
        Arrays.fill(reverse, -1);
        int i = dstDim;
        while (--i >= 0) {
            reverse[this.indices[i]] = i;
        }
        int j = srcDim;
        while (--j >= 0) {
            if (reverse[j] >= 0) continue;
            MatrixSIS matrix = Matrices.createZero(srcDim + 1, dstDim + 1);
            for (j = 0; j < srcDim; ++j) {
                int i2 = reverse[j];
                if (i2 >= 0) {
                    matrix.setElement(j, i2, 1.0);
                    continue;
                }
                matrix.setElement(j, dstDim, Double.NaN);
            }
            matrix.setElement(srcDim, dstDim, 1.0);
            LinearTransform inv = MathTransforms.linear(matrix);
            if (inv instanceof AbstractLinearTransform) {
                ((AbstractLinearTransform)inv).inverse = this;
            }
            return inv;
        }
        CopyTransform copyInverse = this;
        if (!Arrays.equals(reverse, this.indices)) {
            copyInverse = new CopyTransform(this.indices.length, reverse);
            copyInverse.inverse = this;
        }
        return copyInverse;
    }

    @Override
    protected int computeHashCode() {
        return Arrays.hashCode(this.indices) + 31 * super.computeHashCode();
    }

    @Override
    protected boolean equalsSameClass(Object object) {
        CopyTransform that = (CopyTransform)object;
        return this.srcDim == that.srcDim && Arrays.equals(this.indices, that.indices);
    }
}

