/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Parser;
import org.apache.sis.io.wkt.SingletonElement;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.StandardDateFormat;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

abstract class AbstractParser
implements Parser {
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.io.wkt");
    static final int FIRST = 0;
    static final int OPTIONAL = 1;
    static final int MANDATORY = 2;
    final Locale errorLocale;
    final Symbols symbols;
    private final String exponentSymbol;
    private final NumberFormat numberFormat;
    private DateFormat dateFormat;
    private UnitFormat unitFormat;
    final Map<String, StoredTree> fragments;
    final Map<String, List<String>> ignoredElements;
    private Warnings warnings;

    AbstractParser(Symbols symbols, Map<String, StoredTree> fragments, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, Locale errorLocale) {
        ArgumentChecks.ensureNonNull((String)"symbols", (Object)symbols);
        if (numberFormat == null) {
            numberFormat = symbols.createNumberFormat();
        }
        this.symbols = symbols;
        this.fragments = fragments;
        this.dateFormat = dateFormat;
        this.unitFormat = unitFormat;
        this.errorLocale = errorLocale;
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat.clone();
            this.exponentSymbol = decimalFormat.getDecimalFormatSymbols().getExponentSeparator();
            String pattern = decimalFormat.toPattern();
            if (!pattern.contains("E0")) {
                StringBuilder buffer = new StringBuilder(pattern);
                int split = pattern.indexOf(59);
                if (split >= 0) {
                    buffer.insert(split, "E0");
                }
                buffer.append("E0");
                decimalFormat.applyPattern(buffer.toString());
            }
            this.numberFormat = decimalFormat;
        } else {
            this.numberFormat = numberFormat;
            this.exponentSymbol = null;
        }
        this.ignoredElements = new LinkedHashMap<String, List<String>>();
    }

    abstract String getPublicFacade();

    String getFacadeMethod() {
        return "createFromWKT";
    }

    final void log(LogRecord record) {
        record.setSourceClassName(this.getPublicFacade());
        record.setSourceMethodName(this.getFacadeMethod());
        record.setLoggerName("org.apache.sis.io.wkt");
        LOGGER.log(record);
    }

    @Override
    public final Object createFromWKT(String wkt) throws FactoryException {
        Warnings warnings;
        ParsePosition position = new ParsePosition(0);
        Object result = null;
        try {
            result = this.createFromWKT(wkt, position);
        }
        catch (ParseException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof FactoryException) {
                throw (FactoryException)cause;
            }
            throw new FactoryException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        finally {
            Warnings warnings2 = this.getAndClearWarnings(result);
        }
        CharSequence unparsed = CharSequences.token((CharSequence)wkt, (int)position.getIndex());
        if (unparsed.length() != 0) {
            throw new FactoryException(Errors.getResources((Locale)this.errorLocale).getString((short)135, (Object)(CharSequences.token((CharSequence)wkt, (int)0) + "[\u2026]"), (Object)unparsed));
        }
        if (warnings != null) {
            this.log(new LogRecord(Level.WARNING, warnings.toString()));
        }
        return result;
    }

    Object createFromWKT(String text, ParsePosition position) throws ParseException {
        this.warnings = null;
        this.ignoredElements.clear();
        Element root = new Element(this.textToTree(text, position));
        Object result = this.buildFromTree(root);
        root.close(this.ignoredElements);
        return result;
    }

    static int endOfFragmentName(String text, int position) {
        int c;
        int length = text.length();
        while (position < length && Character.isUnicodeIdentifierPart(c = text.codePointAt(position))) {
            position += Character.charCount(c);
        }
        return position;
    }

    final Element textToTree(String wkt, ParsePosition position) throws ParseException {
        int upper;
        String id;
        StoredTree fragment;
        int lower = CharSequences.skipLeadingWhitespaces((CharSequence)wkt, (int)position.getIndex(), (int)wkt.length());
        if (lower >= wkt.length() || wkt.charAt(lower) != '$') {
            return new Element(this, wkt, position);
        }
        if ((fragment = this.fragments.get(id = wkt.substring(++lower, upper = AbstractParser.endOfFragmentName(wkt, lower)))) == null) {
            position.setErrorIndex(--lower);
            throw new UnparsableObjectException(this.errorLocale, 95, new Object[]{id}, lower);
        }
        position.setIndex(upper);
        SingletonElement singleton = new SingletonElement();
        fragment.toElements(this, singleton, -1);
        return singleton.value;
    }

    abstract Object buildFromTree(Element var1) throws ParseException;

    final Number parseNumber(String text, ParsePosition position) {
        int i;
        int base = position.getIndex();
        Number number = this.numberFormat.parse(text, position);
        if (number != null && this.exponentSymbol != null && text.regionMatches(true, i = position.getIndex(), this.exponentSymbol, 0, this.exponentSymbol.length())) {
            text = new StringBuilder(text).replace(i, i + this.exponentSymbol.length(), this.exponentSymbol).toString();
            position.setIndex(base);
            number = this.numberFormat.parse(text, position);
        }
        return number;
    }

    final Date parseDate(String text, ParsePosition position) {
        if (this.dateFormat == null) {
            this.dateFormat = new StandardDateFormat(this.symbols.getLocale());
        }
        return this.dateFormat.parse(text, position);
    }

    final Unit<?> parseUnit(String text) throws MeasurementParseException {
        if (this.unitFormat == null) {
            Locale locale = this.symbols.getLocale();
            if (locale == Locale.ROOT) {
                return Units.valueOf((String)text);
            }
            this.unitFormat = new UnitFormat(locale);
            this.unitFormat.setStyle(UnitFormat.Style.NAME);
        }
        return this.unitFormat.parse((CharSequence)text);
    }

    final void warning(Element parent, Element element, InternationalString message, Exception ex) {
        this.warning(parent, element != null ? element.keyword : null, message, ex);
    }

    final void warning(Element parent, String element, InternationalString message, Exception ex) {
        String[] stringArray;
        if (this.warnings == null) {
            this.warnings = new Warnings(this.errorLocale, true, this.ignoredElements);
        }
        if (parent != null && element != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = parent.keyword;
            stringArray = stringArray2;
            stringArray2[1] = element;
        } else {
            stringArray = null;
        }
        this.warnings.add(message, ex, stringArray);
    }

    final Warnings getAndClearWarnings(Object result) {
        Warnings w = this.warnings;
        this.warnings = null;
        if (w == null) {
            if (this.ignoredElements.isEmpty()) {
                return null;
            }
            w = new Warnings(this.errorLocale, true, this.ignoredElements);
        }
        w.setRoot(result);
        return w;
    }
}

