/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.util.Objects;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition1D
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8318842301025970006L;
    private CoordinateReferenceSystem crs;
    public double coordinate;

    public DirectPosition1D() {
    }

    public DirectPosition1D(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)1, (CoordinateReferenceSystem)crs);
        this.crs = crs;
    }

    public DirectPosition1D(double coordinate) {
        this.coordinate = coordinate;
    }

    public DirectPosition1D(CharSequence wkt) throws IllegalArgumentException {
        double[] coordinates = DirectPosition1D.parse(wkt);
        if (coordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)154, (Object)"POINT", (Object)wkt));
        }
        ArgumentChecks.ensureDimensionMatches((String)"wkt", (int)1, (double[])coordinates);
        this.coordinate = coordinates[0];
    }

    public final int getDimension() {
        return 1;
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)1, (CoordinateReferenceSystem)crs);
        this.crs = crs;
    }

    @Override
    public final double[] getCoordinate() {
        return new double[]{this.coordinate};
    }

    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            return this.coordinate;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)71, (Object)dimension));
    }

    @Override
    public void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        if (dimension != 0) {
            throw new IndexOutOfBoundsException(Errors.format((short)71, (Object)dimension));
        }
        this.coordinate = value;
    }

    @Override
    public void setLocation(DirectPosition position) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches((String)"position", (int)1, (DirectPosition)position);
        this.setCoordinateReferenceSystem(position.getCoordinateReferenceSystem());
        this.coordinate = position.getOrdinate(0);
    }

    @Override
    public String toString() {
        return DirectPosition1D.toString(this, this.coordinate == (double)((float)this.coordinate));
    }

    public DirectPosition1D clone() {
        try {
            return (DirectPosition1D)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public int hashCode() {
        int code = 31 + Double.hashCode(this.coordinate) + Objects.hashCode(this.crs);
        assert (code == super.hashCode());
        return code;
    }
}

