/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource.etree;

import java.util.Comparator;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.etree.IntervalStrategy;

public class IpResourceIntervalStrategy<T extends IpResource>
implements IntervalStrategy<T> {
    private final Comparator<T> upperBoundComparator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            return ((IpResource)o1).getEnd().compareTo(((IpResource)o2).getEnd());
        }
    };

    private IpResourceIntervalStrategy() {
    }

    public static <T extends IpResource> IpResourceIntervalStrategy<T> getInstance() {
        return new IpResourceIntervalStrategy<T>();
    }

    @Override
    public boolean contains(T left, T right) {
        return ((IpResource)left).contains((IpResource)right);
    }

    @Override
    public boolean overlaps(T left, T right) {
        return ((IpResource)left).overlaps((IpResource)right);
    }

    @Override
    public T singletonIntervalAtLowerBound(T interval) {
        return (T)((IpResource)interval).getStart().upTo(((IpResource)interval).getStart());
    }

    @Override
    public Comparator<T> upperBoundComparator() {
        return this.upperBoundComparator;
    }
}

