/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.apache.sis.feature.AbstractAttribute;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureType;
import org.apache.sis.feature.Field;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class FeatureFormat
extends TabularFormat<Object> {
    private static final long serialVersionUID = -5792086817264884947L;
    private static final String SEPARATOR = ", ";
    private static final AtomicReference<FeatureFormat> INSTANCE = new AtomicReference();
    private final Locale displayLocale;
    private final EnumSet<Column> columns = EnumSet.allOf(Column.class);
    private static final int MAXIMAL_VALUE_LENGTH = 40;
    private transient int illegalNaN;

    public FeatureFormat() {
        super(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
        this.displayLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.columnSeparator = " \u2502 ";
    }

    public FeatureFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.displayLocale = locale != null ? locale : Locale.ROOT;
        this.columnSeparator = " \u2502 ";
    }

    public final Class<Object> getValueType() {
        return Object.class;
    }

    public Locale getLocale(Locale.Category category) {
        return category == Locale.Category.DISPLAY ? this.displayLocale : super.getLocale(category);
    }

    public Set<Column> getAllowedColumns() {
        return this.columns.clone();
    }

    public void setAllowedColumns(Set<Column> inclusion) {
        ArgumentChecks.ensureNonNull((String)"inclusion", inclusion);
        this.columns.clear();
        this.columns.addAll(inclusion);
    }

    private void nextColumn(TableAppender table) {
        table.append((CharSequence)this.beforeFill);
        table.nextColumn(this.fillCharacter);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void format(Object object, Appendable toAppendTo) throws IOException {
        ArgumentChecks.ensureNonNull((String)"object", (Object)object);
        ArgumentChecks.ensureNonNull((String)"toAppendTo", (Object)toAppendTo);
        if (object instanceof AbstractFeature) {
            feature = (AbstractFeature)object;
            featureType = feature.getType();
        } else if (object instanceof DefaultFeatureType) {
            featureType = (DefaultFeatureType)object;
            feature = null;
        } else {
            throw new IllegalArgumentException(Errors.getResources((Locale)this.displayLocale).getString((short)163, object.getClass()));
        }
        visibleColumns = this.columns.clone();
        hasDesignation = false;
        hasCharacteristics = false;
        hasDeprecatedTypes = false;
        for (AbstractIdentifiedType propertyType : featureType.getProperties(true)) {
            if (!hasDesignation) {
                v0 = hasDesignation = propertyType.getDesignation() != null;
            }
            if (!hasCharacteristics && propertyType instanceof DefaultAttributeType) {
                v1 = hasCharacteristics = ((DefaultAttributeType)propertyType).characteristics().isEmpty() == false;
            }
            if (hasDeprecatedTypes || !(propertyType instanceof Deprecable)) continue;
            hasDeprecatedTypes = propertyType.isDeprecated();
        }
        if (!hasDesignation) {
            visibleColumns.remove((Object)Column.DESIGNATION);
        }
        if (!hasCharacteristics) {
            visibleColumns.remove((Object)Column.CHARACTERISTICS);
        }
        if (!hasDeprecatedTypes) {
            visibleColumns.remove((Object)Column.REMARKS);
        }
        toAppendTo.append(this.toString(featureType.getName()));
        if (feature == null) {
            separator = " \u21fe ";
            for (FeatureType parent : featureType.getSuperTypes()) {
                toAppendTo.append(separator).append(this.toString(parent.getName()));
                separator = ", ";
            }
            definition = featureType.getDefinition();
            if (definition != null && (text = Strings.trimOrNull((String)definition.toString(this.displayLocale))) != null) {
                toAppendTo.append(this.getLineSeparator()).append(text);
            }
        }
        toAppendTo.append(this.getLineSeparator());
        resources = Vocabulary.getResources((Locale)this.displayLocale);
        table = new TableAppender(toAppendTo, this.columnSeparator);
        table.setMultiLinesCells(true);
        table.nextLine('\u2500');
        isFirstColumn = true;
        var9_15 = visibleColumns.iterator();
        while (var9_15.hasNext()) {
            column = (Column)var9_15.next();
            key = column.resourceKey;
            if (feature == null) {
                if (key == 20) {
                    key = 138;
                }
                if (key == 213) {
                    key = 56;
                }
            }
            if (!isFirstColumn) {
                this.nextColumn(table);
            }
            table.append((CharSequence)resources.getString((short)key));
            isFirstColumn = false;
        }
        table.nextLine();
        table.nextLine('\u2500');
        buffer = new StringBuffer();
        dummyFP = new FieldPosition(-1);
        remarks = new ArrayList<String>();
        for (AbstractIdentifiedType propertyType : featureType.getProperties(true)) {
            value = null;
            cardinality = -1;
            if (feature != null) {
                if (!(propertyType instanceof DefaultAttributeType) && !(propertyType instanceof DefaultAssociationRole) && !DefaultFeatureType.isParameterlessOperation(propertyType)) continue;
                value = feature.getPropertyValue(propertyType.getName().toString());
                if (value == null) {
                    if (propertyType instanceof DefaultAttributeType && ((DefaultAttributeType)propertyType).getMinimumOccurs() == 0 && ((DefaultAttributeType)propertyType).characteristics().isEmpty() || propertyType instanceof DefaultAssociationRole && ((DefaultAssociationRole)propertyType).getMinimumOccurs() == 0) continue;
                    cardinality = 0;
                } else {
                    cardinality = value instanceof Collection ? ((Collection)value).size() : 1;
                }
            } else if (propertyType instanceof DefaultAttributeType) {
                value = ((DefaultAttributeType)propertyType).getDefaultValue();
            } else if (propertyType instanceof AbstractOperation) {
                buffer.append(" = ");
                try {
                    ((AbstractOperation)propertyType).formatResultFormula(buffer);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                value = CharSequences.trimWhitespaces((CharSequence)buffer).toString();
                buffer.setLength(0);
            }
            resultType = propertyType instanceof AbstractOperation != false ? ((AbstractOperation)propertyType).getResult() : propertyType;
            if (resultType instanceof DefaultAttributeType) {
                pt = (DefaultAttributeType)resultType;
                minimumOccurs = pt.getMinimumOccurs();
                maximumOccurs = pt.getMaximumOccurs();
                valueClass = pt.getValueClass();
                valueType = this.getFormat(Class.class).format(valueClass, buffer, dummyFP).toString();
                buffer.setLength(0);
            } else if (resultType instanceof DefaultAssociationRole) {
                pt = (DefaultAssociationRole)resultType;
                minimumOccurs = pt.getMinimumOccurs();
                maximumOccurs = pt.getMaximumOccurs();
                valueType = this.toString(DefaultAssociationRole.getValueTypeName((DefaultAssociationRole)pt));
                valueClass = AbstractFeature.class;
            } else {
                valueType = resultType != null ? this.toString(resultType.getName()) : "";
                valueClass = null;
                minimumOccurs = -1;
                maximumOccurs = -1;
            }
            isFirstColumn = true;
            var21_31 = visibleColumns.iterator();
            block17: while (var21_31.hasNext()) {
                column = (Column)var21_31.next();
                if (!isFirstColumn) {
                    this.nextColumn(table);
                }
                isFirstColumn = false;
                block2 : switch (1.$SwitchMap$org$apache$sis$feature$FeatureFormat$Column[column.ordinal()]) {
                    case 1: {
                        d = propertyType.getDesignation();
                        if (d == null) break;
                        table.append((CharSequence)d.toString(this.displayLocale));
                        break;
                    }
                    case 2: {
                        table.append((CharSequence)this.toString(propertyType.getName()));
                        break;
                    }
                    case 3: {
                        table.append((CharSequence)valueType);
                        break;
                    }
                    case 4: {
                        table.setCellAlignment((byte)1);
                        if (cardinality >= 0) {
                            table.append((CharSequence)this.getFormat(Integer.class).format(cardinality, buffer, dummyFP));
                            buffer.setLength(0);
                        }
                        if (maximumOccurs < 0) break;
                        if (cardinality >= 0) {
                            table.append(' ').append((char)(cardinality >= minimumOccurs && cardinality <= maximumOccurs ? 8712 : 8713)).append(' ');
                        }
                        format = this.getFormat(Integer.class);
                        table.append('[').append((CharSequence)format.format(minimumOccurs, buffer, dummyFP)).append((CharSequence)" \u2026 ");
                        buffer.setLength(0);
                        if (maximumOccurs != 0x7FFFFFFF) {
                            table.append((CharSequence)format.format(maximumOccurs, buffer, dummyFP));
                        } else {
                            table.append('\u221e');
                        }
                        buffer.setLength(0);
                        table.append(']');
                        break;
                    }
                    case 5: {
                        table.setCellAlignment((byte)-1);
                        format = this.getFormat(valueClass);
                        it = CollectionsExt.toCollection((Object)value).iterator();
                        separator = "";
                        length = 0;
                        while (it.hasNext()) {
                            value = it.next();
                            if (value == null) continue;
                            if (!(propertyType instanceof DefaultAssociationRole)) ** GOTO lbl178
                            p = DefaultAssociationRole.getTitleProperty((DefaultAssociationRole)propertyType);
                            if (p != null && (value = ((AbstractFeature)value).getPropertyValue(p)) == null) {
                                continue;
                            }
                            ** GOTO lbl198
lbl178:
                            // 1 sources

                            if (format == null || !valueClass.isInstance(value)) ** GOTO lbl198
                            t = format.format(value, buffer, dummyFP);
                            if (!(value instanceof Number) || !Float.isNaN(f = ((Number)value).floatValue())) ** GOTO lbl197
                            if ("\ufffd".contentEquals(t)) {
                                t.setLength(0);
                                t.append("NaN");
                            }
                            try {
                                n = MathFunctions.toNanOrdinal((float)f);
                                if (n > 0) {
                                    t.append(" #").append(n);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                bits = Float.floatToRawIntBits(f);
                                if (bits == this.illegalNaN) ** GOTO lbl197
                                this.illegalNaN = bits;
                                Logging.recoverableException((Logger)AbstractIdentifiedType.LOGGER, FeatureFormat.class, (String)"format", (Throwable)e);
                            }
lbl197:
                            // 4 sources

                            value = t;
lbl198:
                            // 3 sources

                            length = this.formatValue(value, table.append((CharSequence)separator), length);
                            buffer.setLength(0);
                            if (length < 0) break block2;
                            separator = ", ";
                            length += ", ".length();
                        }
                        break;
                    }
                    case 6: {
                        if (!(propertyType instanceof DefaultAttributeType)) break;
                        length = 0;
                        separator = "";
                        for (DefaultAttributeType<?> ct : ((DefaultAttributeType)propertyType).characteristics().values()) {
                            cn = ct.getName();
                            cs = this.toString(cn);
                            table.append((CharSequence)separator).append((CharSequence)cs);
                            length += separator.length() + cs.length();
                            cv /* !! */  = CollectionsExt.singletonOrEmpty(ct.getDefaultValue());
                            if (feature != null && (cp = feature.getProperty(propertyType.getName().toString())) instanceof AbstractAttribute && (ca = ((AbstractAttribute)cp).characteristics().get(cn.toString())) != null) {
                                cv /* !! */  = ca.getValues();
                            }
                            multi = ct.getMaximumOccurs() > 1;
                            sep = multi != false ? " = {" : " = ";
                            for (E c : cv /* !! */ ) {
                                length += sep.length();
                                length = this.formatValue(c, table.append((CharSequence)sep), length);
                                if (length < 0) break block2;
                                sep = ", ";
                            }
                            separator = ", ";
                            if (!multi || sep != ", ") continue;
                            table.append('}');
                        }
                        continue block17;
                    }
                    case 7: {
                        if (!Field.isDeprecated(propertyType)) break;
                        table.append((CharSequence)resources.getString((short)57));
                        r = propertyType.getRemarks();
                        if (r == null) break;
                        remarks.add(r.toString(this.displayLocale));
                        FeatureFormat.appendSuperscript(remarks.size(), (Appendable)table);
                    }
                }
            }
            table.nextLine();
        }
        table.nextLine('\u2500');
        table.flush();
        n = remarks.size();
        for (i = 0; i < n; ++i) {
            FeatureFormat.appendSuperscript(i + 1, toAppendTo);
            toAppendTo.append(' ').append((CharSequence)remarks.get(i)).append(this.lineSeparator);
        }
    }

    private String toString(GenericName name) {
        String s;
        if (name == null) {
            return "";
        }
        InternationalString i18n = name.toInternationalString();
        if (i18n != null && (s = i18n.toString(this.displayLocale)) != null) {
            return s;
        }
        return name.toString();
    }

    private int formatValue(Object value, TableAppender table, int length) {
        int remaining = 40 - length;
        String text = value instanceof InternationalString ? ((InternationalString)value).toString(this.displayLocale) : (value instanceof GenericName ? this.toString((GenericName)value) : (value instanceof AbstractIdentifiedType ? this.toString(((AbstractIdentifiedType)value).getName()) : (value instanceof IdentifiedObject ? IdentifiedObjects.getIdentifierOrName((IdentifiedObject)((IdentifiedObject)value)) : Geometries.wrap(value).map(GeometryWrapper::toString).orElseGet(value::toString))));
        if (remaining >= text.length()) {
            table.append((CharSequence)text);
            return length + text.length();
        }
        table.append((CharSequence)text, 0, Math.max(0, remaining - 1)).append('\u2026');
        return -1;
    }

    private static void appendSuperscript(int n, Appendable toAppendTo) throws IOException {
        if (n >= 0 && n < 10) {
            toAppendTo.append(Characters.toSuperScript((char)((char)(48 + n))));
        } else {
            toAppendTo.append('(').append(String.valueOf(n)).append(')');
        }
    }

    static String sharedFormat(Object object) {
        FeatureFormat f = INSTANCE.getAndSet(null);
        if (f == null) {
            f = new FeatureFormat();
        }
        String s = f.format(object);
        INSTANCE.set(f);
        return s;
    }

    public Object parse(CharSequence text, ParsePosition pos) throws ParseException {
        throw new ParseException(Errors.getResources((Locale)this.displayLocale).getString((short)162, (Object)"parse"), pos.getIndex());
    }

    public FeatureFormat clone() {
        return (FeatureFormat)super.clone();
    }

    public static enum Column {
        DESIGNATION(60),
        NAME(139),
        TYPE(203),
        CARDINALITY(20),
        VALUE(213),
        CHARACTERISTICS(26),
        REMARKS(169);

        final short resourceKey;

        private Column(short key) {
            this.resourceKey = key;
        }
    }
}

