/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import java.util.List;
import java.util.Objects;

public final class AnnotatedServiceExtensions {
    private final List<RequestConverterFunction> requestConverters;
    private final List<ResponseConverterFunction> responseConverters;
    private final List<ExceptionHandlerFunction> exceptionHandlers;

    public static AnnotatedServiceExtensions ofExceptionHandlersAndConverters(Iterable<?> exceptionHandlersAndConverters) {
        ImmutableList.Builder requestConverters = ImmutableList.builder();
        ImmutableList.Builder responseConverters = ImmutableList.builder();
        ImmutableList.Builder exceptionHandlers = ImmutableList.builder();
        for (Object o : exceptionHandlersAndConverters) {
            if (o instanceof RequestConverterFunction) {
                requestConverters.add((RequestConverterFunction)o);
                continue;
            }
            if (o instanceof ResponseConverterFunction) {
                responseConverters.add((ResponseConverterFunction)o);
                continue;
            }
            if (o instanceof ExceptionHandlerFunction) {
                exceptionHandlers.add((ExceptionHandlerFunction)o);
                continue;
            }
            throw new IllegalArgumentException(o.getClass().getName() + " is neither an exception handler nor a converter.");
        }
        return new AnnotatedServiceExtensions((List<RequestConverterFunction>)((Object)requestConverters.build()), (List<ResponseConverterFunction>)((Object)responseConverters.build()), (List<ExceptionHandlerFunction>)((Object)exceptionHandlers.build()));
    }

    public AnnotatedServiceExtensions(List<RequestConverterFunction> requestConverters, List<ResponseConverterFunction> responseConverters, List<ExceptionHandlerFunction> exceptionHandlers) {
        this.requestConverters = Objects.requireNonNull(requestConverters, "requestConverters");
        this.responseConverters = Objects.requireNonNull(responseConverters, "responseConverters");
        this.exceptionHandlers = Objects.requireNonNull(exceptionHandlers, "exceptionHandlers");
    }

    public List<RequestConverterFunction> requestConverters() {
        return this.requestConverters;
    }

    public List<ResponseConverterFunction> responseConverters() {
        return this.responseConverters;
    }

    public List<ExceptionHandlerFunction> exceptionHandlers() {
        return this.exceptionHandlers;
    }
}

