/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.asn1;

import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Encodable;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1OutputStream;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1Primitive;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1String;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1TaggedObject;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.ASN1UniversalType;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DEROctetString;
import com.linecorp.armeria.internal.shaded.bouncycastle.asn1.DERUniversalString;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.Arrays;
import java.io.IOException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class ASN1UniversalString
extends ASN1Primitive
implements ASN1String {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1UniversalString.class, 28){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
            return ASN1UniversalString.createPrimitive(dEROctetString.getOctets());
        }
    };
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final byte[] contents;

    public static ASN1UniversalString getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof ASN1UniversalString) {
            return (ASN1UniversalString)object;
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1UniversalString) {
            return (ASN1UniversalString)aSN1Primitive;
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1UniversalString)TYPE.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1UniversalString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return (ASN1UniversalString)TYPE.getContextInstance(aSN1TaggedObject, bl);
    }

    ASN1UniversalString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    @Override
    public final String getString() {
        int n = this.contents.length;
        StringBuffer stringBuffer = new StringBuffer(3 + 2 * (ASN1OutputStream.getLengthOfDL(n) + n));
        stringBuffer.append("#1C");
        ASN1UniversalString.encodeHexDL(stringBuffer, n);
        for (int i = 0; i < n; ++i) {
            ASN1UniversalString.encodeHexByte(stringBuffer, this.contents[i]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getString();
    }

    public final byte[] getOctets() {
        return Arrays.clone(this.contents);
    }

    @Override
    final boolean encodeConstructed() {
        return false;
    }

    @Override
    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    @Override
    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 28, this.contents);
    }

    @Override
    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1UniversalString)) {
            return false;
        }
        ASN1UniversalString aSN1UniversalString = (ASN1UniversalString)aSN1Primitive;
        return Arrays.areEqual(this.contents, aSN1UniversalString.contents);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1UniversalString createPrimitive(byte[] byArray) {
        return new DERUniversalString(byArray, false);
    }

    private static void encodeHexByte(StringBuffer stringBuffer, int n) {
        stringBuffer.append(table[n >>> 4 & 0xF]);
        stringBuffer.append(table[n & 0xF]);
    }

    private static void encodeHexDL(StringBuffer stringBuffer, int n) {
        if (n < 128) {
            ASN1UniversalString.encodeHexByte(stringBuffer, n);
            return;
        }
        byte[] byArray = new byte[5];
        int n2 = 5;
        do {
            byArray[--n2] = (byte)n;
        } while ((n >>>= 8) != 0);
        int n3 = byArray.length - n2;
        byArray[--n2] = (byte)(0x80 | n3);
        do {
            ASN1UniversalString.encodeHexByte(stringBuffer, byArray[n2++]);
        } while (n2 < byArray.length);
    }
}

