/*
 * Decompiled with CFR 0.152.
 */
package de.bytefish.pgbulkinsert.pgsql.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

public class TimeStampUtils {
    private static final LocalDateTime JavaEpoch = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
    private static final LocalDateTime PostgresEpoch = LocalDateTime.of(2000, 1, 1, 0, 0, 0);
    private static final long DaysBetweenJavaAndPostgresEpochs = ChronoUnit.DAYS.between(JavaEpoch, PostgresEpoch);

    private TimeStampUtils() {
    }

    public static long convertToPostgresTimeStamp(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            throw new IllegalArgumentException("localDateTime");
        }
        long timeInNanoseconds = localDateTime.toLocalTime().toNanoOfDay();
        long timeInMicroseconds = timeInNanoseconds / 1000L;
        if (localDateTime.isBefore(PostgresEpoch)) {
            long dateInMicroseconds = (localDateTime.toLocalDate().toEpochDay() - DaysBetweenJavaAndPostgresEpochs) * 86400000000L;
            return dateInMicroseconds + timeInMicroseconds;
        }
        long dateInMicroseconds = (DaysBetweenJavaAndPostgresEpochs - localDateTime.toLocalDate().toEpochDay()) * 86400000000L;
        return -(dateInMicroseconds - timeInMicroseconds);
    }

    public static int toPgDays(LocalDate date) {
        LocalDateTime dateTime = date.atStartOfDay();
        long secs = TimeStampUtils.toPgSecs(TimeStampUtils.getSecondsSinceJavaEpoch(dateTime));
        return (int)TimeUnit.SECONDS.toDays(secs);
    }

    public static Long toPgSecs(LocalDateTime dateTime) {
        long secs = TimeStampUtils.toPgSecs(TimeStampUtils.getSecondsSinceJavaEpoch(dateTime));
        return TimeUnit.SECONDS.toMicros(secs);
    }

    private static long getSecondsSinceJavaEpoch(LocalDateTime localDateTime) {
        OffsetDateTime zdt = localDateTime.atOffset(ZoneOffset.UTC);
        long milliseconds = zdt.toInstant().toEpochMilli();
        return TimeUnit.MILLISECONDS.toSeconds(milliseconds);
    }

    private static long toPgSecs(long seconds) {
        long secs = seconds;
        if ((secs -= 946684800L) < -13165977600L && (secs -= 864000L) < -15773356800L) {
            int years = (int)((secs + 15773356800L) / -3155823050L);
            ++years;
            years -= years / 4;
            secs += (long)(years * 86400);
        }
        return secs;
    }
}

