/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.processors.metric.impl.HistogramMetricImpl;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.pool.MetricsAwareExecutorService;
import org.apache.ignite.internal.processors.pool.PoolProcessor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.thread.IgniteThreadFactory;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class IgniteStripedThreadPoolExecutor
implements ExecutorService,
MetricsAwareExecutorService {
    private final IgniteThreadPoolExecutor[] execs;
    @GridToStringExclude
    private volatile HistogramMetricImpl execTime;

    public IgniteStripedThreadPoolExecutor(int concurrentLvl, String igniteInstanceName, String threadNamePrefix, Thread.UncaughtExceptionHandler eHnd, boolean allowCoreThreadTimeOut, long keepAliveTime) {
        this.execs = new IgniteThreadPoolExecutor[concurrentLvl];
        this.execTime = new HistogramMetricImpl("TaskExecutionTime", "Approximate total number of tasks that have been scheduled for execution.", PoolProcessor.TASK_EXEC_TIME_HISTOGRAM_BUCKETS);
        IgniteThreadFactory factory = new IgniteThreadFactory(igniteInstanceName, threadNamePrefix, eHnd);
        for (int i = 0; i < concurrentLvl; ++i) {
            IgniteThreadPoolExecutor executor = new IgniteThreadPoolExecutor(1, 1, keepAliveTime, new LinkedBlockingQueue<Runnable>(), factory, this.execTime);
            executor.allowCoreThreadTimeOut(allowCoreThreadTimeOut);
            this.execs[i] = executor;
        }
    }

    public void execute(Runnable task, int idx) {
        this.execs[this.threadId(idx)].execute(task);
    }

    public int threadId(int idx) {
        return idx < this.execs.length ? idx : idx % this.execs.length;
    }

    @Override
    public void shutdown() {
        for (IgniteThreadPoolExecutor exec : this.execs) {
            exec.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.execs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Runnable> res = new ArrayList<Runnable>(this.execs.length);
        for (IgniteThreadPoolExecutor exec : this.execs) {
            for (Runnable r : exec.shutdownNow()) {
                res.add(r);
            }
        }
        return res;
    }

    @Override
    public boolean isShutdown() {
        for (IgniteThreadPoolExecutor exec : this.execs) {
            if (exec.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (IgniteThreadPoolExecutor exec : this.execs) {
            if (exec.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        boolean res = true;
        for (IgniteThreadPoolExecutor exec : this.execs) {
            res &= exec.awaitTermination(timeout, unit);
        }
        return res;
    }

    @Override
    @NotNull
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> Future<T> submit(Runnable task, T res) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void execute(Runnable cmd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerMetrics(MetricRegistryImpl mreg) {
        mreg.register("ActiveCount", this::activeCount, "Approximate number of threads that are actively executing tasks.");
        mreg.register("CompletedTaskCount", this::completedTaskCount, "Approximate total number of tasks that have completed execution.");
        mreg.intMetric("CorePoolSize", "The core number of threads.").value(this.execs.length);
        mreg.register("LargestPoolSize", this::largestPoolSize, "Largest number of threads that have ever simultaneously been in the pool.");
        mreg.intMetric("MaximumPoolSize", "The maximum allowed number of threads.").value(this.execs.length);
        mreg.register("PoolSize", this::poolSize, "Current number of threads in the pool.");
        mreg.register("TaskCount", this::taskCount, "Approximate total number of tasks that have been scheduled for execution.");
        mreg.register("QueueSize", this::queueSize, "Current size of the execution queue.");
        mreg.longMetric("KeepAliveTime", "Thread keep-alive time, which is the amount of time which threads in excess of the core pool size may remain idle before being terminated.").value(this.execs[0].getKeepAliveTime(TimeUnit.MILLISECONDS));
        mreg.register("Shutdown", this::isShutdown, "True if this executor has been shut down.");
        mreg.register("Terminated", this::isTerminated, "True if all tasks have completed following shut down.");
        mreg.register("Terminating", this::terminating, "True if terminating but not yet terminated.");
        mreg.objectMetric("RejectedExecutionHandlerClass", String.class, "Class name of current rejection handler.").value(this.execs[0].getRejectedExecutionHandler().getClass().getName());
        mreg.objectMetric("ThreadFactoryClass", String.class, "Class name of thread factory used to create new threads.").value(this.execs[0].getThreadFactory().getClass().getName());
        HistogramMetricImpl execTime0 = this.execTime;
        this.execTime = new HistogramMetricImpl(MetricUtils.metricName(mreg.name(), "TaskExecutionTime"), execTime0);
        mreg.register(this.execTime);
        for (IgniteThreadPoolExecutor exec : this.execs) {
            exec.executionTimeMetric(this.execTime);
        }
    }

    private boolean terminating() {
        for (IgniteThreadPoolExecutor exec : this.execs) {
            if (exec.isTerminating()) continue;
            return false;
        }
        return true;
    }

    private int queueSize() {
        int queueSize = 0;
        for (IgniteThreadPoolExecutor exec : this.execs) {
            queueSize += exec.getQueue().size();
        }
        return queueSize;
    }

    private long taskCount() {
        long taskCnt = 0L;
        for (IgniteThreadPoolExecutor exec : this.execs) {
            taskCnt += exec.getTaskCount();
        }
        return taskCnt;
    }

    private long completedTaskCount() {
        long completedTaskCnt = 0L;
        for (IgniteThreadPoolExecutor exec : this.execs) {
            completedTaskCnt += exec.getCompletedTaskCount();
        }
        return completedTaskCnt;
    }

    private int activeCount() {
        int activeCnt = 0;
        for (IgniteThreadPoolExecutor exec : this.execs) {
            activeCnt += exec.getActiveCount();
        }
        return activeCnt;
    }

    private int poolSize() {
        int poolSize = 0;
        for (IgniteThreadPoolExecutor exec : this.execs) {
            poolSize += exec.getPoolSize();
        }
        return poolSize;
    }

    private int largestPoolSize() {
        int largestPoolSize = 0;
        for (IgniteThreadPoolExecutor exec : this.execs) {
            largestPoolSize += exec.getLargestPoolSize();
        }
        return largestPoolSize;
    }

    public String toString() {
        return S.toString(IgniteStripedThreadPoolExecutor.class, this);
    }
}

