/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridInternalWrapper;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.IgniteSecurityProcessor;
import org.apache.ignite.internal.processors.security.OperationSecurityContext;
import org.apache.ignite.internal.processors.security.SecurityContext;
import org.apache.ignite.internal.processors.security.sandbox.IgniteDomainCombiner;
import org.apache.ignite.internal.processors.security.sandbox.IgniteSandbox;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.security.SecurityCredentials;
import org.apache.ignite.plugin.security.SecurityException;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.apache.ignite.plugin.security.SecurityPermissionSet;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.DiscoverySpiNodeAuthenticator;

public class SecurityUtils {
    public static final String MSG_SEC_PROC_CLS_IS_INVALID = "Local node's grid security processor class is not equal to remote node's grid security processor class [locNodeId=%s, rmtNodeId=%s, locCls=%s, rmtCls=%s]";
    public static final String IGNITE_INTERNAL_PACKAGE = "org.apache.ignite.internal";
    private static final int DFLT_SERIALIZE_VERSION = SecurityUtils.isSecurityCompatibilityMode() ? 1 : 2;
    private static final ThreadLocal<Integer> SERIALIZE_VERSION = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return DFLT_SERIALIZE_VERSION;
        }
    };
    public static final Permissions ALL_PERMISSIONS = new Permissions();

    private SecurityUtils() {
    }

    public static boolean isSecurityCompatibilityMode() {
        return IgniteSystemProperties.getBoolean("IGNITE_SECURITY_COMPATIBILITY_MODE", false);
    }

    public static void serializeVersion(int ver) {
        SERIALIZE_VERSION.set(ver);
    }

    public static int serializeVersion() {
        return SERIALIZE_VERSION.get();
    }

    public static void restoreDefaultSerializeVersion() {
        SecurityUtils.serializeVersion(DFLT_SERIALIZE_VERSION);
    }

    public static Map<String, Collection<SecurityPermission>> compatibleServicePermissions() {
        HashMap<String, Collection<SecurityPermission>> srvcPerms = new HashMap<String, Collection<SecurityPermission>>();
        srvcPerms.put("*", Arrays.asList(SecurityPermission.SERVICE_CANCEL, SecurityPermission.SERVICE_DEPLOY, SecurityPermission.SERVICE_INVOKE));
        return srvcPerms;
    }

    public static SecurityContext nodeSecurityContext(Marshaller marsh, ClassLoader ldr, ClusterNode node) {
        A.notNull(node, "Cluster node");
        byte[] subjBytes = (byte[])node.attribute("org.apache.ignite.security.subject.v2");
        if (subjBytes == null) {
            throw new SecurityException("Security context isn't certain.");
        }
        try {
            return (SecurityContext)U.unmarshal(marsh, subjBytes, ldr);
        }
        catch (IgniteCheckedException e) {
            throw new SecurityException("Failed to get security context.", e);
        }
    }

    public static SecurityContext remoteSecurityContext(GridKernalContext ctx) {
        IgniteSecurity security = ctx.security();
        if (!security.enabled() || security.isDefaultContext()) {
            return null;
        }
        return security.securityContext();
    }

    public static UUID securitySubjectId(GridKernalContext ctx) {
        IgniteSecurity security = ctx.security();
        return security.enabled() ? security.securityContext().subject().id() : null;
    }

    public static UUID securitySubjectId(GridCacheContext<?, ?> cctx) {
        return SecurityUtils.securitySubjectId(cctx.kernalContext());
    }

    public static UUID securitySubjectId(GridCacheSharedContext<?, ?> cctx) {
        return SecurityUtils.securitySubjectId(cctx.kernalContext());
    }

    public static OperationSecurityContext withRemoteSecurityContext(GridKernalContext ctx, SecurityContext secCtx) {
        if (secCtx == null) {
            return null;
        }
        return ctx.security().withContext(secCtx);
    }

    public static <T, E extends Exception> T doPrivileged(Callable<T> c) throws E {
        try {
            return (T)AccessController.doPrivileged(c::call);
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static boolean hasSecurityManager() {
        return System.getSecurityManager() != null;
    }

    public static boolean isSystemType(GridKernalContext ctx, Object target, boolean considerWrapperCls) {
        if (considerWrapperCls) {
            target = SecurityUtils.unwrap(target);
        }
        return ctx.security().isSystemType(target.getClass());
    }

    public static Object unwrap(Object target) {
        return target instanceof GridInternalWrapper ? ((GridInternalWrapper)target).userObject() : target;
    }

    public static boolean isInIgnitePackage(Class<?> cls) {
        return IgniteUtils.packageName(cls).startsWith("org.apache.ignite.");
    }

    public static boolean isInsideSandbox() {
        if (!IgniteSecurityProcessor.hasSandboxedNodes()) {
            return false;
        }
        AccessControlContext ctx = AccessController.getContext();
        return AccessController.doPrivileged(() -> ctx.getDomainCombiner() instanceof IgniteDomainCombiner);
    }

    public static <T> T sandboxedProxy(GridKernalContext ctx, Class cls, T instance) {
        if (instance == null) {
            return null;
        }
        Objects.requireNonNull(ctx, "Parameter 'ctx' cannot be null.");
        Objects.requireNonNull(cls, "Parameter 'cls' cannot be null.");
        IgniteSandbox sandbox = ctx.security().sandbox();
        if (sandbox.enabled() && !SecurityUtils.isSystemType(ctx, instance, true)) {
            return (T)Proxy.newProxyInstance(sandbox.getClass().getClassLoader(), SecurityUtils.proxyClasses(cls, instance), new SandboxInvocationHandler(sandbox, instance));
        }
        return instance;
    }

    private static <T> Class[] proxyClasses(Class cls, T instance) {
        Class[] classArray;
        if (instance instanceof GridInternalWrapper) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = cls;
            classArray = classArray2;
            classArray2[1] = GridInternalWrapper.class;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = cls;
        }
        return classArray;
    }

    public static Map<String, Object> withSecurityContext(SecurityContext secCtx, Map<String, Object> nodeAttrs, Marshaller marsh) throws IgniteCheckedException {
        if (!(secCtx instanceof Serializable)) {
            throw new IgniteSpiException("Authentication subject is not serializable.");
        }
        HashMap<String, Object> res = new HashMap<String, Object>(nodeAttrs);
        res.put("org.apache.ignite.security.subject.v2", U.marshal(marsh, (Object)secCtx));
        return res;
    }

    public static SecurityContext authenticateLocalNode(ClusterNode node, SecurityCredentials cred, DiscoverySpiNodeAuthenticator nodeAuth) {
        assert (nodeAuth != null);
        assert (cred != null || node.attribute("org.apache.ignite.authentication.enabled") != null);
        SecurityContext secCtx = nodeAuth.authenticateNode(node, cred);
        if (secCtx == null) {
            throw new IgniteSpiException("Authentication failed for local node: " + node.id());
        }
        return secCtx;
    }

    public static void authorizeAll(IgniteSecurity security, SecurityPermissionSet permissions) {
        if (!security.enabled()) {
            return;
        }
        if (permissions.systemPermissions() != null) {
            for (SecurityPermission permission : permissions.systemPermissions()) {
                security.authorize(permission);
            }
        }
        SecurityUtils.authorizeAll(security, permissions.cachePermissions());
        SecurityUtils.authorizeAll(security, permissions.taskPermissions());
        SecurityUtils.authorizeAll(security, permissions.servicePermissions());
    }

    private static void authorizeAll(IgniteSecurity security, Map<String, Collection<SecurityPermission>> permissions) {
        if (F.isEmpty(permissions)) {
            return;
        }
        permissions.forEach((name, permsPerName) -> permsPerName.forEach(perm -> security.authorize((String)name, (SecurityPermission)((Object)((Object)perm)))));
    }

    static {
        ALL_PERMISSIONS.add(new AllPermission());
        ALL_PERMISSIONS.setReadOnly();
    }

    private static class SandboxInvocationHandler<T>
    implements InvocationHandler {
        private final IgniteSandbox sandbox;
        private final Object original;

        public SandboxInvocationHandler(IgniteSandbox sandbox, Object original) {
            this.sandbox = sandbox;
            this.original = original;
        }

        @Override
        public Object invoke(Object proxy, Method mtd, Object[] args) throws Throwable {
            try {
                if (proxy instanceof GridInternalWrapper && GridInternalWrapper.class.getMethod(mtd.getName(), mtd.getParameterTypes()) != null) {
                    return mtd.invoke(this.original, args);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return this.sandbox.execute(() -> {
                try {
                    return mtd.invoke(this.original, args);
                }
                catch (InvocationTargetException e) {
                    throw new IgniteException(e.getTargetException());
                }
            });
        }
    }
}

