/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.messaging;

import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractTarget;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTarget;
import org.apache.ignite.internal.processors.platform.message.PlatformMessageFilter;
import org.apache.ignite.internal.processors.platform.messaging.PlatformMessageLocalFilter;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.lang.IgniteFuture;

public class PlatformMessaging
extends PlatformAbstractTarget {
    public static final int OP_LOC_LISTEN = 1;
    public static final int OP_REMOTE_LISTEN = 2;
    public static final int OP_SEND = 3;
    public static final int OP_SEND_MULTI = 4;
    public static final int OP_SEND_ORDERED = 5;
    public static final int OP_STOP_LOC_LISTEN = 6;
    public static final int OP_STOP_REMOTE_LISTEN = 7;
    public static final int OP_WITH_ASYNC = 8;
    public static final int OP_REMOTE_LISTEN_ASYNC = 9;
    public static final int OP_STOP_REMOTE_LISTEN_ASYNC = 10;
    private final IgniteMessaging messaging;

    public PlatformMessaging(PlatformContext platformCtx, IgniteMessaging messaging) {
        super(platformCtx);
        assert (messaging != null);
        this.messaging = messaging;
    }

    @Override
    public long processInStreamOutLong(int type, BinaryRawReaderEx reader) throws IgniteCheckedException {
        switch (type) {
            case 3: {
                this.messaging.send(reader.readObjectDetached(), reader.readObjectDetached());
                return 1L;
            }
            case 4: {
                this.messaging.send(reader.readObjectDetached(), PlatformUtils.readCollection(reader));
                return 1L;
            }
            case 5: {
                this.messaging.sendOrdered(reader.readObjectDetached(), reader.readObjectDetached(), reader.readLong());
                return 1L;
            }
            case 1: {
                PlatformMessageLocalFilter filter = new PlatformMessageLocalFilter(reader.readLong(), this.platformCtx);
                Object topic = reader.readObjectDetached();
                this.messaging.localListen(topic, filter);
                return 1L;
            }
            case 6: {
                PlatformMessageLocalFilter filter = new PlatformMessageLocalFilter(reader.readLong(), this.platformCtx);
                Object topic = reader.readObjectDetached();
                this.messaging.stopLocalListen(topic, filter);
                return 1L;
            }
            case 7: {
                this.messaging.stopRemoteListen(reader.readUuid());
                return 1L;
            }
            case 9: {
                this.readAndListenFuture((BinaryRawReader)reader, this.startRemoteListenAsync(reader, this.messaging));
                return 1L;
            }
            case 10: {
                this.readAndListenFuture((BinaryRawReader)reader, this.messaging.stopRemoteListenAsync(reader.readUuid()));
                return 1L;
            }
        }
        return super.processInStreamOutLong(type, reader);
    }

    @Override
    public void processInStreamOutStream(int type, BinaryRawReaderEx reader, BinaryRawWriterEx writer) throws IgniteCheckedException {
        switch (type) {
            case 2: {
                writer.writeUuid(this.startRemoteListen(reader, this.messaging));
                break;
            }
            default: {
                super.processInStreamOutStream(type, reader, writer);
            }
        }
    }

    private UUID startRemoteListen(BinaryRawReaderEx reader, IgniteMessaging messaging) {
        Object nativeFilter = reader.readObjectDetached();
        long ptr = reader.readLong();
        Object topic = reader.readObjectDetached();
        PlatformMessageFilter filter = this.platformCtx.createRemoteMessageFilter(nativeFilter, ptr);
        return messaging.remoteListen(topic, filter);
    }

    private IgniteFuture<UUID> startRemoteListenAsync(BinaryRawReaderEx reader, IgniteMessaging messaging) {
        Object nativeFilter = reader.readObjectDetached();
        long ptr = reader.readLong();
        Object topic = reader.readObjectDetached();
        PlatformMessageFilter filter = this.platformCtx.createRemoteMessageFilter(nativeFilter, ptr);
        return messaging.remoteListenAsync(topic, filter);
    }

    @Override
    public PlatformTarget processOutObject(int type) throws IgniteCheckedException {
        switch (type) {
            case 8: {
                if (this.messaging.isAsync()) {
                    return this;
                }
                return new PlatformMessaging(this.platformCtx, this.messaging.withAsync());
            }
        }
        return super.processOutObject(type);
    }
}

