/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.index;

import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowConverter;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.ColumnsExtractor;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.table.distributed.index.VersionedConverter;

class TableRowToIndexKeyConverter
implements ColumnsExtractor {
    private final SchemaRegistry registry;
    private final String[] indexedColumns;
    private final Object mutex = new Object();
    private volatile VersionedConverter converter = new VersionedConverter(-1, null);

    TableRowToIndexKeyConverter(SchemaRegistry registry, String[] indexedColumns) {
        this.registry = registry;
        this.indexedColumns = indexedColumns;
    }

    @Override
    public BinaryTuple extractColumns(BinaryRow row) {
        return this.converter(row).extractColumns(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnsExtractor converter(BinaryRow row) {
        int schemaVersion = row.schemaVersion();
        VersionedConverter converter = this.converter;
        if (converter.version() != schemaVersion) {
            Object object = this.mutex;
            synchronized (object) {
                converter = this.converter;
                if (converter.version() != schemaVersion) {
                    this.converter = converter = this.createConverter(schemaVersion);
                }
            }
        }
        return converter;
    }

    private VersionedConverter createConverter(int schemaVersion) {
        SchemaDescriptor descriptor = this.registry.schema(schemaVersion);
        int[] indexedColumns = this.resolveColumnIndexes(descriptor);
        BinaryRowConverter rowConverter = BinaryRowConverter.columnsExtractor(descriptor, indexedColumns);
        return new VersionedConverter(descriptor.version(), rowConverter);
    }

    private int[] resolveColumnIndexes(SchemaDescriptor descriptor) {
        int[] result = new int[this.indexedColumns.length];
        for (int i = 0; i < this.indexedColumns.length; ++i) {
            Column column = descriptor.column(this.indexedColumns[i]);
            assert (column != null) : "schemaVersion=" + descriptor.version() + ", column=" + this.indexedColumns[i];
            result[i] = column.positionInRow();
        }
        return result;
    }
}

