/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.events;

import java.util.UUID;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.eventlog.event.EventUser;
import org.apache.ignite3.internal.security.authentication.UserDetails;
import org.jetbrains.annotations.Nullable;

public class ComputeEventMetadataBuilder {
    private EventUser eventUser;
    private ComputeEventMetadata.Type type;
    private String jobClassName;
    @Nullable
    private UUID jobId;
    private String targetNode;
    private String initiatorNode;
    @Nullable
    private UUID taskId;
    @Nullable
    private String tableName;
    @Nullable
    private String clientAddress;

    ComputeEventMetadataBuilder type(ComputeEventMetadata.Type type) {
        this.type = type;
        return this;
    }

    public ComputeEventMetadataBuilder eventUser(UserDetails userDetails) {
        this.eventUser = EventUser.of(userDetails.username(), userDetails.providerName());
        return this;
    }

    public ComputeEventMetadataBuilder jobClassName(String jobClassName) {
        this.jobClassName = jobClassName;
        return this;
    }

    public ComputeEventMetadataBuilder jobId(@Nullable UUID jobId) {
        this.jobId = jobId;
        return this;
    }

    @Nullable
    public UUID jobId() {
        return this.jobId;
    }

    public ComputeEventMetadataBuilder targetNode(String targetNode) {
        this.targetNode = targetNode;
        return this;
    }

    public ComputeEventMetadataBuilder initiatorNode(String initiatorNode) {
        this.initiatorNode = initiatorNode;
        return this;
    }

    public ComputeEventMetadataBuilder taskId(@Nullable UUID taskId) {
        this.taskId = taskId;
        return this;
    }

    public ComputeEventMetadataBuilder tableName(@Nullable String tableName) {
        this.tableName = tableName;
        return this;
    }

    public ComputeEventMetadataBuilder clientAddress(@Nullable String clientAddress) {
        this.clientAddress = clientAddress;
        return this;
    }

    public ComputeEventMetadata build() {
        return new ComputeEventMetadata(this.eventUser != null ? this.eventUser : EventUser.system(), this.type, this.jobClassName, this.jobId, this.targetNode, this.initiatorNode, this.taskId, this.tableName, this.clientAddress);
    }

    public ComputeEventMetadataBuilder copyOf() {
        ComputeEventMetadataBuilder builder = new ComputeEventMetadataBuilder().type(this.type).jobClassName(this.jobClassName).jobId(this.jobId).targetNode(this.targetNode).initiatorNode(this.initiatorNode).taskId(this.taskId).tableName(this.tableName).clientAddress(this.clientAddress);
        if (this.eventUser != null) {
            builder.eventUser(new UserDetails(this.eventUser.username(), this.eventUser.authenticationProvider()));
        }
        return builder;
    }
}

