/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.sql.engine.exec.ExchangeService;
import org.apache.ignite.internal.sql.engine.exec.ExecutionId;
import org.apache.ignite.internal.sql.engine.exec.MailboxRegistry;
import org.apache.ignite.internal.sql.engine.exec.SharedState;
import org.apache.ignite.internal.sql.engine.exec.rel.Inbox;
import org.apache.ignite.internal.sql.engine.exec.rel.Outbox;
import org.apache.ignite.internal.sql.engine.message.MessageService;
import org.apache.ignite.internal.sql.engine.message.QueryBatchMessage;
import org.apache.ignite.internal.sql.engine.message.QueryBatchRequestMessage;
import org.apache.ignite.internal.sql.engine.message.SqlQueryMessagesFactory;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.TraceableException;
import org.jetbrains.annotations.Nullable;

public class ExchangeServiceImpl
implements ExchangeService {
    private static final IgniteLogger LOG = Loggers.forClass(ExchangeServiceImpl.class);
    private static final SqlQueryMessagesFactory FACTORY = new SqlQueryMessagesFactory();
    private final MailboxRegistry mailboxRegistry;
    private final MessageService messageService;
    private final ClockService clockService;

    public ExchangeServiceImpl(MailboxRegistry mailboxRegistry, MessageService messageService, ClockService clockService) {
        this.mailboxRegistry = mailboxRegistry;
        this.messageService = messageService;
        this.clockService = clockService;
    }

    @Override
    public void start() {
        this.messageService.register((n, m) -> this.onMessage(n, (QueryBatchRequestMessage)m), (short)4);
        this.messageService.register((n, m) -> this.onMessage(n, (QueryBatchMessage)m), (short)3);
    }

    @Override
    public CompletableFuture<Void> sendBatch(String nodeName, ExecutionId executionId, long fragmentId, long exchangeId, int batchId, boolean last, List<BinaryTupleMessage> rows) {
        return this.messageService.send(nodeName, FACTORY.queryBatchMessage().queryId(executionId.queryId()).executionToken(executionId.executionToken()).fragmentId(fragmentId).exchangeId(exchangeId).batchId(batchId).last(last).rows(rows).timestamp(this.clockService.now()).build());
    }

    @Override
    public CompletableFuture<Void> request(String nodeName, ExecutionId executionId, long fragmentId, long exchangeId, int amountOfBatches, @Nullable SharedState state) {
        return this.messageService.send(nodeName, FACTORY.queryBatchRequestMessage().queryId(executionId.queryId()).executionToken(executionId.executionToken()).fragmentId(fragmentId).exchangeId(exchangeId).amountOfBatches(amountOfBatches).sharedState(state).build());
    }

    @Override
    public CompletableFuture<Void> sendError(String nodeName, ExecutionId executionId, long fragmentId, Throwable error) {
        Throwable traceableErr = ExceptionUtils.unwrapCause((Throwable)error);
        if (!(traceableErr instanceof TraceableException)) {
            traceableErr = error = new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, error);
            LOG.info(IgniteStringFormatter.format((String)"Failed to execute query fragment: traceId={}, executionId={}, fragmentId={}", (Object[])new Object[]{((TraceableException)traceableErr).traceId(), executionId, fragmentId}), error);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(IgniteStringFormatter.format((String)"Failed to execute query fragment: traceId={}, executionId={}, fragmentId={}", (Object[])new Object[]{((TraceableException)traceableErr).traceId(), executionId, fragmentId}), error);
        }
        return this.messageService.send(nodeName, FACTORY.errorMessage().queryId(executionId.queryId()).executionToken(executionId.executionToken()).fragmentId(fragmentId).traceId(((TraceableException)traceableErr).traceId()).code(((TraceableException)traceableErr).code()).message(traceableErr.getMessage()).build());
    }

    private void onMessage(InternalClusterNode node, QueryBatchRequestMessage msg) {
        ExecutionId executionId = new ExecutionId(msg.queryId(), msg.executionToken());
        CompletableFuture<Outbox<?>> outboxFut = this.mailboxRegistry.outbox(executionId, msg.exchangeId());
        Consumer<Outbox> onRequestHandler = outbox -> {
            try {
                SharedState state = msg.sharedState();
                if (state != null) {
                    outbox.onRewindRequest(node.name(), state, msg.amountOfBatches());
                } else {
                    outbox.onRequest(node.name(), msg.amountOfBatches());
                }
            }
            catch (Throwable e) {
                outbox.onError(e);
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Unexpected exception", e);
            }
        };
        if (outboxFut.isDone()) {
            onRequestHandler.accept(outboxFut.join());
        } else {
            outboxFut.thenAccept(onRequestHandler);
        }
    }

    private void onMessage(InternalClusterNode node, QueryBatchMessage msg) {
        ExecutionId executionId = new ExecutionId(msg.queryId(), msg.executionToken());
        Inbox<?> inbox = this.mailboxRegistry.inbox(executionId, msg.exchangeId());
        if (inbox != null) {
            try {
                inbox.onBatchReceived(node.name(), msg.batchId(), msg.last(), msg.rows());
            }
            catch (Throwable e) {
                inbox.onError(e);
                if (e instanceof IgniteException) {
                    return;
                }
                LOG.warn("Unexpected exception", e);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Stale batch message received: [nodeName={}, executionId={}, fragmentId={}, exchangeId={}, batchId={}]", new Object[]{node.name(), executionId, msg.fragmentId(), msg.exchangeId(), msg.batchId()});
        }
    }

    @Override
    public void stop() {
    }
}

