/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule.logical;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.rule.logical.ImmutableLogicalOrToUnionRule;
import org.apache.ignite.internal.sql.engine.rule.logical.RuleFactoryConfig;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;

@Value.Enclosing
public class LogicalOrToUnionRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = new LogicalOrToUnionRule(Config.SCAN);

    private LogicalOrToUnionRule(Config config) {
        super((RelRule.Config)config);
    }

    @Nullable
    private static List<RexNode> getOrOperands(RexBuilder rexBuilder, RexNode condition) {
        RexNode dnf = RexUtils.tryToDnf(rexBuilder, condition, 2);
        if (dnf != null && !dnf.isA(SqlKind.OR)) {
            return null;
        }
        List operands = RelOptUtil.disjunctions((RexNode)dnf);
        assert (operands.size() <= 2) : "unexpected operands count: " + operands.size();
        if (operands.size() != 2 || RexUtil.find((SqlKind)SqlKind.IS_NULL).anyContain((Iterable)operands)) {
            return null;
        }
        return operands;
    }

    private void buildInput(RelBuilder relBldr, RelNode input, RexNode condition) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)input;
        RelTraitSet trait = scan.getCluster().traitSet();
        relBldr.push((RelNode)IgniteLogicalTableScan.create(scan.getCluster(), trait, (List<RelHint>)scan.getHints(), scan.getTable(), scan.fieldNames(), scan.projects(), condition, scan.requiredColumns()));
    }

    private RelNode createUnionAll(RelOptCluster cluster, RelNode input, RexNode op1, RexNode op2) {
        RelBuilder relBldr = this.relBuilderFactory.create(cluster, null);
        this.buildInput(relBldr, input, op1);
        this.buildInput(relBldr, input, relBldr.and(new RexNode[]{op2, relBldr.or(new RexNode[]{relBldr.isNull(op1), relBldr.not(op1)})}));
        return relBldr.union(true).build();
    }

    private RexNode getCondition(RelOptRuleCall call) {
        IgniteLogicalTableScan rel = (IgniteLogicalTableScan)call.rel(0);
        return rel.condition();
    }

    private boolean idxCollationCheck(RelOptRuleCall call, List<RexNode> operands) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)call.rel(0);
        IgniteTable tbl = (IgniteTable)scan.getTable().unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = Commons.typeFactory(scan.getCluster());
        int fieldCnt = tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount();
        BitSet idxsFirstFields = new BitSet(fieldCnt);
        for (IgniteIndex idx : tbl.indexes().values()) {
            List fieldCollations = idx.collation().getFieldCollations();
            if (CollectionUtils.nullOrEmpty((Collection)fieldCollations)) continue;
            idxsFirstFields.set(((RelFieldCollation)fieldCollations.get(0)).getFieldIndex());
        }
        Mappings.IdentityMapping mapping = scan.requiredColumns() == null ? Mappings.createIdentity((int)fieldCnt) : Commons.projectedMapping(fieldCnt, scan.requiredColumns());
        for (RexNode op : operands) {
            final BitSet conditionFields = new BitSet(fieldCnt);
            new RexShuttle((Mappings.TargetMapping)mapping){
                final /* synthetic */ Mappings.TargetMapping val$mapping;
                {
                    this.val$mapping = targetMapping;
                }

                public RexNode visitLocalRef(RexLocalRef inputRef) {
                    conditionFields.set(this.val$mapping.getSourceOpt(inputRef.getIndex()));
                    return inputRef;
                }
            }.apply(op);
            if (conditionFields.intersects(idxsFirstFields)) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        RelOptCluster cluster = call.rel(0).getCluster();
        List<RexNode> operands = LogicalOrToUnionRule.getOrOperands(cluster.getRexBuilder(), this.getCondition(call));
        if (operands == null) {
            return;
        }
        if (!this.idxCollationCheck(call, operands)) {
            return;
        }
        RelNode input = call.rel(0);
        RelNode rel0 = this.createUnionAll(cluster, input, operands.get(0), operands.get(1));
        RelNode rel1 = this.createUnionAll(cluster, input, operands.get(1), operands.get(0));
        call.transformTo(rel0, Map.of(rel1, rel0));
    }

    @Value.Immutable(singleton=false)
    public static interface Config
    extends RuleFactoryConfig<Config> {
        public static final Config SCAN = ImmutableLogicalOrToUnionRule.Config.builder().withRuleFactory((Config x$0) -> new LogicalOrToUnionRule((Config)x$0)).withDescription("ScanLogicalOrToUnionRule").withOperandSupplier(o -> o.operand(IgniteLogicalTableScan.class).predicate(scan -> scan.condition() != null).noInputs()).build();
    }
}

