/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.schema.lookup.Named;
import org.apache.calcite.util.NameMap;
import org.checkerframework.checker.nullness.qual.Nullable;

class NameMapLookup<T>
implements Lookup<T> {
    private final NameMap<T> map;

    NameMapLookup(NameMap<T> map) {
        this.map = map;
    }

    @Override
    public @Nullable T get(String name) {
        Map.Entry<String, T> entry = this.map.range(name, true).firstEntry();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    @Override
    public @Nullable Named<T> getIgnoreCase(String name) {
        Map.Entry<String, T> entry = this.map.range(name, false).firstEntry();
        if (entry != null) {
            return new Named<T>(entry.getKey(), entry.getValue());
        }
        return null;
    }

    @Override
    public Set<String> getNames(LikePattern pattern) {
        Predicate1<String> matcher = pattern.matcher();
        return this.map.map().keySet().stream().filter(name -> matcher.apply(name)).collect(Collectors.toSet());
    }
}

