/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.type;

import java.util.Objects;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.shaded.org.apache.ignite.internal.tostring.S;
import org.apache.ignite.shaded.org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.shaded.org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.shaded.org.apache.ignite.sql.ColumnType;

public class TemporalNativeType
extends NativeType {
    private final int precision;

    static TemporalNativeType time(int precision) {
        int size = precision > 3 ? 6 : 4;
        return new TemporalNativeType(ColumnType.TIME, size, precision);
    }

    static TemporalNativeType datetime(int precision) {
        int size = NativeTypes.DATE.sizeInBytes() + (precision > 3 ? 6 : 4);
        return new TemporalNativeType(ColumnType.DATETIME, size, precision);
    }

    static TemporalNativeType timestamp(int precision) {
        int size = precision == 0 ? 8 : 12;
        return new TemporalNativeType(ColumnType.TIMESTAMP, size, precision);
    }

    private TemporalNativeType(ColumnType typeSpec, int size, int precision) {
        super(typeSpec, size);
        if (precision < 0 || precision > 9) {
            throw new IllegalArgumentException("Unsupported fractional seconds precision: " + precision);
        }
        this.precision = precision;
    }

    public int precision() {
        return this.precision;
    }

    @Override
    public String displayName() {
        return IgniteStringFormatter.format("{}({})", super.displayName(), this.precision);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TemporalNativeType that = (TemporalNativeType)o;
        return this.precision == that.precision;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.precision);
    }

    @Override
    public String toString() {
        return S.toString(TemporalNativeType.class.getSimpleName(), "name", (Object)this.spec(), "precision", (Object)this.precision);
    }
}

