/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters.otlp;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.metrics.LongMetric;
import org.apache.ignite.internal.metrics.exporters.otlp.IgniteGaugeData;
import org.apache.ignite.internal.metrics.exporters.otlp.IgniteMetricData;
import org.apache.ignite.internal.metrics.exporters.otlp.IgnitePointData;
import org.apache.ignite.internal.util.Lazy;

class IgniteLongMetricData
extends IgniteMetricData<LongMetric> {
    private final Data<IgniteLongPointData> data;

    IgniteLongMetricData(Lazy<Resource> resource, InstrumentationScopeInfo scope, LongMetric metric) {
        super(resource, scope, metric);
        this.data = new IgniteGaugeData<IgniteLongPointData>(new IgniteLongPointData(metric));
    }

    public MetricDataType getType() {
        return MetricDataType.LONG_GAUGE;
    }

    public Data<?> getData() {
        return this.data;
    }

    private static class IgniteLongPointData
    extends IgnitePointData
    implements LongPointData {
        private final LongMetric metric;

        IgniteLongPointData(LongMetric metric) {
            this.metric = metric;
        }

        public long getValue() {
            return this.metric.value();
        }

        public List<LongExemplarData> getExemplars() {
            return Collections.emptyList();
        }
    }
}

