/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.replicator.message.AwaitReplicaResponse;
import org.apache.ignite.internal.replicator.message.AwaitReplicaResponseBuilder;
import org.apache.ignite.internal.replicator.message.AwaitReplicaResponseSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class AwaitReplicaResponseImpl
implements AwaitReplicaResponse,
Cloneable {
    public static final short GROUP_TYPE = 8;
    public static final short TYPE = 7;
    @IgniteToStringInclude
    private Object result;
    private byte[] resultByteArray;

    private AwaitReplicaResponseImpl(Object result, byte[] resultByteArray) {
        this.result = result;
        this.resultByteArray = resultByteArray;
    }

    byte[] resultByteArray() {
        return this.resultByteArray;
    }

    @Override
    public Object result() {
        return this.result;
    }

    public MessageSerializer serializer() {
        return AwaitReplicaResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 8;
    }

    public String toString() {
        return S.toString(AwaitReplicaResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 7;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AwaitReplicaResponseImpl otherMessage = (AwaitReplicaResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result);
        return result;
    }

    public AwaitReplicaResponseImpl clone() {
        try {
            return (AwaitReplicaResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static AwaitReplicaResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject resultByteArraymo = marshaller.marshal(this.result);
        usedDescriptors.addAll((IntCollection)resultByteArraymo.usedDescriptorIds());
        this.resultByteArray = resultByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.result = marshaller.unmarshal(this.resultByteArray, descriptorsObj);
        this.resultByteArray = null;
    }

    private static class Builder
    implements AwaitReplicaResponseBuilder {
        private Object result;
        private byte[] resultByteArray;

        private Builder() {
        }

        @Override
        public AwaitReplicaResponseBuilder result(Object result) {
            this.result = result;
            return this;
        }

        @Override
        public AwaitReplicaResponseBuilder resultByteArray(byte[] resultByteArray) {
            this.resultByteArray = resultByteArray;
            return this;
        }

        @Override
        public Object result() {
            return this.result;
        }

        @Override
        public byte[] resultByteArray() {
            return this.resultByteArray;
        }

        @Override
        public AwaitReplicaResponse build() {
            return new AwaitReplicaResponseImpl(this.result, this.resultByteArray);
        }
    }
}

