/*
 * Decompiled with CFR 0.152.
 */
package com.github.chhorz.javadoc.replacements;

import com.github.chhorz.javadoc.replacements.Replacement;
import com.github.chhorz.javadoc.tags.InlineTag;

public class InlineTagReplacement
implements Replacement {
    private final InlineTag inlineTag;
    private final String prefix;
    private final String suffix;

    public InlineTagReplacement(InlineTag inlineTag) {
        this(inlineTag, "", "");
    }

    public InlineTagReplacement(InlineTag inlineTag, String wrapperString) {
        this(inlineTag, wrapperString, wrapperString);
    }

    public InlineTagReplacement(InlineTag inlineTag, String prefix, String suffix) {
        this.inlineTag = inlineTag;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public String perform(String input) {
        int tagStartIndex;
        String output = input;
        int tagEndIndex = tagStartIndex = output.indexOf("{@" + this.inlineTag.getTagName());
        while (tagStartIndex >= 0) {
            int bracketCount = 0;
            for (int i = tagStartIndex; i < output.length(); ++i) {
                char c = output.charAt(i);
                if (c == '{') {
                    ++bracketCount;
                }
                if (c == '}') {
                    --bracketCount;
                }
                if (bracketCount != 0) continue;
                tagEndIndex = i;
                break;
            }
            String completeTag = output.substring(tagStartIndex, tagEndIndex + 1);
            String tagReplacement = completeTag.substring(0, completeTag.length() - 1).replaceFirst("\\{@" + this.inlineTag.getTagName() + "\\s+:?", "");
            output = output.replace(completeTag, String.format("%s%s%s", this.prefix, tagReplacement, this.suffix));
            tagEndIndex = tagStartIndex = output.indexOf("{@" + this.inlineTag.getTagName());
        }
        return output;
    }
}

