/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite.internal.sql.engine.prepare.bounds.ExactBounds;
import org.apache.ignite.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite.internal.sql.engine.rel.IgniteKeyValueGet;
import org.apache.ignite.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite.internal.sql.engine.rule.ImmutableTableScanToKeyValueGetRule;
import org.apache.ignite.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistributions;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.RexUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;

@Value.Enclosing
public class TableScanToKeyValueGetRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.INSTANCE.toRule();

    private TableScanToKeyValueGetRule(Config cfg) {
        super((RelRule.Config)cfg);
    }

    public void onMatch(RelOptRuleCall call) {
        IgniteLogicalTableScan scan = (IgniteLogicalTableScan)((Object)TableScanToKeyValueGetRule.cast(call.rel(0)));
        List<SearchBounds> bounds = TableScanToKeyValueGetRule.deriveSearchBounds(scan);
        if (CollectionUtils.nullOrEmpty(bounds)) {
            return;
        }
        ArrayList<RexNode> expressions = new ArrayList<RexNode>(bounds.size());
        RelOptCluster cluster = scan.getCluster();
        RexBuilder rexBuilder = RexUtils.builder(cluster);
        RexNode originalCondition = RexUtil.toCnf((RexBuilder)rexBuilder, (RexNode)scan.condition());
        HashSet condition = new HashSet(RelOptUtil.conjunctions((RexNode)originalCondition));
        for (SearchBounds bound : bounds) {
            if (!(bound instanceof ExactBounds)) {
                return;
            }
            condition.remove(bound.condition());
            expressions.add(((ExactBounds)bound).bound());
        }
        if (CollectionUtils.nullOrEmpty(expressions)) {
            return;
        }
        RexNode resultingCondition = RexUtil.composeConjunction((RexBuilder)rexBuilder, condition);
        if (resultingCondition.isAlwaysTrue()) {
            resultingCondition = null;
        }
        call.transformTo((RelNode)new IgniteKeyValueGet(cluster, scan.getTraitSet().replace((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)IgniteDistributions.single()), scan.getTable(), (List<RelHint>)scan.getHints(), expressions, scan.projects(), resultingCondition, scan.requiredColumns()));
    }

    @Nullable
    private static List<SearchBounds> deriveSearchBounds(IgniteLogicalTableScan scan) {
        RexNode condition = scan.condition();
        if (condition == null) {
            return null;
        }
        IgniteTable table = (IgniteTable)scan.getTable().unwrap(IgniteTable.class);
        assert (table != null) : scan.getTable();
        IgniteIndex primaryKeyIndex = table.indexes().values().stream().filter(IgniteIndex::primaryKey).findAny().orElse(null);
        if (primaryKeyIndex == null) {
            return null;
        }
        RelOptCluster cluster = scan.getCluster();
        RelCollation collation = primaryKeyIndex.collation();
        ImmutableBitSet requiredColumns = scan.requiredColumns();
        RelDataType rowType = table.getRowType(cluster.getTypeFactory());
        if (requiredColumns != null) {
            Mapping targetMapping = Commons.trimmingMapping(rowType.getFieldCount(), requiredColumns);
            RelCollation beforeTrimming = collation;
            if ((collation = (RelCollation)collation.apply((Mappings.TargetMapping)targetMapping)).getFieldCollations().size() != beforeTrimming.getFieldCollations().size()) {
                return null;
            }
        }
        return RexUtils.buildHashSearchBounds(cluster, collation, condition, rowType, requiredColumns);
    }

    private static <T extends RelNode> T cast(RelNode node) {
        return (T)node;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config INSTANCE = (Config)ImmutableTableScanToKeyValueGetRule.Config.of().withDescription("TableScanToKeyValueGetRule").withOperandSupplier(o0 -> o0.operand(IgniteLogicalTableScan.class).predicate(scan -> scan.condition() != null).noInputs()).as(Config.class);

        default public TableScanToKeyValueGetRule toRule() {
            return new TableScanToKeyValueGetRule(this);
        }
    }
}

