/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableLimit<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long n;

    public FlowableLimit(Flowable<T> source, long n) {
        super(source);
        this.n = n;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new LimitSubscriber<T>(s, this.n));
    }

    static final class LimitSubscriber<T>
    extends AtomicLong
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = 2288246011222124525L;
        final Subscriber<? super T> downstream;
        long remaining;
        Subscription upstream;

        LimitSubscriber(Subscriber<? super T> actual, long remaining) {
            this.downstream = actual;
            this.remaining = remaining;
            this.lazySet(remaining);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                if (this.remaining == 0L) {
                    s.cancel();
                    EmptySubscription.complete(this.downstream);
                } else {
                    this.upstream = s;
                    this.downstream.onSubscribe((Subscription)this);
                }
            }
        }

        public void onNext(T t) {
            long r = this.remaining;
            if (r > 0L) {
                this.remaining = --r;
                this.downstream.onNext(t);
                if (r == 0L) {
                    this.upstream.cancel();
                    this.downstream.onComplete();
                }
            }
        }

        public void onError(Throwable t) {
            if (this.remaining > 0L) {
                this.remaining = 0L;
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        public void onComplete() {
            if (this.remaining > 0L) {
                this.remaining = 0L;
                this.downstream.onComplete();
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                long r;
                while ((r = this.get()) != 0L) {
                    long toRequest = r <= n ? r : n;
                    long u = r - toRequest;
                    if (!this.compareAndSet(r, u)) continue;
                    this.upstream.request(toRequest);
                    break;
                }
            }
        }

        public void cancel() {
            this.upstream.cancel();
        }
    }
}

