/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringRTrimCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringRTrimColScalar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseTrim;

@Description(name="rtrim", value="_FUNC_(str[, chars]) - Removes the trailing pad characters from str ", extended="Example:\n  > SELECT _FUNC_('facebook   ') FROM src LIMIT 1;\n  'facebook'\n  > SELECT _FUNC_('facebookxyzzyx', 'xzy') FROM src LIMIT 1;\n  'facebook'")
@VectorizedExpressions(value={StringRTrimCol.class, StringRTrimColScalar.class})
public class GenericUDFRTrim
extends GenericUDFBaseTrim {
    public GenericUDFRTrim() {
        super("rtrim");
    }

    @Override
    protected String performOp(String val, String trimChars) {
        return StringUtils.stripEnd((String)val, (String)trimChars);
    }
}

