/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MurmurHashIntColIntCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MurmurHashStringColIntCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MurmurHashStringColStringCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;

@Description(name="hash", value="_FUNC_(a1, a2, ...) - Returns a hash value of the arguments")
@VectorizedExpressions(value={MurmurHashStringColIntCol.class, MurmurHashStringColStringCol.class, MurmurHashIntColIntCol.class})
public class GenericUDFMurmurHash
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private final IntWritable result = new IntWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentTypeException {
        this.argumentOIs = arguments;
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object[] fieldValues = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            fieldValues[i] = arguments[i].get();
        }
        int r = ObjectInspectorUtils.getBucketHashCode((Object[])fieldValues, (ObjectInspector[])this.argumentOIs);
        this.result.set(r);
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("hash", children, ",");
    }
}

