/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampLocalTZObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.LongWritable;

@Description(name="to_epoch_milli", value="_FUNC_(timestamp) - Converts the specified timestamp to number of milliseconds since 1970-01-01", extended="Example:\n  > SELECT _FUNC_(cast('2012-02-11 04:30:00' as timestamp));1328934600000")
public class GenericUDFEpochMilli
extends GenericUDF {
    private final transient LongWritable result = new LongWritable();
    private transient TimestampLocalTZObjectInspector tsWithLocalTzOi = null;
    private transient TimestampObjectInspector tsOi = null;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("The operator GenericUDFEpochMilli only accepts 1 argument.");
        }
        if (arguments[0] instanceof TimestampObjectInspector) {
            this.tsOi = (TimestampObjectInspector)arguments[0];
        } else if (arguments[0] instanceof TimestampLocalTZObjectInspector) {
            this.tsWithLocalTzOi = (TimestampLocalTZObjectInspector)arguments[0];
        } else {
            throw new UDFArgumentTypeException(0, String.format("%s only takes TIMESTAMP, got %s", this.getFuncName(), arguments[0].getTypeName()));
        }
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object a0 = arguments[0].get();
        if (a0 == null) {
            return null;
        }
        this.result.set(this.tsOi == null ? this.tsWithLocalTzOi.getPrimitiveJavaObject(a0).getZonedDateTime().toInstant().toEpochMilli() : this.tsOi.getPrimitiveJavaObject(a0).toEpochMilli());
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        return "GenericUDFEpochMilli(" + children[0] + ")";
    }
}

