/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFExceptionInVertex;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="exception_in_vertex_udaf", value="_FUNC_(vertexName, taskNumberExpression, taskAttemptNumberExpression)Throws exception in Reducer tasks, where UDF running is possible", extended=" please refer to full examples in exception_in_vertex_udf.q: exception_in_vertex_udaf ('Reducer 2', 0, 0)          -> Reducer2, first task, first attemptexception_in_vertex_udaf ('Reducer 2', '0,1,2', '*')  -> Reducer2, tasks: 0,1,2, all attemptsexception_in_vertex_udaf ('Reducer 2', '*', 0)        -> Reducer2, all tasks, first attemptexception_in_vertex_udaf ('Reducer 2', '0-2', '*')    -> Reducer2, tasks: 0,1,2, all attemptsexception_in_vertex_udaf ('Reducer 2', '*', '*')      -> Reducer2, all tasks, all attemptsexception_in_vertex_udaf ('Reducer 2', '*')           -> Reducer2, all tasks, all attemptsexception_in_vertex_udaf ('Reducer 2')                -> Reducer2, all tasks, all attempts")
public class GenericUDAFExceptionInVertex
implements GenericUDAFResolver2 {
    private static final Logger LOG = LoggerFactory.getLogger(GenericUDAFExceptionInVertex.class);

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        return new GenericUDAFExceptionInVertexEvaluator();
    }

    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo paramInfo) throws SemanticException {
        ObjectInspector[] parameters = paramInfo.getParameterObjectInspectors();
        if (parameters.length < 1) {
            throw new UDFArgumentTypeException(-1, "At least one argument is expected (vertex name)");
        }
        String vertexName = GenericUDFExceptionInVertex.getVertexName(parameters, 0);
        String taskNumber = GenericUDFExceptionInVertex.getTaskNumber(parameters, 1);
        String taskAttemptNumber = GenericUDFExceptionInVertex.getTaskAttemptNumber(parameters, 2);
        GenericUDAFExceptionInVertexEvaluator evaluator = new GenericUDAFExceptionInVertexEvaluator(vertexName, taskNumber, taskAttemptNumber);
        return evaluator;
    }

    public static class GenericUDAFExceptionInVertexEvaluator
    extends GenericUDAFEvaluator
    implements Serializable {
        private String vertexName;
        private String taskNumberExpr;
        private String taskAttemptNumberExpr;
        private transient String currentVertexName;
        private transient int currentTaskNumber;
        private transient int currentTaskAttemptNumber;
        private boolean alreadyCheckedAndPassed = false;

        public GenericUDAFExceptionInVertexEvaluator() {
        }

        public GenericUDAFExceptionInVertexEvaluator(String vertexName, String taskNumber, String taskAttemptNumber) {
            this.vertexName = vertexName;
            this.taskNumberExpr = taskNumber;
            this.taskAttemptNumberExpr = taskAttemptNumber;
        }

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }

        @Override
        public void configure(MapredContext mapredContext) {
            this.currentVertexName = mapredContext.getJobConf().get("hive.tez.vertex.name");
            this.currentTaskNumber = mapredContext.getJobConf().getInt("hive.tez.task.index", -1);
            this.currentTaskAttemptNumber = mapredContext.getJobConf().getInt("hive.tez.task.attempt.number", -1);
            LOG.debug("configure vertex: {}, task: {}, attempt: {} <-> current vertex {}, task: {}, attempt: {}", new Object[]{this.vertexName, this.taskNumberExpr, this.taskAttemptNumberExpr, this.currentVertexName, this.currentTaskNumber, this.currentTaskAttemptNumber});
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            return new GenericUDAFEvaluator.AggregationBuffer(this){};
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            this.checkAndThrowException("iterate");
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            this.checkAndThrowException("merge");
        }

        private void checkAndThrowException(String phase) throws HiveException {
            if (this.alreadyCheckedAndPassed) {
                return;
            }
            LOG.debug("{}: vertex {}, task: {}, attempt: {} <-> vertex {}, task: {}, attempt: {}", new Object[]{phase, this.currentVertexName, this.currentTaskNumber, this.currentTaskAttemptNumber, this.vertexName, this.taskNumberExpr, this.taskAttemptNumberExpr});
            if (this.vertexName.equals(this.currentVertexName) && GenericUDFExceptionInVertex.numberFitsExpression(this.currentTaskNumber, this.taskNumberExpr) && GenericUDFExceptionInVertex.numberFitsExpression(this.currentTaskAttemptNumber, this.taskAttemptNumberExpr)) {
                String message = String.format("GenericUDAFExceptionInVertex: found condition for throwing exception (vertex/task/attempt):current %s / %d / %d matches criteria %s / %s / %s", this.currentVertexName, this.currentTaskNumber, this.currentTaskAttemptNumber, this.vertexName, this.taskNumberExpr, this.taskAttemptNumberExpr);
                LOG.info(message);
                throw new HiveException(message);
            }
            this.alreadyCheckedAndPassed = true;
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return null;
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return null;
        }
    }
}

