/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.UpdateTransactionalStatsRequest;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.SmallFilesWarningUtil;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.IStatsProcessor;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsCollectionContext;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStatsTask
implements Serializable,
IStatsProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(BasicStatsTask.class);
    private Table table;
    private Collection<Partition> dpPartSpecs = null;
    public boolean followedColStats;
    private BasicStatsWork work;
    private HiveConf conf;
    protected transient SessionState.LogHelper console;

    public BasicStatsTask(HiveConf conf, BasicStatsWork work) {
        this.conf = conf;
        this.console = new SessionState.LogHelper(LOG);
        this.work = work;
    }

    @Override
    public int process(Hive db, Table tbl) throws Exception {
        LOG.info("Executing stats task");
        this.table = tbl;
        return this.aggregateStats(db, tbl);
    }

    @Override
    public void initialize(CompilationOpContext opContext) {
    }

    public StageType getType() {
        return StageType.STATS;
    }

    public String getName() {
        return "STATS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private int aggregateStats(Hive db, Table tbl) {
        block31: {
            block28: {
                block29: {
                    statsAggregator = null;
                    ret = 0;
                    scc = null;
                    environmentContext = null;
                    environmentContext = new EnvironmentContext();
                    environmentContext.putToProperties("DO_NOT_UPDATE_STATS", "true");
                    wh = new Warehouse((Configuration)this.conf);
                    if (!this.getWork().getNoStatsAggregator() && !this.getWork().isNoScanAnalyzeCommand()) {
                        try {
                            scc = this.getContext();
                            statsAggregator = this.createStatsAggregator(scc, this.conf);
                        }
                        catch (HiveException e) {
                            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_RELIABLE)) {
                                throw e;
                            }
                            this.console.printError(ErrorMsg.STATS_SKIPPING_BY_ERROR.getErrorCodedMsg(new String[]{e.toString()}));
                        }
                    }
                    partitions = this.getPartitionsList(db);
                    tableFullName = this.table.getDbName() + "." + this.table.getTableName();
                    if (partitions != null) ** GOTO lbl43
                    p = new Partish.PTable(this.table);
                    basicStatsProcessor = new BasicStatsProcessor(p, this.work, this.followedColStats);
                    basicStatsProcessor.collectFileStatus(wh, this.conf);
                    res = (Table)basicStatsProcessor.process(statsAggregator);
                    if (res != null) break block28;
                    var13_18 = 0;
                    if (statsAggregator == null) break block29;
                    statsAggregator.closeConnection(scc);
                }
                return var13_18;
            }
            try {
                block32: {
                    db.alterTable(tableFullName, res, environmentContext, true);
                    transactionalStatsProcessor = new TransactionalStatsProcessor(db, p);
                    transactionalStatsProcessor.process(statsAggregator);
                    if (this.conf.getBoolVar(HiveConf.ConfVars.TEZ_EXEC_SUMMARY)) {
                        this.console.printInfo("Table " + tableFullName + " stats: [" + this.toString(p.getPartParameters()) + "]");
                    } else {
                        BasicStatsTask.LOG.info("Table " + tableFullName + " stats: [" + this.toString(p.getPartParameters()) + "]");
                    }
                    tbl.setTTable(res.getTTable());
                    break block32;
lbl43:
                    // 1 sources

                    updates = Lists.newArrayList();
                    pool = this.buildBasicStatsExecutor();
                    futures = Lists.newLinkedList();
                    processors = Lists.newLinkedList();
                    transactionalStatsProcessors = Lists.newLinkedList();
                    try {
                        for (Partition partn : partitions) {
                            p = new Partish.PPart(this.table, partn);
                            bsp = new BasicStatsProcessor(p, this.work, this.followedColStats);
                            processors.add(bsp);
                            transactionalStatsProcessors.add(new TransactionalStatsProcessor(db, p));
                            futures.add(pool.submit(new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    bsp.collectFileStatus(wh, BasicStatsTask.this.conf);
                                    return null;
                                }
                            }));
                        }
                        pool.shutdown();
                        for (Object future : futures) {
                            future.get();
                        }
                    }
                    catch (InterruptedException e) {
                        BasicStatsTask.LOG.debug("Cancelling " + futures.size() + " file stats lookup tasks");
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                        if (this.work.isStatsReliable()) {
                            ret = 1;
                        }
                    }
                    finally {
                        pool.shutdownNow();
                        BasicStatsTask.LOG.debug("Finished getting file stats of all partitions!");
                    }
                    for (BasicStatsProcessor basicStatsProcessor : processors) {
                        res = basicStatsProcessor.process(statsAggregator);
                        if (res == null) {
                            BasicStatsTask.LOG.info("Partition " + String.valueOf(basicStatsProcessor.partish.getPartition().getSpec()) + " stats: [0]");
                            continue;
                        }
                        updates.add((Partition)res);
                        if (this.conf.getBoolVar(HiveConf.ConfVars.TEZ_EXEC_SUMMARY)) {
                            this.console.printInfo("Partition " + String.valueOf(basicStatsProcessor.partish.getPartition().getSpec()) + " stats: [" + this.toString(basicStatsProcessor.partish.getPartParameters()) + "]");
                            continue;
                        }
                        BasicStatsTask.LOG.info("Partition " + String.valueOf(basicStatsProcessor.partish.getPartition().getSpec()) + " stats: [" + this.toString(basicStatsProcessor.partish.getPartParameters()) + "]");
                    }
                    if (!updates.isEmpty()) {
                        db.alterPartitions(tableFullName, updates, environmentContext, true);
                    }
                    for (TransactionalStatsProcessor transactionalStatsProcessor : transactionalStatsProcessors) {
                        transactionalStatsProcessor.process(statsAggregator);
                    }
                    if (this.work.isStatsReliable() && updates.size() != processors.size()) {
                        BasicStatsTask.LOG.info("Stats should be reliadble...however seems like there were some issue.. => ret 1");
                        ret = 1;
                    }
                }
                if (statsAggregator == null) break block31;
                statsAggregator.closeConnection(scc);
            }
            catch (Exception e) {
                try {
                    this.console.printInfo("[Warning] could not update stats.", "Failed with exception " + e.getMessage() + "\n" + StringUtils.stringifyException((Throwable)e));
                    if (this.work.isStatsReliable()) {
                        ret = 1;
                    }
                    if (statsAggregator == null) break block31;
                    statsAggregator.closeConnection(scc);
                }
                catch (Throwable var20_28) {
                    if (statsAggregator != null) {
                        statsAggregator.closeConnection(scc);
                    }
                    throw var20_28;
                }
            }
        }
        return ret;
    }

    private BasicStatsWork getWork() {
        return this.work;
    }

    private ExecutorService buildBasicStatsExecutor() {
        int poolSize = this.conf.getInt(HiveConf.ConfVars.HIVE_MOVE_FILES_THREAD_COUNT.varname, 1);
        poolSize = Math.max(poolSize, 1);
        ExecutorService pool = Executors.newFixedThreadPool(poolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("stats-updater-thread-%d").build());
        LOG.debug("Getting file stats of all partitions. threadpool size:" + poolSize);
        return pool;
    }

    private StatsAggregator createStatsAggregator(StatsCollectionContext scc, HiveConf conf) throws HiveException {
        String statsImpl = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_DBCLASS);
        StatsFactory factory = StatsFactory.newFactory(statsImpl, (Configuration)conf);
        if (factory == null) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_NOT_OBTAINED.getErrorCodedMsg());
        }
        StatsPublisher statsPublisher = factory.getStatsPublisher();
        if (!statsPublisher.init(scc)) {
            throw new HiveException(ErrorMsg.STATSPUBLISHER_INITIALIZATION_ERROR.getErrorCodedMsg());
        }
        StatsAggregator statsAggregator = factory.getStatsAggregator();
        if (!statsAggregator.connect(scc)) {
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_CONNECTION_ERROR.getErrorCodedMsg(new String[]{statsImpl}));
        }
        return statsAggregator;
    }

    private StatsCollectionContext getContext() throws HiveException {
        StatsCollectionContext scc = new StatsCollectionContext((Configuration)this.conf);
        Task sourceTask = this.getWork().getSourceTask();
        if (sourceTask == null) {
            throw new HiveException(ErrorMsg.STATSAGGREGATOR_SOURCETASK_NULL.getErrorCodedMsg());
        }
        scc.setTask(sourceTask);
        scc.setStatsTmpDir(this.getWork().getStatsTmpDir());
        return scc;
    }

    private String toString(Map<String, String> parameters) {
        StringBuilder builder = new StringBuilder();
        for (String statType : StatsSetupConst.SUPPORTED_STATS) {
            String value = parameters.get(statType);
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(statType).append('=').append(value);
        }
        return builder.toString();
    }

    private List<Partition> getPartitionsList(Hive db) throws HiveException {
        if (this.work.getLoadFileDesc() != null) {
            return null;
        }
        if (this.work.getTableSpecs() != null) {
            BaseSemanticAnalyzer.TableSpec tblSpec = this.work.getTableSpecs();
            this.table = tblSpec.tableHandle;
            if (!this.table.isPartitioned()) {
                return null;
            }
            return tblSpec.partitions != null ? Collections.unmodifiableList(tblSpec.partitions) : Collections.emptyList();
        }
        if (this.work.getLoadTableDesc() != null) {
            LoadTableDesc tbd = this.work.getLoadTableDesc();
            this.table = db.getTable(tbd.getTable().getTableName());
            if (!this.table.isPartitioned() || this.table.hasNonNativePartitionSupport()) {
                return null;
            }
            DynamicPartitionCtx dpCtx = tbd.getDPCtx();
            if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
                if (this.dpPartSpecs != null) {
                    List<String> partNames = this.dpPartSpecs.stream().map(Partition::getName).collect(Collectors.toList());
                    return db.getPartitionsByNames(this.table, partNames);
                }
            } else {
                return Collections.singletonList(db.getPartition(this.table, tbd.getPartitionSpec()));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void setDpPartSpecs(Collection<Partition> dpPartSpecs) {
        this.dpPartSpecs = dpPartSpecs;
    }

    public static String getAggregationPrefix(Table table, Partition partition) throws MetaException {
        String prefix = BasicStatsTask.getAggregationPrefix0(table, partition);
        return prefix.endsWith("/") ? prefix : prefix + "/";
    }

    private static String getAggregationPrefix0(Table table, Partition partition) throws MetaException {
        String prefix = FileUtils.escapePathName((String)table.getDbName()).toLowerCase() + "." + FileUtils.escapePathName((String)table.getTableName()).toLowerCase();
        if (partition != null) {
            return Utilities.join(prefix, Warehouse.makePartPath(partition.getSpec()));
        }
        return prefix;
    }

    private static class BasicStatsProcessor {
        private Partish partish;
        private List<FileStatus> partfileStatus;
        private boolean isMissingAcidState = false;
        private BasicStatsWork work;
        private boolean followedColStats1;
        private Map<String, String> providedBasicStats;
        private boolean skipStatsUpdate = false;
        private HiveConf conf;

        public BasicStatsProcessor(Partish partish, BasicStatsWork work, boolean followedColStats2) {
            this.partish = partish;
            this.work = work;
            this.followedColStats1 = followedColStats2;
            Table table = partish.getTable();
            if (table.isNonNative() && table.getStorageHandler().canProvideBasicStatistics()) {
                this.providedBasicStats = table.getStorageHandler().computeBasicStatistics(partish);
                this.skipStatsUpdate = StatsSetupConst.STATS_REQUIRE_COMPUTE.stream().anyMatch(this.providedBasicStats::containsKey);
            }
        }

        public Object process(StatsAggregator statsAggregator) throws HiveException, MetaException {
            Partish p = this.partish;
            Map<String, String> parameters = p.getPartParameters();
            if (this.work.isTargetRewritten()) {
                StatsSetupConst.setBasicStatsState(parameters, (String)"true");
            }
            if (!this.work.isExplicitAnalyze() && !this.followedColStats1) {
                StatsSetupConst.clearColumnStatsState(parameters);
            }
            if (this.partfileStatus == null && this.providedBasicStats == null) {
                String spec = this.partish.getPartition() == null ? this.partish.getTable().getTableName() : this.partish.getPartition().getSpec().toString();
                LOG.warn("Partition/partfiles is null for: " + spec);
                if (this.isMissingAcidState) {
                    MetaStoreServerUtils.clearQuickStats(parameters);
                    return p.getOutput();
                }
                return null;
            }
            if (this.work.isClearAggregatorStats()) {
                StatsSetupConst.setBasicStatsState(parameters, (String)"false");
            }
            if (this.providedBasicStats == null) {
                MetaStoreServerUtils.populateQuickStats(this.partfileStatus, parameters);
            } else {
                parameters.putAll(this.providedBasicStats);
            }
            long threshold = this.conf != null ? this.conf.getLongVar(HiveConf.ConfVars.HIVE_MERGE_MAP_FILES_AVG_SIZE) : HiveConf.ConfVars.HIVE_MERGE_MAP_FILES_AVG_SIZE.defaultLongVal;
            String who = p.getPartition() == null ? "table " + p.getTable().getFullyQualifiedName() : "partition " + p.getPartition().getName();
            SmallFilesWarningUtil.smallFilesWarnings(parameters, (long)100L, (long)threshold, (String)who, (String)"[ANALYZE]").ifPresent(msg -> {
                LOG.warn(msg);
                SessionState ss = SessionState.get();
                if (ss != null) {
                    if (ss.getConsole() != null) {
                        ss.getConsole().printInfo((String)msg);
                    }
                }
            });
            if (statsAggregator != null && !this.skipStatsUpdate && (StatsSetupConst.areBasicStatsUptoDate(parameters) || p.isTransactionalTable())) {
                String prefix = BasicStatsTask.getAggregationPrefix(p.getTable(), p.getPartition());
                this.updateStats(statsAggregator, parameters, prefix);
            }
            return p.getOutput();
        }

        public void collectFileStatus(Warehouse wh, HiveConf conf) throws MetaException, IOException {
            this.conf = conf;
            if (this.providedBasicStats == null) {
                if (!this.partish.isTransactionalTable()) {
                    this.partfileStatus = wh.getFileStatusesForSD(this.partish.getPartSd());
                } else {
                    Path path = new Path(this.partish.getPartSd().getLocation());
                    this.partfileStatus = AcidUtils.getAcidFilesForStats(this.partish.getTable(), path, (Configuration)conf, null);
                    this.isMissingAcidState = true;
                }
            }
        }

        private void updateStats(StatsAggregator statsAggregator, Map<String, String> parameters, String aggKey) {
            for (String statType : StatsSetupConst.STATS_REQUIRE_COMPUTE) {
                String originalValue;
                String value = statsAggregator.aggregateStats(aggKey, statType);
                if (value == null || value.isEmpty()) continue;
                long longValue = Long.parseLong(value);
                if (!this.work.isTargetRewritten() && (originalValue = parameters.get(statType)) != null) {
                    longValue += Long.parseLong(originalValue);
                }
                parameters.put(statType, String.valueOf(longValue));
            }
        }
    }

    private static class TransactionalStatsProcessor {
        private final Hive db;
        private final Partish partish;

        private TransactionalStatsProcessor(Hive db, Partish partish) {
            this.db = db;
            this.partish = partish;
        }

        private long toLong(String value) {
            if (value == null || value.isEmpty()) {
                return 0L;
            }
            return Long.parseLong(value);
        }

        public void process(StatsAggregator statsAggregator) throws HiveException, MetaException {
            if (statsAggregator == null) {
                return;
            }
            if (this.partish.isTransactionalTable()) {
                String prefix = BasicStatsTask.getAggregationPrefix(this.partish.getTable(), this.partish.getPartition());
                long insertCount = this.toLong(statsAggregator.aggregateStats(prefix, "insertCount"));
                long updateCount = this.toLong(statsAggregator.aggregateStats(prefix, "updateCount"));
                long deleteCount = this.toLong(statsAggregator.aggregateStats(prefix, "deleteCount"));
                if (insertCount > 0L || updateCount > 0L || deleteCount > 0L) {
                    UpdateTransactionalStatsRequest request = new UpdateTransactionalStatsRequest();
                    request.setTableId(this.partish.getTable().getTTable().getId());
                    request.setInsertCount(insertCount);
                    request.setUpdatedCount(updateCount);
                    request.setDeletedCount(deleteCount);
                    this.db.updateTransactionalStatistics(request);
                }
            }
        }
    }
}

