/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.Explain;

public enum PrivilegeType {
    ALL(1145, "All"),
    ALTER_DATA(1146, "Update"),
    ALTER_METADATA(1147, "Alter"),
    CREATE(1148, "Create"),
    DROP(1150, "Drop"),
    LOCK(1152, "Lock"),
    SELECT(1155, "Select"),
    SHOW_DATABASE(1156, "Show_Database"),
    INSERT(1151, "Insert"),
    DELETE(1149, "Delete"),
    UNKNOWN(null, null);

    private final String name;
    private final Integer token;
    private static Map<Integer, PrivilegeType> token2Type;
    private static Map<String, PrivilegeType> name2Type;

    private PrivilegeType(Integer token, String name) {
        this.name = name;
        this.token = token;
    }

    @Explain(displayName="type", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String toString() {
        return this.name == null ? "unkown" : this.name;
    }

    public Integer getToken() {
        return this.token;
    }

    public static PrivilegeType getPrivTypeByToken(int token) {
        PrivilegeType.populateToken2Type();
        PrivilegeType privType = token2Type.get(token);
        if (privType != null) {
            return privType;
        }
        return UNKNOWN;
    }

    private static synchronized void populateToken2Type() {
        if (token2Type != null) {
            return;
        }
        token2Type = new HashMap<Integer, PrivilegeType>();
        for (PrivilegeType privType : PrivilegeType.values()) {
            token2Type.put(privType.getToken(), privType);
        }
    }

    public static PrivilegeType getPrivTypeByName(String privilegeName) {
        PrivilegeType.populateName2Type();
        String canonicalizedName = privilegeName.toLowerCase();
        PrivilegeType privType = name2Type.get(canonicalizedName);
        if (privType != null) {
            return privType;
        }
        return UNKNOWN;
    }

    private static synchronized void populateName2Type() {
        if (name2Type != null) {
            return;
        }
        name2Type = new HashMap<String, PrivilegeType>();
        for (PrivilegeType privType : PrivilegeType.values()) {
            name2Type.put(privType.toString().toLowerCase(), privType);
        }
    }
}

