/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveOpConverterUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.opconventer.HiveRelNodeVisitor;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hadoop.hive.ql.util.NullOrdering;

class HiveSortExchangeVisitor
extends HiveRelNodeVisitor<HiveSortExchange> {
    HiveSortExchangeVisitor(HiveOpConverter hiveOpConverter) {
        super(hiveOpConverter);
    }

    @Override
    HiveOpConverter.OpAttr visit(HiveSortExchange exchangeRel) throws SemanticException {
        HiveOpConverter.OpAttr inputOpAf = this.hiveOpConverter.dispatch(exchangeRel.getInput());
        String tabAlias = inputOpAf.tabAlias;
        if (tabAlias == null || tabAlias.length() == 0) {
            tabAlias = this.hiveOpConverter.getHiveDerivedTableAlias();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Translating operator rel#" + exchangeRel.getId() + ":" + exchangeRel.getRelTypeName() + " with row type: [" + String.valueOf(exchangeRel.getRowType()) + "]");
        }
        RelDistribution distribution = exchangeRel.getDistribution();
        List<ExprNodeDesc> partitionKeyList = switch (distribution.getType()) {
            case RelDistribution.Type.HASH_DISTRIBUTED -> exchangeRel.getDistribution().getKeys().stream().map(keyIndex -> HiveOpConverterUtils.convertToExprNode((RexNode)exchangeRel.getCluster().getRexBuilder().makeInputRef(exchangeRel.getInput(), keyIndex.intValue()), exchangeRel.getInput(), inputOpAf.tabAlias, inputOpAf.vcolsInCalcite)).collect(Collectors.toList());
            case RelDistribution.Type.ANY -> Collections.emptyList();
            default -> throw new SemanticException("Unsupported distribution type in HiveSortExchange: " + String.valueOf(distribution.getType()));
        };
        ExprNodeDesc[] expressions = new ExprNodeDesc[exchangeRel.getKeys().size()];
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        for (int index = 0; index < exchangeRel.getCollation().getFieldCollations().size(); ++index) {
            RelFieldCollation fieldCollation = (RelFieldCollation)exchangeRel.getCollation().getFieldCollations().get(index);
            expressions[index] = HiveOpConverterUtils.convertToExprNode((RexNode)exchangeRel.getKeys().get(index), exchangeRel.getInput(), inputOpAf.tabAlias, inputOpAf.vcolsInCalcite);
            order.append(DirectionUtils.codeToSign(DirectionUtils.directionToCode(fieldCollation.getDirection())));
            nullOrder.append(NullOrdering.fromDirection(fieldCollation.nullDirection).getSign());
        }
        exchangeRel.setKeyExpressions(expressions);
        Operator inputOp = (Operator)inputOpAf.inputs.get(0);
        ArrayList<String> keepColumns = new ArrayList<String>();
        List<ColumnInfo> inputSchema = inputOp.getSchema().getSignature();
        for (ColumnInfo columnInfo : inputSchema) {
            keepColumns.add(columnInfo.getInternalName());
        }
        ReduceSinkOperator resultOp = HiveOpConverterUtils.genReduceSink((Operator)inputOpAf.inputs.get(0), tabAlias, expressions, -1, partitionKeyList, order.toString(), nullOrder.toString(), -1, AcidUtils.Operation.NOT_ACID, this.hiveOpConverter.getHiveConf());
        return new HiveOpConverter.OpAttr(tabAlias, (Set<Integer>)inputOpAf.vcolsInCalcite, resultOp);
    }
}

