/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.runtime.tree.Tree;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableFunctionScan;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.TableSpool;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveComponentAccess;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortLimit;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableFunctionScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveValues;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.JdbcHiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.optimizer.signature.RelTreeSignature;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASTConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ASTConverter.class);
    public static final String NON_FK_FILTERED = "NON_FK_FILTERED";
    public static final String NON_FK_NOT_FILTERED = "NON_FK_NOT_FILTERED";
    private final RelNode root;
    private final HiveAST hiveAST;
    private RelNode from;
    private Filter where;
    private Aggregate groupBy;
    private Filter having;
    private RelNode select;
    private RelNode orderLimit;
    private List<ASTNode> ctes;
    private Schema schema;
    private long derivedTableCount;
    private PlanMapper planMapper;

    ASTConverter(RelNode root, long dtCounterInitVal, PlanMapper planMapper, List<ASTNode> ctes) {
        this.root = root;
        this.hiveAST = new HiveAST();
        this.derivedTableCount = dtCounterInitVal;
        this.planMapper = planMapper;
        this.ctes = ctes;
    }

    public static ASTNode convert(RelNode relNode, PlanMapper planMapper) throws CalciteSemanticException {
        ASTConverter c = new ASTConverter(relNode, 0L, planMapper, new ArrayList<ASTNode>());
        ASTNode r = c.convert();
        for (ASTNode cte : c.ctes) {
            r.insertChild(0, (Object)cte);
        }
        return r;
    }

    public static ASTNode emptyPlan(RelDataType dataType) {
        if (dataType.getFieldCount() == 0) {
            throw new IllegalArgumentException("Schema is empty.");
        }
        ASTBuilder select = ASTBuilder.construct(1196, "TOK_SELECT");
        for (int i = 0; i < dataType.getFieldCount(); ++i) {
            RelDataTypeField fieldType = (RelDataTypeField)dataType.getFieldList().get(i);
            select.add(ASTBuilder.selectExpr(ASTConverter.createNullField(fieldType.getType()), fieldType.getName()));
        }
        ASTNode insert = ASTBuilder.construct(1059, "TOK_INSERT").add(ASTBuilder.destNode()).add(select).add(ASTBuilder.limit(0, 0)).node();
        return ASTBuilder.construct(1161, "TOK_QUERY").add(insert).node();
    }

    private static ASTNode createNullField(RelDataType fieldType) {
        if (fieldType.getSqlTypeName() == SqlTypeName.NULL) {
            return ASTBuilder.construct(1105, "TOK_NULL").node();
        }
        ASTNode astNode = ASTConverter.convertType(fieldType);
        return ASTBuilder.construct(1039, "TOK_FUNCTION").add(astNode).add(1105, "TOK_NULL").node();
    }

    static ASTNode convertType(RelDataType fieldType) {
        if (fieldType.getSqlTypeName() == SqlTypeName.NULL) {
            return ASTBuilder.construct(1105, "TOK_NULL").node();
        }
        if (fieldType.getSqlTypeName() == SqlTypeName.ROW) {
            ASTBuilder columnListNode = ASTBuilder.construct(1252, "TOK_TABCOLLIST");
            for (RelDataTypeField structFieldType : fieldType.getFieldList()) {
                ASTNode colNode = ASTBuilder.construct(1251, "TOK_TABCOL").add(24, structFieldType.getName()).add(ASTConverter.convertType(structFieldType.getType())).node();
                columnListNode.add(colNode);
            }
            return ASTBuilder.construct(1241, "TOK_STRUCT").add(columnListNode).node();
        }
        if (fieldType.getSqlTypeName() == SqlTypeName.MAP) {
            ASTBuilder mapCallNode = ASTBuilder.construct(1093, "TOK_MAP");
            mapCallNode.add(ASTConverter.convertType(fieldType.getKeyType()));
            mapCallNode.add(ASTConverter.convertType(fieldType.getValueType()));
            return mapCallNode.node();
        }
        if (fieldType.getSqlTypeName() == SqlTypeName.ARRAY) {
            ASTBuilder arrayCallNode = ASTBuilder.construct(1089, "TOK_LIST");
            arrayCallNode.add(ASTConverter.convertType(fieldType.getComponentType()));
            return arrayCallNode.node();
        }
        SqlFunctionConverter.HiveToken ht = TypeConverter.hiveToken(fieldType);
        ASTBuilder astBldr = ASTBuilder.construct(ht.type, ht.text);
        if (ht.args != null) {
            for (String castArg : ht.args) {
                astBldr.add(24, castArg);
            }
        }
        return astBldr.node();
    }

    private ASTNode convert() throws CalciteSemanticException {
        ASTBuilder b;
        ASTNode cond;
        if (this.root instanceof HiveValues) {
            HiveValues values = (HiveValues)this.root;
            if (Values.isEmpty((Values)values)) {
                this.select = values;
                return ASTConverter.emptyPlan(values.getRowType());
            }
            throw new UnsupportedOperationException("Values with non-empty tuples are not supported.");
        }
        new QBVisitor().go(this.root);
        QueryBlockInfo qb = this.convertSource(this.from);
        this.schema = qb.schema;
        this.hiveAST.from = ASTBuilder.construct(1036, "TOK_FROM").add(qb.ast).node();
        if (this.where != null) {
            cond = (ASTNode)this.where.getCondition().accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema, false, this.root.getCluster().getRexBuilder()));
            this.hiveAST.where = ASTBuilder.where(cond);
            this.planMapper.link(cond, this.where);
            this.planMapper.link(cond, RelTreeSignature.of((RelNode)this.where));
        }
        if (this.groupBy != null) {
            boolean groupingSetsExpression = false;
            Aggregate.Group aggregateType = this.groupBy.getGroupType();
            switch (aggregateType) {
                case SIMPLE: {
                    b = ASTBuilder.construct(1048, "TOK_GROUPBY");
                    break;
                }
                case ROLLUP: 
                case CUBE: 
                case OTHER: {
                    b = ASTBuilder.construct(1049, "TOK_GROUPING_SETS");
                    groupingSetsExpression = true;
                    break;
                }
                default: {
                    throw new CalciteSemanticException("Group type not recognized");
                }
            }
            HiveAggregate hiveAgg = (HiveAggregate)this.groupBy;
            if (hiveAgg.getAggregateColumnsOrder() != null) {
                Iterator iterator = hiveAgg.getAggregateColumnsOrder().iterator();
                while (iterator.hasNext()) {
                    int pos = (Integer)iterator.next();
                    this.addRefToBuilder(b, this.groupBy.getGroupSet().nth(pos));
                }
                for (int pos = 0; pos < this.groupBy.getGroupCount(); ++pos) {
                    if (hiveAgg.getAggregateColumnsOrder().contains(pos)) continue;
                    this.addRefToBuilder(b, this.groupBy.getGroupSet().nth(pos));
                }
            } else {
                Iterator pos = this.groupBy.getGroupSet().iterator();
                while (pos.hasNext()) {
                    int i = (Integer)pos.next();
                    this.addRefToBuilder(b, i);
                }
            }
            if (groupingSetsExpression) {
                for (ImmutableBitSet groupSet : this.groupBy.getGroupSets()) {
                    ASTBuilder expression = ASTBuilder.construct(1050, "TOK_GROUPING_SETS_EXPRESSION");
                    Iterator iterator = groupSet.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        this.addRefToBuilder(expression, i);
                    }
                    b.add(expression);
                }
            }
            if (!this.groupBy.getGroupSet().isEmpty()) {
                this.hiveAST.groupBy = b.node();
            }
            this.schema = new Schema(this.schema, this.groupBy);
        }
        if (this.having != null) {
            cond = (ASTNode)this.having.getCondition().accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema, false, this.root.getCluster().getRexBuilder()));
            this.hiveAST.having = ASTBuilder.having(cond);
        }
        b = ASTBuilder.construct(1196, "TOK_SELECT");
        if (this.select instanceof Project) {
            List childExps = ((Project)this.select).getProjects();
            if (childExps.isEmpty()) {
                RexLiteral r = this.select.getCluster().getRexBuilder().makeExactLiteral(new BigDecimal(1));
                ASTNode selectExpr = ASTBuilder.selectExpr(ASTBuilder.literal(r), "1");
                b.add(selectExpr);
            } else {
                int i = 0;
                for (RexNode r : childExps) {
                    ASTNode expr = (ASTNode)r.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema, r instanceof RexLiteral, this.select.getCluster().getRexBuilder()));
                    String alias = (String)this.select.getRowType().getFieldNames().get(i++);
                    ASTNode selectExpr = ASTBuilder.selectExpr(expr, alias);
                    b.add(selectExpr);
                }
            }
            this.hiveAST.select = b.node();
        } else {
            HiveTableFunctionScan udtf = (HiveTableFunctionScan)this.select;
            ArrayList<ASTNode> children = new ArrayList<ASTNode>();
            RexCall call = (RexCall)udtf.getCall();
            for (RexNode r : call.getOperands()) {
                ASTNode expr = (ASTNode)r.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema, r instanceof RexLiteral, this.select.getCluster().getRexBuilder()));
                children.add(expr);
            }
            ASTBuilder sel = ASTBuilder.construct(1198, "TOK_SELEXPR");
            ASTNode function = ASTConverter.buildUDTFAST(call.getOperator().getName(), children);
            sel.add(function);
            List fields = udtf.getRowType().getFieldNames();
            for (int i = 0; i < udtf.getRowType().getFieldCount(); ++i) {
                sel.add(24, (String)fields.get(i));
            }
            b.add(sel);
            this.hiveAST.select = b.node();
        }
        this.convertOrderToASTNode(this.orderLimit);
        return this.hiveAST.getAST();
    }

    private void addRefToBuilder(ASTBuilder b, int i) {
        RexInputRef iRef = new RexInputRef(i, this.root.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY));
        b.add((ASTNode)iRef.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(this.schema, false, this.root.getCluster().getRexBuilder())));
    }

    private static ASTNode buildUDTFAST(String functionName, List<ASTNode> children) {
        ASTNode node = (ASTNode)ParseDriver.adaptor.create(1039, "TOK_FUNCTION");
        node.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(24, functionName)));
        for (ASTNode c : children) {
            ParseDriver.adaptor.addChild((Object)node, (Object)c);
        }
        return node;
    }

    private void convertOrderToASTNode(RelNode node) {
        if (node == null) {
            return;
        }
        if (node instanceof HiveSortLimit) {
            this.convertOrderLimitToASTNode((HiveSortLimit)node);
        } else if (node instanceof HiveSortExchange) {
            this.convertSortToASTNode((HiveSortExchange)node);
        }
    }

    private void convertOrderLimitToASTNode(HiveSortLimit hiveSortLimit) {
        List fieldCollations = hiveSortLimit.getCollation().getFieldCollations();
        this.convertFieldCollationsToASTNode(hiveSortLimit, new Schema(hiveSortLimit), fieldCollations, hiveSortLimit.getInputRefToCallMap(), 1130, "TOK_ORDERBY");
        RexNode offsetExpr = hiveSortLimit.getOffsetExpr();
        RexNode fetchExpr = hiveSortLimit.getFetchExpr();
        if (fetchExpr != null) {
            Object offset = offsetExpr == null ? Integer.valueOf(0) : ((RexLiteral)offsetExpr).getValue2();
            Object fetch = ((RexLiteral)fetchExpr).getValue2();
            this.hiveAST.limit = ASTBuilder.limit(offset, fetch);
        }
    }

    private void convertSortToASTNode(HiveSortExchange hiveSortExchange) {
        Schema sortExchangeSchema = new Schema(hiveSortExchange);
        if (hiveSortExchange.getDistribution().getType() != RelDistribution.Type.ANY) {
            ASTNode distributeByAst = ASTBuilder.createAST(1002, "TOK_DISTRIBUTEBY");
            Iterator iterator = hiveSortExchange.getDistribution().getKeys().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                distributeByAst.addChild((Tree)this.convertSortKey(hiveSortExchange, sortExchangeSchema, null, (ColumnInfo)sortExchangeSchema.get(i)));
            }
            this.hiveAST.distributeBy = distributeByAst;
        }
        List fieldCollations = hiveSortExchange.getCollation().getFieldCollations();
        this.convertFieldCollationsToASTNode(hiveSortExchange, sortExchangeSchema, fieldCollations, null, 1235, "TOK_SORTBY");
    }

    private void convertFieldCollationsToASTNode(RelNode node, Schema schema, List<RelFieldCollation> fieldCollations, Map<Integer, RexNode> obRefToCallMap, int astToken, String astText) {
        if (fieldCollations.isEmpty()) {
            return;
        }
        ASTNode orderAst = ASTBuilder.createAST(astToken, astText);
        for (RelFieldCollation c : fieldCollations) {
            ASTNode nullDirectionAST;
            ASTNode directionAST;
            ASTNode aSTNode = directionAST = c.getDirection() == RelFieldCollation.Direction.ASCENDING ? ASTBuilder.createAST(1281, "TOK_TABSORTCOLNAMEASC") : ASTBuilder.createAST(1282, "TOK_TABSORTCOLNAMEDESC");
            if (c.nullDirection == RelFieldCollation.NullDirection.FIRST) {
                nullDirectionAST = ASTBuilder.createAST(1106, "TOK_NULLS_FIRST");
                directionAST.addChild((Tree)nullDirectionAST);
            } else if (c.nullDirection == RelFieldCollation.NullDirection.LAST) {
                nullDirectionAST = ASTBuilder.createAST(1107, "TOK_NULLS_LAST");
                directionAST.addChild((Tree)nullDirectionAST);
            } else if (c.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                nullDirectionAST = ASTBuilder.createAST(1106, "TOK_NULLS_FIRST");
                directionAST.addChild((Tree)nullDirectionAST);
            } else {
                nullDirectionAST = ASTBuilder.createAST(1107, "TOK_NULLS_LAST");
                directionAST.addChild((Tree)nullDirectionAST);
            }
            RexNode obExpr = null;
            if (obRefToCallMap != null) {
                obExpr = obRefToCallMap.get(c.getFieldIndex());
            }
            ASTNode astCol = this.convertSortKey(node, schema, obExpr, (ColumnInfo)schema.get(c.getFieldIndex()));
            nullDirectionAST.addChild((Tree)astCol);
            orderAst.addChild((Tree)directionAST);
        }
        this.hiveAST.order = orderAst;
    }

    private ASTNode convertSortKey(RelNode node, Schema schema, RexNode obExpr, ColumnInfo columnInfo) {
        ASTNode astCol = obExpr != null ? (ASTNode)obExpr.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(schema, false, node.getCluster().getRexBuilder())) : ASTBuilder.unqualifiedName(columnInfo.column);
        return astCol;
    }

    private Schema getRowSchema(String tblAlias) {
        if (this.select instanceof Project) {
            return new Schema((Project)this.select, tblAlias);
        }
        if (this.select instanceof TableFunctionScan) {
            return new Schema((TableFunctionScan)this.select, tblAlias);
        }
        return new Schema(tblAlias, this.select.getRowType().getFieldList());
    }

    private QueryBlockInfo convertSource(RelNode r) throws CalciteSemanticException {
        Schema s = null;
        ASTNode ast = null;
        if (r instanceof TableScan) {
            TableScan f = (TableScan)r;
            s = new Schema(f);
            ast = ASTBuilder.table((RelNode)f);
            this.planMapper.link(ast, f);
        } else if (r instanceof HiveJdbcConverter) {
            HiveJdbcConverter f = (HiveJdbcConverter)r;
            s = new Schema(f);
            ast = ASTBuilder.table(f);
        } else if (r instanceof DruidQuery) {
            DruidQuery f = (DruidQuery)r;
            s = new Schema(f);
            ast = ASTBuilder.table((RelNode)f);
        } else if (r instanceof Join) {
            boolean semiJoin;
            Join join = (Join)r;
            QueryBlockInfo left = this.convertSource(join.getLeft());
            QueryBlockInfo right = this.convertSource(join.getRight());
            s = new Schema(left.schema, right.schema);
            ASTNode cond = (ASTNode)join.getCondition().accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(s, false, r.getCluster().getRexBuilder()));
            boolean bl = semiJoin = join.isSemiJoin() || join.getJoinType() == JoinRelType.ANTI;
            if (join.getRight() instanceof Join && !semiJoin) {
                JoinRelType type = join.getJoinType() == JoinRelType.LEFT ? JoinRelType.RIGHT : (join.getJoinType() == JoinRelType.RIGHT ? JoinRelType.LEFT : join.getJoinType());
                ast = ASTBuilder.join(right.ast, left.ast, type, cond);
                this.addPkFkInfoToAST(ast, join, true);
            } else {
                ast = ASTBuilder.join(left.ast, right.ast, join.getJoinType(), cond);
                this.addPkFkInfoToAST(ast, join, false);
            }
            if (semiJoin) {
                s = left.schema;
            }
        } else if (r instanceof Union) {
            Union u = (Union)r;
            ASTNode left = new ASTConverter(((Union)r).getInput(0), this.derivedTableCount, this.planMapper, this.ctes).convert();
            for (int ind = 1; ind < u.getInputs().size(); ++ind) {
                left = this.getUnionAllAST(left, new ASTConverter(((Union)r).getInput(ind), this.derivedTableCount, this.planMapper, this.ctes).convert());
                String sqAlias = this.nextAlias();
                ast = ASTBuilder.subQuery(left, sqAlias);
                s = new Schema((Union)r, sqAlias);
            }
        } else {
            if (this.isLateralView(r)) {
                TableFunctionScan tfs = (TableFunctionScan)r;
                return ASTConverter.createASTLateralView(tfs, this.convertSource(tfs.getInput(0)), this.nextAlias());
            }
            if (r instanceof TableSpool) {
                TableSpool spool = (TableSpool)r;
                ASTConverter cteConverter = new ASTConverter(spool.getInput(), this.derivedTableCount, this.planMapper, Collections.emptyList());
                String cteName = (String)Iterables.getLast((Iterable)spool.getTable().getQualifiedName());
                ASTNode cte = ASTBuilder.createAST(971, "TOK_CTE");
                cte.addChild((Tree)ASTBuilder.subQuery(cteConverter.convert(), cteName));
                this.ctes.add(cte);
                return new QueryBlockInfo(cteConverter.getRowSchema(cteName), ASTBuilder.cte(cteName, cteName));
            }
            ASTConverter src = new ASTConverter(r, this.derivedTableCount, this.planMapper, this.ctes);
            ASTNode srcAST = src.convert();
            String sqAlias = this.nextAlias();
            s = src.getRowSchema(sqAlias);
            ast = ASTBuilder.subQuery(srcAST, sqAlias);
        }
        return new QueryBlockInfo(s, ast);
    }

    private void addPkFkInfoToAST(ASTNode ast, Join join, boolean swapSides) {
        ArrayList<RexNode> joinFilters = new ArrayList<RexNode>(RelOptUtil.conjunctions((RexNode)join.getCondition()));
        RelMetadataQuery mq = join.getCluster().getMetadataQuery();
        HiveRelOptUtil.PKFKJoinInfo rightInputResult = HiveRelOptUtil.extractPKFKJoin(join, joinFilters, false, mq);
        HiveRelOptUtil.PKFKJoinInfo leftInputResult = HiveRelOptUtil.extractPKFKJoin(join, joinFilters, true, mq);
        if (leftInputResult.isPkFkJoin && leftInputResult.additionalPredicates.isEmpty()) {
            RelNode nonFkInput = join.getRight();
            ast.addChild((Tree)this.pkFkHint(swapSides ? 1 : 0, HiveRelOptUtil.isRowFilteringPlan(mq, nonFkInput)));
        } else if (rightInputResult.isPkFkJoin && rightInputResult.additionalPredicates.isEmpty()) {
            RelNode nonFkInput = join.getLeft();
            ast.addChild((Tree)this.pkFkHint(swapSides ? 0 : 1, HiveRelOptUtil.isRowFilteringPlan(mq, nonFkInput)));
        }
    }

    private ASTNode pkFkHint(int fkTableIndex, boolean nonFkSideIsFiltered) {
        ParseDriver parseDriver = new ParseDriver();
        try {
            return parseDriver.parseHint(String.format("PKFK_JOIN(%d, %s)", fkTableIndex, nonFkSideIsFiltered ? NON_FK_FILTERED : NON_FK_NOT_FILTERED));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private static QueryBlockInfo createASTLateralView(TableFunctionScan tfs, QueryBlockInfo tableFunctionSource, String alias) {
        ArrayList<ASTNode> children = new ArrayList<ASTNode>();
        RexCall lateralCall = (RexCall)tfs.getCall();
        RexCall call = (RexCall)lateralCall.getOperands().get(0);
        for (RexNode rn : call.getOperands()) {
            ASTNode expr = (ASTNode)rn.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(tableFunctionSource.schema, rn instanceof RexLiteral, tfs.getCluster().getRexBuilder()));
            children.add(expr);
        }
        ASTNode function = ASTConverter.buildUDTFAST(call.getOperator().getName(), children);
        ASTBuilder selexpr = ASTBuilder.construct(1198, "TOK_SELEXPR");
        selexpr.add(function);
        List<RelDataTypeField> lvFields = tfs.getRowType().getFieldList().subList(tableFunctionSource.schema.size(), tfs.getRowType().getFieldCount());
        for (RelDataTypeField field : lvFields) {
            selexpr.add(24, field.getName());
        }
        ASTBuilder tabAlias = ASTBuilder.construct(1250, "TOK_TABALIAS");
        tabAlias.add(24, alias);
        selexpr.add(tabAlias.node());
        ASTBuilder sel = ASTBuilder.construct(1198, "TOK_SELECT");
        sel.add(selexpr.node());
        ASTBuilder lateralview = ASTBuilder.construct(1079, "TOK_LATERAL_VIEW");
        lateralview.add(sel.node());
        lateralview.add(tableFunctionSource.ast);
        Schema outputSchema = new Schema(tableFunctionSource.schema, new Schema(alias, lvFields));
        return new QueryBlockInfo(outputSchema, lateralview.node());
    }

    private boolean isLateralView(RelNode relNode) {
        if (!(relNode instanceof TableFunctionScan)) {
            return false;
        }
        TableFunctionScan htfs = (TableFunctionScan)relNode;
        RexCall call = (RexCall)htfs.getCall();
        return ((RexCall)htfs.getCall()).getOperator() == SqlStdOperatorTable.LATERAL;
    }

    private String nextAlias() {
        String tabAlias = String.format("$hdt$_%d", this.derivedTableCount);
        ++this.derivedTableCount;
        return tabAlias;
    }

    public ASTNode getUnionAllAST(ASTNode leftAST, ASTNode rightAST) {
        ASTNode unionTokAST = ASTBuilder.construct(1301, "TOK_UNIONALL").add(leftAST).add(rightAST).node();
        return unionTokAST;
    }

    public static boolean isFlat(RexCall call) {
        SqlOperator op;
        boolean flat = false;
        if (call.operands != null && call.operands.size() > 2 && ((op = call.getOperator()).getKind() == SqlKind.AND || op.getKind() == SqlKind.OR)) {
            flat = true;
        }
        return flat;
    }

    static class HiveAST {
        ASTNode from;
        ASTNode where;
        ASTNode groupBy;
        ASTNode having;
        ASTNode select;
        ASTNode distributeBy;
        ASTNode order;
        ASTNode limit;

        HiveAST() {
        }

        public ASTNode getAST() {
            ASTBuilder b = ASTBuilder.construct(1161, "TOK_QUERY").add(this.from).add(ASTBuilder.construct(1059, "TOK_INSERT").add(ASTBuilder.destNode()).add(this.select).add(this.where).add(this.groupBy).add(this.having).add(this.distributeBy).add(this.order).add(this.limit));
            return b.node();
        }
    }

    class QBVisitor
    extends RelVisitor {
        QBVisitor() {
        }

        public void handle(Filter filter) {
            RelNode child = filter.getInput();
            if (child instanceof Aggregate && !((Aggregate)child).getGroupSet().isEmpty()) {
                ASTConverter.this.having = filter;
            } else {
                ASTConverter.this.where = filter;
            }
        }

        public void handle(Project project) {
            if (ASTConverter.this.select == null) {
                ASTConverter.this.select = project;
            } else {
                ASTConverter.this.from = project;
            }
        }

        public void handle(TableFunctionScan tableFunctionScan) {
            if (ASTConverter.this.select == null) {
                ASTConverter.this.select = tableFunctionScan;
            } else {
                ASTConverter.this.from = tableFunctionScan;
            }
        }

        public void handle(Values values) {
            if (ASTConverter.this.select == null) {
                ASTConverter.this.select = values;
            } else {
                ASTConverter.this.from = values;
            }
        }

        public void visit(RelNode node, int ordinal, RelNode parent) {
            if (node instanceof TableScan || node instanceof DruidQuery || node instanceof HiveJdbcConverter) {
                ASTConverter.this.from = node;
            } else if (node instanceof Filter) {
                this.handle((Filter)node);
            } else if (node instanceof Project) {
                this.handle((Project)node);
            } else if (node instanceof TableFunctionScan) {
                this.handle((TableFunctionScan)node);
            } else if (node instanceof Join) {
                ASTConverter.this.from = node;
            } else if (node instanceof Union) {
                ASTConverter.this.from = node;
            } else if (node instanceof TableSpool) {
                ASTConverter.this.from = node;
            } else if (node instanceof Aggregate) {
                ASTConverter.this.groupBy = (Aggregate)node;
            } else if (node instanceof Sort || node instanceof Exchange) {
                if (ASTConverter.this.select != null) {
                    ASTConverter.this.from = node;
                } else {
                    ASTConverter.this.orderLimit = node;
                }
            } else if (node instanceof Values) {
                this.handle((HiveValues)node);
            }
            if (ASTConverter.this.from == null) {
                node.childrenAccept((RelVisitor)this);
            }
        }
    }

    static class QueryBlockInfo {
        Schema schema;
        ASTNode ast;

        public QueryBlockInfo(Schema schema, ASTNode ast) {
            this.schema = schema;
            this.ast = ast;
        }
    }

    static class Schema
    extends ArrayList<ColumnInfo> {
        private static final long serialVersionUID = 1L;

        Schema(TableScan scan) {
            HiveTableScan hts = (HiveTableScan)scan;
            String tabName = hts.getTableAlias();
            for (RelDataTypeField field : scan.getRowType().getFieldList()) {
                this.add(new ColumnInfo(tabName, field.getName()));
            }
        }

        Schema(DruidQuery dq) {
            HiveTableScan hts = (HiveTableScan)dq.getTableScan();
            String tabName = hts.getTableAlias();
            for (RelDataTypeField field : dq.getRowType().getFieldList()) {
                this.add(new ColumnInfo(tabName, field.getName()));
            }
        }

        Schema(HiveJdbcConverter scan) {
            HiveJdbcConverter jdbcHiveCoverter = scan;
            JdbcHiveTableScan jdbcTableScan = jdbcHiveCoverter.getTableScan();
            String tabName = jdbcTableScan.getHiveTableScan().getTableAlias();
            for (RelDataTypeField field : jdbcHiveCoverter.getRowType().getFieldList()) {
                this.add(new ColumnInfo(tabName, field.getName()));
            }
        }

        Schema(Project select, String alias) {
            for (RelDataTypeField field : select.getRowType().getFieldList()) {
                this.add(new ColumnInfo(alias, field.getName()));
            }
        }

        Schema(TableFunctionScan select, String alias) {
            for (RelDataTypeField field : select.getRowType().getFieldList()) {
                this.add(new ColumnInfo(alias, field.getName()));
            }
        }

        Schema(Union unionRel, String alias) {
            for (RelDataTypeField field : unionRel.getRowType().getFieldList()) {
                this.add(new ColumnInfo(alias, field.getName()));
            }
        }

        Schema(Schema left, Schema right) {
            for (ColumnInfo cI : Iterables.concat((Iterable)left, (Iterable)right)) {
                this.add(cI);
            }
        }

        Schema(Schema src, Aggregate gBy) {
            Iterator iterator = gBy.getGroupSet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ColumnInfo cI = (ColumnInfo)src.get(i);
                this.add(cI);
            }
            List aggs = gBy.getAggCallList();
            for (AggregateCall agg : aggs) {
                if (agg.getAggregation() == HiveGroupingID.INSTANCE) {
                    this.add(new ColumnInfo(null, VirtualColumn.GROUPINGID.getName()));
                    continue;
                }
                int argCount = agg.getArgList().size();
                ASTBuilder b = agg.isDistinct() ? ASTBuilder.construct(1040, "TOK_FUNCTIONDI") : (argCount == 0 ? ASTBuilder.construct(1041, "TOK_FUNCTIONSTAR") : ASTBuilder.construct(1039, "TOK_FUNCTION"));
                b.add(24, agg.getAggregation().getName());
                ListIterator collationIterator = agg.collation.getFieldCollations().listIterator();
                RexBuilder rexBuilder = gBy.getCluster().getRexBuilder();
                Iterator iterator2 = agg.getArgList().iterator();
                while (iterator2.hasNext()) {
                    int i = (Integer)iterator2.next();
                    RexInputRef iRef = new RexInputRef(i, gBy.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY));
                    b.add((ASTNode)iRef.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(src, false, gBy.getCluster().getRexBuilder())));
                    if (!collationIterator.hasNext()) continue;
                    RelFieldCollation fieldCollation = (RelFieldCollation)collationIterator.next();
                    RexInputRef inputRef = new RexInputRef(fieldCollation.getFieldIndex(), gBy.getCluster().getTypeFactory().createSqlType(SqlTypeName.ANY));
                    b.add((ASTNode)inputRef.accept((org.apache.calcite.rex.RexVisitor)new RexVisitor(src, false, rexBuilder)));
                    b.add(ASTBuilder.createAST(428, Integer.toString(DirectionUtils.directionToCode(fieldCollation.getDirection()))));
                    b.add(ASTBuilder.createAST(428, Integer.toString(NullOrdering.fromDirection(fieldCollation.nullDirection).getCode())));
                }
                this.add(new ColumnInfo(null, b.node()));
            }
        }

        Schema(HiveSortLimit order) {
            this((Project)order.getInput(), null);
        }

        Schema(HiveSortExchange sort) {
            this((Project)sort.getInput(), null);
        }

        public Schema(String tabAlias, List<RelDataTypeField> fieldList) {
            for (RelDataTypeField field : fieldList) {
                this.add(new ColumnInfo(tabAlias, field.getName()));
            }
        }
    }

    static class RexVisitor
    extends RexVisitorImpl<ASTNode> {
        private final Schema schema;
        private final RexBuilder rexBuilder;
        private Map<RexLiteral, Boolean> nullLiteralMap;

        protected RexVisitor(Schema schema, boolean useTypeQualInLiteral) {
            this(schema, useTypeQualInLiteral, null);
        }

        protected RexVisitor(Schema schema) {
            this(schema, false);
        }

        protected RexVisitor(Schema schema, boolean useTypeQualInLiteral, RexBuilder rexBuilder) {
            super(true);
            this.schema = schema;
            this.rexBuilder = rexBuilder;
            this.nullLiteralMap = new TreeMap<RexLiteral, Boolean>(new Comparator<RexLiteral>(this){

                @Override
                public int compare(RexLiteral o1, RexLiteral o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    return 1;
                }
            });
        }

        public ASTNode visitFieldAccess(RexFieldAccess fieldAccess) {
            return ASTBuilder.construct(16, ".").add((ASTNode)super.visitFieldAccess(fieldAccess)).add(24, fieldAccess.getField().getName()).node();
        }

        public ASTNode visitInputRef(RexInputRef inputRef) {
            ColumnInfo cI = (ColumnInfo)this.schema.get(inputRef.getIndex());
            if (cI.agg != null) {
                return (ASTNode)ParseDriver.adaptor.dupTree((Object)cI.agg);
            }
            if (cI.table == null || cI.table.isEmpty()) {
                return ASTBuilder.unqualifiedName(cI.column);
            }
            return ASTBuilder.qualifiedName(cI.table, cI.column);
        }

        public ASTNode visitLiteral(RexLiteral literal) {
            if (RexUtil.isNull((RexNode)literal) && literal.getType().getSqlTypeName() != SqlTypeName.NULL && this.rexBuilder != null) {
                if (this.nullLiteralMap.containsKey(literal)) {
                    return ASTBuilder.literal(literal);
                }
                this.nullLiteralMap.put(literal, true);
                RexNode r = this.rexBuilder.makeAbstractCast(literal.getType(), (RexNode)literal);
                return (ASTNode)r.accept((org.apache.calcite.rex.RexVisitor)this);
            }
            return ASTBuilder.literal(literal);
        }

        private ASTNode getPSpecAST(RexWindow window) {
            ASTNode pSpecAst = null;
            ASTNode dByAst = null;
            if (window.partitionKeys != null && !window.partitionKeys.isEmpty()) {
                dByAst = ASTBuilder.createAST(1002, "TOK_DISTRIBUTEBY");
                for (RexNode pk : window.partitionKeys) {
                    ASTNode astCol = (ASTNode)pk.accept((org.apache.calcite.rex.RexVisitor)this);
                    dByAst.addChild((Tree)astCol);
                }
            }
            ASTNode oByAst = null;
            if (window.orderKeys != null && !window.orderKeys.isEmpty()) {
                oByAst = ASTBuilder.createAST(1130, "TOK_ORDERBY");
                for (RexFieldCollation ok : window.orderKeys) {
                    ASTNode nullDirectionAST;
                    ASTNode directionAST;
                    ASTNode aSTNode = directionAST = ok.getDirection() == RelFieldCollation.Direction.ASCENDING ? ASTBuilder.createAST(1281, "TOK_TABSORTCOLNAMEASC") : ASTBuilder.createAST(1282, "TOK_TABSORTCOLNAMEDESC");
                    if (((ImmutableSet)ok.right).contains((Object)SqlKind.NULLS_FIRST)) {
                        nullDirectionAST = ASTBuilder.createAST(1106, "TOK_NULLS_FIRST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else if (((ImmutableSet)ok.right).contains((Object)SqlKind.NULLS_LAST)) {
                        nullDirectionAST = ASTBuilder.createAST(1107, "TOK_NULLS_LAST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else if (ok.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                        nullDirectionAST = ASTBuilder.createAST(1106, "TOK_NULLS_FIRST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    } else {
                        nullDirectionAST = ASTBuilder.createAST(1107, "TOK_NULLS_LAST");
                        directionAST.addChild((Tree)nullDirectionAST);
                    }
                    ASTNode astCol = (ASTNode)((RexNode)ok.left).accept((org.apache.calcite.rex.RexVisitor)this);
                    nullDirectionAST.addChild((Tree)astCol);
                    oByAst.addChild((Tree)directionAST);
                }
            }
            if (dByAst != null || oByAst != null) {
                pSpecAst = ASTBuilder.createAST(1134, "TOK_PARTITIONINGSPEC");
                if (dByAst != null) {
                    pSpecAst.addChild((Tree)dByAst);
                }
                if (oByAst != null) {
                    pSpecAst.addChild((Tree)oByAst);
                }
            }
            return pSpecAst;
        }

        private ASTNode getWindowBound(RexWindowBound wb) {
            ASTNode wbAST = null;
            if (wb.isCurrentRow()) {
                wbAST = ASTBuilder.createAST(90, "CURRENT");
            } else {
                wbAST = wb.isPreceding() ? ASTBuilder.createAST(267, "PRECEDING") : ASTBuilder.createAST(156, "FOLLOWING");
                if (wb.isUnbounded()) {
                    wbAST.addChild((Tree)ASTBuilder.createAST(376, "UNBOUNDED"));
                } else {
                    ASTNode offset = (ASTNode)wb.getOffset().accept((org.apache.calcite.rex.RexVisitor)this);
                    wbAST.addChild((Tree)offset);
                }
            }
            return wbAST;
        }

        private ASTNode getWindowRangeAST(RexWindow window) {
            ASTNode wRangeAst = null;
            ASTNode startAST = null;
            boolean lbUnbounded = false;
            RexWindowBound lb = window.getLowerBound();
            if (lb != null) {
                startAST = this.getWindowBound(lb);
                lbUnbounded = lb.isUnbounded();
            }
            ASTNode endAST = null;
            boolean ubUnbounded = false;
            RexWindowBound ub = window.getUpperBound();
            if (ub != null) {
                endAST = this.getWindowBound(ub);
                ubUnbounded = ub.isUnbounded();
            }
            if (startAST != null || endAST != null) {
                wRangeAst = window.isRows() || lbUnbounded && ubUnbounded ? ASTBuilder.createAST(1325, "TOK_WINDOWRANGE") : ASTBuilder.createAST(1327, "TOK_WINDOWVALUES");
                if (startAST != null) {
                    wRangeAst.addChild((Tree)startAST);
                }
                if (endAST != null) {
                    wRangeAst.addChild((Tree)endAST);
                }
            }
            return wRangeAst;
        }

        public ASTNode visitOver(RexOver over) {
            if (!this.deep) {
                return null;
            }
            ASTNode wUDAFAst = this.visitCall((RexCall)over);
            ASTNode wSpec = ASTBuilder.createAST(1326, "TOK_WINDOWSPEC");
            wUDAFAst.addChild((Tree)wSpec);
            RexWindow window = over.getWindow();
            ASTNode wPSpecAst = this.getPSpecAST(window);
            ASTNode wRangeAst = this.getWindowRangeAST(window);
            if (wPSpecAst != null) {
                wSpec.addChild((Tree)wPSpecAst);
            }
            if (wRangeAst != null) {
                wSpec.addChild((Tree)wRangeAst);
            }
            if (over.ignoreNulls()) {
                ASTNode ignoreNulls = ASTBuilder.createAST(1056, "TOK_IGNORE_NULLS");
                wSpec.addChild((Tree)ignoreNulls);
            }
            return wUDAFAst;
        }

        public ASTNode visitCall(RexCall call) {
            if (!this.deep) {
                return null;
            }
            SqlOperator op = call.getOperator();
            LinkedList<ASTNode> astNodeLst = new LinkedList<ASTNode>();
            switch (op.kind) {
                case EQUALS: 
                case NOT_EQUALS: 
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    if (this.rexBuilder != null && RexUtil.isReferenceOrAccess((RexNode)((RexNode)call.operands.get(1)), (boolean)true) && RexUtil.isLiteral((RexNode)((RexNode)call.operands.get(0)), (boolean)true)) {
                        return this.visitCall((RexCall)RexUtil.invert((RexBuilder)this.rexBuilder, (RexCall)call));
                    }
                    for (RexNode operand : call.operands) {
                        astNodeLst.add((ASTNode)operand.accept((org.apache.calcite.rex.RexVisitor)this));
                    }
                    break;
                }
                case IS_DISTINCT_FROM: {
                    for (RexNode operand : call.operands) {
                        astNodeLst.add((ASTNode)operand.accept((org.apache.calcite.rex.RexVisitor)this));
                    }
                    return SqlFunctionConverter.buildAST((SqlOperator)SqlStdOperatorTable.NOT, Collections.singletonList(SqlFunctionConverter.buildAST((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, astNodeLst, call.getType())), call.getType());
                }
                case CAST: {
                    assert (call.getOperands().size() == 1);
                    astNodeLst.add(ASTConverter.convertType(call.getType()));
                    astNodeLst.add((ASTNode)((RexNode)call.getOperands().get(0)).accept((org.apache.calcite.rex.RexVisitor)this));
                    break;
                }
                case EXTRACT: {
                    astNodeLst.add((ASTNode)((RexNode)call.operands.get(1)).accept((org.apache.calcite.rex.RexVisitor)this));
                    break;
                }
                case FLOOR: {
                    if (call.operands.size() == 2) {
                        astNodeLst.add((ASTNode)((RexNode)call.operands.get(0)).accept((org.apache.calcite.rex.RexVisitor)this));
                        break;
                    }
                }
                default: {
                    if (op.equals((Object)HiveComponentAccess.COMPONENT_ACCESS)) {
                        return (ASTNode)((RexNode)call.operands.get(0)).accept((org.apache.calcite.rex.RexVisitor)this);
                    }
                    for (RexNode operand : call.operands) {
                        astNodeLst.add((ASTNode)operand.accept((org.apache.calcite.rex.RexVisitor)this));
                    }
                }
            }
            if (ASTConverter.isFlat(call)) {
                return SqlFunctionConverter.buildAST(op, astNodeLst, 0);
            }
            return SqlFunctionConverter.buildAST(op, astNodeLst, call.getType());
        }

        public ASTNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return ASTBuilder.dynamicParam(dynamicParam);
        }
    }

    static class ColumnInfo {
        String table;
        String column;
        ASTNode agg;

        ColumnInfo(String table, String column) {
            this.table = table;
            this.column = column;
        }

        ColumnInfo(String table, ASTNode agg) {
            this.table = table;
            this.agg = agg;
        }

        ColumnInfo(String alias, ColumnInfo srcCol) {
            this.table = alias;
            this.column = srcCol.column;
            this.agg = srcCol.agg;
        }
    }
}

