/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastLongHashTable
extends VectorMapJoinFastHashTable
implements VectorMapJoinLongHashTable {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastLongHashTable.class);
    private final VectorMapJoinDesc.HashTableKeyType hashTableKeyType;
    private final BinarySortableDeserializeRead keyBinarySortableDeserializeRead;
    private final boolean useMinMax;
    private long min;
    private long max;
    protected long[] slotPairs;

    @Override
    public boolean useMinMax() {
        return this.useMinMax;
    }

    @Override
    public long min() {
        return this.min;
    }

    @Override
    public long max() {
        return this.max;
    }

    public boolean adaptPutRow(long hashCode, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.keyBinarySortableDeserializeRead.set(keyBytes, 0, keyLength);
        try {
            if (!this.keyBinarySortableDeserializeRead.readNextField()) {
                return false;
            }
        }
        catch (Exception e) {
            throw new HiveException("DeserializeRead details: " + this.keyBinarySortableDeserializeRead.getDetailedReadPositionString(), (Throwable)e);
        }
        long key = VectorMapJoinFastLongHashUtil.deserializeLongKey(this.keyBinarySortableDeserializeRead, this.hashTableKeyType);
        this.add(hashCode, key, currentValue);
        return true;
    }

    protected abstract void assignSlot(int var1, long var2, boolean var4, BytesWritable var5);

    public void add(long hashCode, long key, BytesWritable currentValue) {
        boolean isNewKey;
        if (this.checkResize()) {
            this.expandAndRehash();
        }
        int slot = (int)hashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        while (true) {
            int pairIndex;
            long valueRef;
            if ((valueRef = this.slotPairs[pairIndex = 2 * slot]) == 0L) {
                isNewKey = true;
                break;
            }
            long tableKey = this.slotPairs[pairIndex + 1];
            if (key == tableKey) {
                isNewKey = false;
                break;
            }
            ++this.metricPutConflict;
            slot = (int)((probeSlot += (long)(++i)) & (long)this.logicalHashBucketMask);
        }
        if (this.largestNumberOfSteps < i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probed " + i + " slots (the longest so far) to find space");
            }
            this.largestNumberOfSteps = i;
        }
        this.assignSlot(slot, key, isNewKey, currentValue);
        if (isNewKey) {
            ++this.keysAssigned;
            if (this.useMinMax) {
                if (key < this.min) {
                    this.min = key;
                }
                if (key > this.max) {
                    this.max = key;
                }
            }
        }
    }

    private void expandAndRehash() {
        if (this.logicalHashBucketCount > 0x10000000) {
            this.throwExpandError(0x10000000, "Long");
        }
        int newLogicalHashBucketCount = Math.max(0x100000, this.logicalHashBucketCount * 2);
        int newLogicalHashBucketMask = newLogicalHashBucketCount - 1;
        int newMetricPutConflict = 0;
        int newLargestNumberOfSteps = 0;
        int newSlotPairArraySize = newLogicalHashBucketCount * 2;
        long[] newSlotPairs = new long[newSlotPairArraySize];
        for (int slot = 0; slot < this.logicalHashBucketCount; ++slot) {
            int newPairIndex;
            long newValueRef;
            int pairIndex = slot * 2;
            long valueRef = this.slotPairs[pairIndex];
            if (valueRef == 0L) continue;
            long tableKey = this.slotPairs[pairIndex + 1];
            long hashCode = HashCodeUtil.calculateLongHashCode((long)tableKey);
            int intHashCode = (int)hashCode;
            int newSlot = intHashCode & newLogicalHashBucketMask;
            long newProbeSlot = newSlot;
            int i = 0;
            while ((newValueRef = newSlotPairs[newPairIndex = newSlot * 2]) != 0L) {
                ++newMetricPutConflict;
                newSlot = (int)((newProbeSlot += (long)(++i)) & (long)newLogicalHashBucketMask);
            }
            if (newLargestNumberOfSteps < i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Probed " + i + " slots (the longest so far) to find space");
                }
                newLargestNumberOfSteps = i;
            }
            newSlotPairs[newPairIndex] = valueRef;
            newSlotPairs[newPairIndex + 1] = tableKey;
        }
        this.slotPairs = newSlotPairs;
        this.logicalHashBucketCount = newLogicalHashBucketCount;
        this.logicalHashBucketMask = newLogicalHashBucketMask;
        this.metricPutConflict = newMetricPutConflict;
        this.largestNumberOfSteps = newLargestNumberOfSteps;
        this.resizeThreshold = (int)((float)this.logicalHashBucketCount * this.loadFactor);
        ++this.metricExpands;
    }

    protected boolean containsKey(long key) {
        long hashCode = HashCodeUtil.calculateLongHashCode((long)key);
        return this.findReadSlot(key, hashCode) != -1;
    }

    protected int findReadSlot(long key, long hashCode) {
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        int pairIndex;
        long valueRef;
        while ((valueRef = this.slotPairs[pairIndex = 2 * slot]) != 0L) {
            long tableKey = this.slotPairs[pairIndex + 1];
            if (key == tableKey) {
                return pairIndex;
            }
            probeSlot += (long)(++i);
            if (i > this.largestNumberOfSteps) {
                return -1;
            }
            slot = (int)(probeSlot & (long)this.logicalHashBucketMask);
        }
        return -1;
    }

    private void allocateBucketArray() {
        if (this.logicalHashBucketCount > 0x10000000) {
            this.throwExpandError(0x10000000, "Long");
        }
        int slotPairArraySize = 2 * this.logicalHashBucketCount;
        this.slotPairs = new long[slotPairArraySize];
    }

    public VectorMapJoinFastLongHashTable(boolean isFullOuter, boolean minMaxEnabled, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount, TableDesc tableDesc) {
        super(isFullOuter, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
        this.hashTableKeyType = hashTableKeyType;
        PrimitiveTypeInfo[] primitiveTypeInfos = new PrimitiveTypeInfo[]{hashTableKeyType.getPrimitiveTypeInfo()};
        this.keyBinarySortableDeserializeRead = BinarySortableDeserializeRead.with((TypeInfo[])primitiveTypeInfos, (boolean)false, (Properties)tableDesc.getProperties());
        this.allocateBucketArray();
        this.useMinMax = minMaxEnabled;
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
    }

    @Override
    public long getEstimatedMemorySize() {
        JavaDataModel jdm = JavaDataModel.get();
        long size = super.getEstimatedMemorySize();
        size += this.slotPairs == null ? 0L : jdm.lengthForLongArrayOfSize((long)this.slotPairs.length);
        size += (long)(2 * jdm.primitive2());
        size += (long)(2 * jdm.primitive1());
        size += (long)jdm.object();
        return size += 16384L;
    }
}

