/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;

public class TimestampColSubtractDateColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final transient Timestamp scratchTimestamp2 = new Timestamp(0L);
    private final transient DateTimeMath dtm = new DateTimeMath();

    public TimestampColSubtractDateColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(colNum1, colNum2, outputColumnNum);
    }

    public TimestampColSubtractDateColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.inputColumnNum[1]];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        long[] vector2 = inputColVector2.vector;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            this.scratchTimestamp2.setTime(DateWritableV2.daysToMillis((int)((int)vector2[0])));
            this.dtm.subtract(inputColVector1.asScratchTimestamp(0), this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
            outputColVector.setFromScratchIntervalDayTime(0);
        } else if (inputColVector1.isRepeating) {
            Timestamp value1 = inputColVector1.asScratchTimestamp(0);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchTimestamp2.setTime(DateWritableV2.daysToMillis((int)((int)vector2[i])));
                    this.dtm.subtract(value1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp2.setTime(DateWritableV2.daysToMillis((int)((int)vector2[i])));
                    this.dtm.subtract(value1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else if (inputColVector2.isRepeating) {
            this.scratchTimestamp2.setTime(DateWritableV2.daysToMillis((int)((int)vector2[0])));
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.scratchTimestamp2.setTime(DateWritableV2.daysToMillis((int)((int)vector2[i])));
                this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(i);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.scratchTimestamp2.setTime(DateWritableV2.daysToMillis((int)((int)vector2[i])));
                this.dtm.subtract(inputColVector1.asScratchTimestamp(i), this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(i);
            }
        }
        NullUtil.setNullDataEntriesIntervalDayTime(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.inputColumnNum[1]);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("timestamp"), VectorExpressionDescriptor.ArgumentType.getType("date")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

