/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.LongColNotEqualLongScalar;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class Decimal64ColNotEqualDecimal64Scalar
extends LongColNotEqualLongScalar {
    private static final long serialVersionUID = 1L;

    public Decimal64ColNotEqualDecimal64Scalar(int colNum, long value, int outputColumnNum) {
        super(colNum, value, outputColumnNum);
    }

    public Decimal64ColNotEqualDecimal64Scalar() {
    }

    @Override
    public String vectorExpressionParameters() {
        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)this.inputTypeInfos[0];
        HiveDecimalWritable writable = new HiveDecimalWritable();
        writable.deserialize64(this.value, decimalTypeInfo.scale());
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", decimal64Val " + this.value + ", decimalVal " + writable.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DECIMAL_64, VectorExpressionDescriptor.ArgumentType.DECIMAL_64).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }

    @Override
    public boolean shouldConvertDecimal64ToDecimal() {
        return false;
    }
}

