/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.plugin.rpc.LlapPluginProtocolProtos;
import org.apache.hadoop.hive.ql.exec.tez.AmPluginNode;
import org.apache.hadoop.hive.ql.exec.tez.LlapPluginEndpointClient;
import org.apache.hadoop.hive.ql.exec.tez.QueryAllocationManager;
import org.apache.hadoop.hive.ql.exec.tez.WmTezSession;
import org.apache.hadoop.hive.ql.optimizer.physical.LlapClusterStateForCompile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuaranteedTasksAllocator
implements QueryAllocationManager {
    private static final Logger LOG = LoggerFactory.getLogger(GuaranteedTasksAllocator.class);
    private static final long CLUSTER_INFO_UPDATE_INTERVAL_MS = 120000L;
    private final Configuration conf;
    private final LlapClusterStateForCompile clusterState;
    private final Thread clusterStateUpdateThread;
    private final LlapPluginEndpointClient amCommunicator;
    private Runnable clusterChangedCallback;

    public GuaranteedTasksAllocator(Configuration conf, LlapPluginEndpointClient amCommunicator) {
        this.conf = conf;
        this.clusterState = new LlapClusterStateForCompile(conf, 120000L);
        this.amCommunicator = amCommunicator;
        this.clusterStateUpdateThread = new Thread(new Runnable(){
            private int lastExecutorCount = -1;

            @Override
            public void run() {
                while (true) {
                    int executorCount;
                    if ((executorCount = GuaranteedTasksAllocator.this.getExecutorCount(true)) != this.lastExecutorCount && this.lastExecutorCount >= 0) {
                        GuaranteedTasksAllocator.this.clusterChangedCallback.run();
                    }
                    this.lastExecutorCount = executorCount;
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException e) {
                        LOG.info("Cluster state update thread was interrupted");
                        return;
                    }
                }
            }
        }, "Cluster State Updater");
        this.clusterStateUpdateThread.setDaemon(true);
    }

    @Override
    public void start() {
        this.clusterState.initClusterInfo();
        this.clusterStateUpdateThread.start();
    }

    @Override
    public void stop() {
        this.clusterStateUpdateThread.interrupt();
    }

    @VisibleForTesting
    protected int getExecutorCount(boolean allowUpdate) {
        if (allowUpdate && !this.clusterState.initClusterInfo()) {
            LOG.warn("Failed to get LLAP cluster information for " + HiveConf.getTrimmedVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS) + "; we may rely on outdated cluster status");
        }
        if (!this.clusterState.hasClusterInfo()) {
            LOG.error("No cluster information available to allocate; no guaranteed tasks will be used");
            return 0;
        }
        int unknownNodes = this.clusterState.getNodeCountWithUnknownExecutors();
        if (unknownNodes > 0) {
            LOG.error("There are " + unknownNodes + " nodes with unknown executor count; only " + this.clusterState.getKnownExecutorCount() + " guaranteed tasks will be allocated");
        }
        return this.clusterState.getKnownExecutorCount();
    }

    @Override
    public int translateAllocationToCpus(double allocation) {
        return (int)Math.round((double)this.getExecutorCount(false) * allocation);
    }

    @Override
    public int updateSessionsAsync(Double totalMaxAlloc, List<WmTezSession> sessionsToUpdate) {
        int totalCount = this.getExecutorCount(false);
        int totalToDistribute = -1;
        if (totalMaxAlloc != null) {
            totalToDistribute = (int)Math.round((double)totalCount * totalMaxAlloc);
        }
        int totalDistributed = 0;
        double lastDelta = 0.0;
        for (int i = 0; i < sessionsToUpdate.size(); ++i) {
            WmTezSession session = sessionsToUpdate.get(i);
            int intAlloc = -1;
            if (i + 1 == sessionsToUpdate.size() && totalToDistribute >= 0) {
                intAlloc = totalToDistribute;
            } else {
                assert (session.hasClusterFraction());
                double fraction = session.getClusterFraction();
                double allocation = fraction * (double)totalCount + lastDelta;
                double roundedAlloc = Math.round(allocation);
                lastDelta = allocation - roundedAlloc;
                if (roundedAlloc < 0.0) {
                    roundedAlloc = 0.0;
                }
                intAlloc = (int)roundedAlloc;
            }
            if (totalToDistribute >= 0) {
                if (intAlloc > totalToDistribute) {
                    intAlloc = totalToDistribute;
                }
                totalToDistribute -= intAlloc;
            }
            totalDistributed += intAlloc;
            this.updateSessionAsync(session, intAlloc);
        }
        return totalDistributed;
    }

    @Override
    public void updateSessionAsync(WmTezSession session) {
        this.updateSessionAsync(session, null);
    }

    private void updateSessionAsync(WmTezSession session, Integer intAlloc) {
        Integer valueToSend = session.setSendingGuaranteed(intAlloc);
        if (valueToSend == null) {
            return;
        }
        LlapPluginProtocolProtos.UpdateQueryRequestProto request = LlapPluginProtocolProtos.UpdateQueryRequestProto.newBuilder().setGuaranteedTaskCount(valueToSend.intValue()).build();
        LOG.info("Updating {} with {} guaranteed tasks", (Object)session.getSessionId(), (Object)intAlloc);
        this.amCommunicator.sendUpdateQuery(request, session, new UpdateCallback(session));
    }

    @Override
    public void setClusterChangedCallback(Runnable clusterChangedCallback) {
        this.clusterChangedCallback = clusterChangedCallback;
    }

    private final class UpdateCallback
    implements LlapPluginEndpointClient.UpdateRequestContext {
        private final WmTezSession session;
        private int endpointVersion = -1;

        private UpdateCallback(WmTezSession session) {
            this.session = session;
        }

        public void setResponse(LlapPluginProtocolProtos.UpdateQueryResponseProto response) {
            int nextUpdate = this.session.setSentGuaranteed();
            if (nextUpdate >= 0) {
                LOG.info("Sending a new update " + nextUpdate + " to " + String.valueOf(this.session) + " in the response");
                GuaranteedTasksAllocator.this.updateSessionAsync(this.session, nextUpdate);
            }
        }

        public void indicateError(Throwable t) {
            LOG.error("Failed to update guaranteed tasks count for the session " + String.valueOf(this.session), t);
            boolean isOkToFail = this.session.setFailedToSendGuaranteed();
            if (isOkToFail) {
                return;
            }
            try {
                this.session.handleUpdateError(this.endpointVersion);
            }
            catch (Exception e) {
                LOG.error("Failed to kill the session " + String.valueOf(this.session));
            }
        }

        @Override
        public void setNodeInfo(AmPluginNode.AmPluginInfo info, int version) {
            this.endpointVersion = version;
        }
    }
}

