/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.storage.set.location;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableOperation;
import org.apache.hadoop.hive.ql.ddl.table.storage.set.location.AlterTableSetLocationDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableSetLocationOperation
extends AbstractAlterTableOperation<AlterTableSetLocationDesc> {
    public AlterTableSetLocationOperation(DDLOperationContext context, AlterTableSetLocationDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Table table, Partition partition) throws HiveException {
        StorageDescriptor sd = this.getStorageDescriptor(table, partition);
        String newLocation = ((AlterTableSetLocationDesc)this.desc).getLocation();
        try {
            URI locUri = new URI(newLocation);
            if (!new Path(locUri).isAbsolute()) {
                throw new HiveException(ErrorMsg.BAD_LOCATION_VALUE, new String[]{newLocation});
            }
            sd.setLocation(newLocation);
        }
        catch (URISyntaxException e) {
            throw new HiveException((Throwable)e);
        }
        this.environmentContext.getProperties().remove("DO_NOT_UPDATE_STATS");
    }
}

