/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;

public abstract class DDLDescWithTableProperties
implements DDLDesc {
    protected List<String> partColNames;
    protected Map<String, String> tblProps;
    private List<FieldSchema> cols;
    private List<FieldSchema> partCols;
    private String inputFormat;
    private String outputFormat;
    private String location;
    private String serde;
    private String storageHandler;
    private Map<String, String> serdeProps;
    private String comment;
    private boolean ifNotExists;
    private Long initialWriteId;
    private transient FileSinkDesc writer;
    protected boolean isTemporary = false;
    protected boolean isMaterialization = false;
    protected String ownerName = null;

    protected DDLDescWithTableProperties() {
    }

    protected DDLDescWithTableProperties(List<FieldSchema> cols, List<FieldSchema> partCols, String comment, String inputFormat, String outputFormat, String location, String serde, String storageHandler, Map<String, String> serdeProps, Map<String, String> tblProps, boolean ifNotExists) {
        if (cols != null) {
            this.cols = new ArrayList<FieldSchema>(cols);
        }
        this.partCols = partCols;
        this.comment = comment;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.location = location;
        this.serde = serde;
        this.storageHandler = storageHandler;
        this.serdeProps = serdeProps;
        this.tblProps = tblProps;
        this.ifNotExists = ifNotExists;
    }

    public abstract TableName getFullTableName();

    @Explain(displayName="columns")
    public List<String> getColsString() {
        return Utilities.getFieldSchemaString(this.getCols());
    }

    public List<FieldSchema> getCols() {
        return this.cols;
    }

    public void setCols(List<FieldSchema> cols) {
        this.cols = cols;
    }

    @Explain(displayName="partition columns")
    public List<String> getPartColsString() {
        return Utilities.getFieldSchemaString(this.partCols);
    }

    public List<FieldSchema> getPartCols() {
        return this.partCols;
    }

    public void setPartCols(List<FieldSchema> partCols) {
        this.partCols = partCols;
    }

    @Explain(displayName="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Explain(displayName="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Explain(displayName="input format")
    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Explain(displayName="output format")
    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    @Explain(displayName="storage handler")
    public String getStorageHandler() {
        return this.storageHandler;
    }

    public void setStorageHandler(String storageHandler) {
        this.storageHandler = storageHandler;
    }

    @Explain(displayName="serde name")
    public String getSerde() {
        return this.serde;
    }

    public void setSerde(String serde) {
        this.serde = serde;
    }

    @Explain(displayName="serde properties")
    public Map<String, String> getSerdeProps() {
        return this.serdeProps;
    }

    public void setSerdeProps(Map<String, String> serdeProps) {
        this.serdeProps = serdeProps;
    }

    public void setInitialWriteId(Long writeId) {
        this.initialWriteId = writeId;
    }

    public Long getInitialWriteId() {
        return this.initialWriteId;
    }

    @Explain(displayName="table properties")
    public Map<String, String> getTblPropsExplain() {
        return PlanUtils.getPropertiesForExplain(this.tblProps, "created_with_ctas", "bucketing_version");
    }

    public Map<String, String> getTblProps() {
        return this.tblProps;
    }

    public void setTblProps(Map<String, String> tblProps) {
        this.tblProps = tblProps;
    }

    @Explain(displayName="if not exists", displayOnlyOnTrue=true)
    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public FileSinkDesc getAndUnsetWriter() {
        FileSinkDesc fsd = this.writer;
        this.writer = null;
        return fsd;
    }

    public List<String> getPartColNames() {
        return this.partColNames;
    }

    public void setPartColNames(List<String> partColNames) {
        this.partColNames = partColNames;
    }

    public void setWriter(FileSinkDesc writer) {
        this.writer = writer;
    }

    @Explain(displayName="isTemporary", displayOnlyOnTrue=true)
    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Explain(displayName="isMaterialization", displayOnlyOnTrue=true)
    public boolean isMaterialization() {
        return this.isMaterialization;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }
}

