/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.RemoveTxnsFromMinHistoryLevelCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.commands.RemoveWriteIdsFromMinHistoryCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.UpdataDatabasePropFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetDatabaseIdHandler;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.UncategorizedSQLException;

public class AbortTxnsFunction
implements TransactionalFunction<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(AbortTxnsFunction.class);
    private final List<Long> txnids;
    private final boolean checkHeartbeat;
    private final boolean skipCount;
    private final boolean isReplReplayed;
    private final TxnErrorMsg txnErrorMsg;

    public AbortTxnsFunction(List<Long> txnids, boolean checkHeartbeat, boolean skipCount, boolean isReplReplayed, TxnErrorMsg txnErrorMsg) {
        this.txnids = txnids;
        this.checkHeartbeat = checkHeartbeat;
        this.skipCount = skipCount;
        this.isReplReplayed = isReplReplayed;
        this.txnErrorMsg = txnErrorMsg;
    }

    @Override
    public Integer execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        if (this.txnids.isEmpty()) {
            return 0;
        }
        Configuration conf = jdbcResource.getConf();
        Collections.sort(this.txnids);
        LOG.debug("Aborting {} transaction(s) {} due to {}", new Object[]{this.txnids.size(), this.txnids, this.txnErrorMsg});
        int maxBatchSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.JDBC_MAX_BATCH_SIZE);
        jdbcResource.execute(new RemoveTxnsFromMinHistoryLevelCommand(this.txnids));
        jdbcResource.execute(new RemoveWriteIdsFromMinHistoryCommand(this.txnids));
        Connection dbConn = jdbcResource.getConnection();
        try {
            DatabaseProduct dbProduct = jdbcResource.getDatabaseProduct();
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("UPDATE \"TXNS\" SET \"TXN_STATE\" = ").append((Object)TxnStatus.ABORTED).append(" , \"TXN_META_INFO\" = ").append(this.txnErrorMsg.toSqlString()).append(" WHERE \"TXN_STATE\" = ").append((Object)TxnStatus.OPEN).append(" AND ");
            if (this.checkHeartbeat) {
                suffix.append(" AND \"TXN_LAST_HEARTBEAT\" < ").append(TxnUtils.getEpochFn(dbProduct)).append("-").append(MetastoreConf.getTimeVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
            }
            TxnUtils.buildQueryWithINClause(conf, queries, prefix, suffix, this.txnids, "\"TXN_ID\"", true, false);
            int numUpdateQueries = queries.size();
            prefix.setLength(0);
            suffix.setLength(0);
            prefix.append("DELETE FROM \"HIVE_LOCKS\" WHERE ");
            TxnUtils.buildQueryWithINClause(conf, queries, prefix, suffix, this.txnids, "\"HL_TXNID\"", false, false);
            prefix.setLength(0);
            suffix.setLength(0);
            prefix.append("DELETE FROM \"MATERIALIZATION_REBUILD_LOCKS\" WHERE ");
            TxnUtils.buildQueryWithINClause(conf, queries, prefix, suffix, this.txnids, "\"MRL_TXN_ID\"", false, false);
            if (!this.isReplReplayed) {
                for (String database : this.getDbNamesForReplayedTxns(jdbcResource, dbConn, this.txnids)) {
                    this.markDbAsReplIncompatible(jdbcResource, database);
                }
                prefix.setLength(0);
                suffix.setLength(0);
                prefix.append("DELETE FROM \"REPL_TXN_MAP\" WHERE ");
                TxnUtils.buildQueryWithINClause(conf, queries, prefix, suffix, this.txnids, "\"RTM_TARGET_TXN_ID\"", false, false);
            }
            int numAborted = 0;
            try (Statement stmt = dbConn.createStatement();){
                if (this.skipCount) {
                    TxnUtils.executeQueriesInBatchNoCount(dbProduct, stmt, queries, maxBatchSize);
                } else {
                    List<Integer> affectedRowsByQuery = TxnUtils.executeQueriesInBatch(stmt, queries, maxBatchSize);
                    numAborted = this.getUpdateCount(numUpdateQueries, affectedRowsByQuery);
                }
            }
            if (MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) {
                Metrics.getOrCreateCounter("total_num_aborted_transactions").inc((long)this.txnids.size());
            }
            LOG.warn("Aborted {} transaction(s) {} due to {}", new Object[]{this.txnids.size(), this.txnids, this.txnErrorMsg});
            return numAborted;
        }
        catch (SQLException e) {
            throw new UncategorizedSQLException(null, null, e);
        }
    }

    private Set<String> getDbNamesForReplayedTxns(MultiDataSourceJdbcResource jdbcResource, Connection dbConn, List<Long> targetTxnIds) throws SQLException {
        HashSet<String> dbNames = new HashSet<String>();
        if (targetTxnIds.isEmpty()) {
            return dbNames;
        }
        ArrayList<String> inQueries = new ArrayList<String>();
        StringBuilder prefix = new StringBuilder();
        prefix.append("SELECT \"RTM_REPL_POLICY\" FROM \"REPL_TXN_MAP\" WHERE ");
        TxnUtils.buildQueryWithINClause(jdbcResource.getConf(), inQueries, prefix, new StringBuilder(), targetTxnIds, "\"RTM_TARGET_TXN_ID\"", false, false);
        for (String query : inQueries) {
            LOG.debug("Going to execute select <{}>", (Object)query);
            PreparedStatement pst = jdbcResource.getSqlGenerator().prepareStmtWithParameters(dbConn, query, null);
            try {
                ResultSet rs = pst.executeQuery();
                try {
                    while (rs.next()) {
                        dbNames.add(MetaStoreUtils.getDbNameFromReplPolicy((String)rs.getString(1)));
                    }
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            finally {
                if (pst == null) continue;
                pst.close();
            }
        }
        return dbNames;
    }

    private void markDbAsReplIncompatible(MultiDataSourceJdbcResource jdbcResource, String database) throws SQLException, MetaException {
        try (Statement stmt = jdbcResource.getConnection().createStatement();){
            String catalog = MetaStoreUtils.getDefaultCatalog((Configuration)jdbcResource.getConf());
            String s = jdbcResource.getSqlGenerator().getDbProduct().getPrepareTxnStmt();
            if (s != null) {
                stmt.execute(s);
            }
            long dbId = jdbcResource.execute(new GetDatabaseIdHandler(database, catalog));
            new UpdataDatabasePropFunction(database, dbId, "repl.incompatible", "true").execute(jdbcResource);
        }
    }

    private int getUpdateCount(int numUpdateQueries, List<Integer> affectedRowsByQuery) {
        return affectedRowsByQuery.stream().limit(numUpdateQueries).mapToInt(Integer::intValue).sum();
    }
}

