/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.parquet.hadoop.BadConfigurationException;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class ParquetCodecFactory
extends CodecFactory {
    public ParquetCodecFactory(Configuration configuration, int pageSize) {
        super(configuration, pageSize);
    }

    @Override
    protected CompressionCodec getCodec(CompressionCodecName codecName) {
        String codecClassName = codecName.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        String cacheKey = this.cacheKey(codecName);
        CompressionCodec codec = (CompressionCodec)CODEC_BY_NAME.get(cacheKey);
        if (codec != null) {
            return codec;
        }
        try {
            Class<?> codecClass;
            try {
                codecClass = Class.forName(codecClassName);
            }
            catch (ClassNotFoundException e) {
                codecClass = this.configuration.getClassLoader().loadClass(codecClassName);
            }
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.configuration);
            CODEC_BY_NAME.put(cacheKey, codec);
            return codec;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("Class " + codecClassName + " was not found", e);
        }
    }

    private String cacheKey(CompressionCodecName codecName) {
        String level = null;
        switch (codecName) {
            case GZIP: {
                level = this.configuration.get("zlib.compress.level");
                break;
            }
            case BROTLI: {
                level = this.configuration.get("compression.brotli.quality");
                break;
            }
            case ZSTD: {
                level = this.configuration.get("parquet.compression.codec.zstd.level");
                if (level != null) break;
                level = this.configuration.get("io.compression.codec.zstd.level");
                break;
            }
        }
        String codecClass = codecName.getHadoopCompressionCodecClassName();
        return level == null ? codecClass : codecClass + ":" + level;
    }
}

