/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.io.CacheTag;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.llap.io.api.LlapProxy;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hive.iceberg.org.apache.orc.TypeDescription;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.orc.ExpressionToOrcSearchArgument;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.orc.OrcFile;
import org.apache.orc.impl.OrcTail;
import org.apache.orc.impl.ReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedReadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VectorizedReadUtils.class);

    private VectorizedReadUtils() {
    }

    public static ByteBuffer getSerializedOrcTail(Path path, SyntheticFileId fileId, JobConf job) throws IOException {
        ByteBuffer result = null;
        if (HiveConf.getBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENABLED, (boolean)LlapProxy.isDaemon()) && LlapProxy.getIo() != null) {
            MapWork mapWork = LlapHiveUtils.findMapWork((JobConf)job);
            PartitionDesc partitionDesc = LlapHiveUtils.partitionDescForPath((Path)path, (Map)mapWork.getPathToPartitionInfo());
            CacheTag cacheTag = HiveConf.getBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TRACK_CACHE_USAGE) ? LlapHiveUtils.getDbAndTableNameForMetrics((Path)path, (boolean)true, (PartitionDesc)partitionDesc) : null;
            try {
                return LlapProxy.getIo().getOrcTailFromCache(path, (Configuration)job, cacheTag, (Object)fileId).getSerializedTail();
            }
            catch (IOException ioe) {
                LOG.warn("LLAP is turned on but was unable to get file metadata information through its cache for {}", (Object)path, (Object)ioe);
            }
        }
        if (result == null) {
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)job).useUTCTimestamp(true).filesystem(path.getFileSystem((Configuration)job));
            try (ReaderImpl orcFileReader = (ReaderImpl)org.apache.hadoop.hive.ql.io.orc.OrcFile.createReader((Path)path, (OrcFile.ReaderOptions)readerOptions);){
                ByteBuffer byteBuffer = orcFileReader.getSerializedFileFooter();
                return byteBuffer;
            }
        }
        return result;
    }

    public static OrcTail deserializeToOrcTail(ByteBuffer serializedTail) throws IOException {
        return ReaderImpl.extractFileTail((ByteBuffer)serializedTail);
    }

    public static org.apache.hive.iceberg.org.apache.orc.impl.OrcTail deserializeToShadedOrcTail(ByteBuffer serializedTail) throws IOException {
        return org.apache.hive.iceberg.org.apache.orc.impl.ReaderImpl.extractFileTail(serializedTail);
    }

    public static void handleIcebergProjection(FileScanTask task, JobConf job, TypeDescription fileSchema, Expression residual) throws IOException {
        TypeDescription readOrcSchema;
        PartitionSpec spec = task.spec();
        Schema currentSchema = spec.schema();
        if (ORCSchemaUtil.hasIds(fileSchema)) {
            readOrcSchema = ORCSchemaUtil.buildOrcProjection(currentSchema, fileSchema);
        } else {
            Schema readSchemaForOriginalFile = currentSchema;
            if (spec.isPartitioned()) {
                readSchemaForOriginalFile = currentSchema.select(currentSchema.columns().stream().filter(c -> !spec.identitySourceIds().contains(c.fieldId())).map(c -> c.name()).collect(Collectors.toList()));
            }
            TypeDescription typeWithIds = ORCSchemaUtil.applyNameMapping(fileSchema, MappingUtil.create(currentSchema));
            readOrcSchema = ORCSchemaUtil.buildOrcProjection(readSchemaForOriginalFile, typeWithIds);
        }
        job.set("hive.orc.schema.string", readOrcSchema.toString());
        Expression boundFilter = Binder.bind(currentSchema.asStruct(), residual, false);
        SearchArgument sarg = ExpressionToOrcSearchArgument.convert(boundFilter, readOrcSchema);
        if (sarg != null) {
            job.unset("hive.io.filter.expr.serialized");
            job.unset("sarg.pushdown");
            job.set("sarg.pushdown", ConvertAstToSearchArg.sargToKryo((SearchArgument)sarg));
        }
    }
}

