/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.util.Arrays;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;

public class IcebergFixedObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements BinaryObjectInspector,
WriteObjectInspector {
    private static final IcebergFixedObjectInspector INSTANCE = new IcebergFixedObjectInspector();

    public static IcebergFixedObjectInspector get() {
        return INSTANCE;
    }

    private IcebergFixedObjectInspector() {
        super(TypeInfoFactory.binaryTypeInfo);
    }

    public byte[] getPrimitiveJavaObject(Object o) {
        return (byte[])o;
    }

    public BytesWritable getPrimitiveWritableObject(Object o) {
        return o == null ? null : new BytesWritable(this.getPrimitiveJavaObject(o));
    }

    public byte[] convert(Object o) {
        return o == null ? null : (byte[])o;
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            byte[] bytes = (byte[])o;
            return Arrays.copyOf(bytes, bytes.length);
        }
        return o;
    }
}

