/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.s7.utils;

import java.util.HashMap;
import java.util.Map;

public enum S7DiagnosticEventId {
    EVENTID_0x113A(4410, "Start request for cyclic interrupt OB with special handling (S7-300 only)"),
    EVENTID_0x1155(4437, "Status alarm for PROFIBUS DP"),
    EVENTID_0x1156(4438, "Update interrupt for PROFIBUS DP"),
    EVENTID_0x1157(4439, "Manufacturer interrupt for PROFIBUS DP"),
    EVENTID_0x1158(4440, "Status interrupt for PROFINET IO"),
    EVENTID_0x1159(4441, "Update interrupt for PROFINET IO"),
    EVENTID_0x115A(4442, "Manufacturer interrupt for PROFINET IO"),
    EVENTID_0x115B(4443, "IO: Profile-specific interrupt"),
    EVENTID_0x116A(4458, "Technology synchronization interrupt"),
    EVENTID_0x1381(4993, "Request for manual warm restart"),
    EVENTID_0x1382(4994, "Request for automatic warm restart"),
    EVENTID_0x1383(4995, "Request for manual hot restart"),
    EVENTID_0x1384(4996, "Request for automatic hot restart"),
    EVENTID_0x1385(4997, "Request for manual cold restart"),
    EVENTID_0x1386(4998, "Request for automatic cold restart"),
    EVENTID_0x1387(4999, "Master CPU: request for manual cold restart"),
    EVENTID_0x1388(5000, "Master CPU: request for automatic cold restart"),
    EVENTID_0x138A(5002, "Master CPU: request for manual warm restart"),
    EVENTID_0x138B(5003, "Master CPU: request for automatic warm restart"),
    EVENTID_0x138C(5004, "Standby CPU: request for manual hot restart"),
    EVENTID_0x138D(5005, "Standby CPU: request for automatic hot restart"),
    EVENTID_0x2521(9505, "BCD conversion error"),
    EVENTID_0x2522(9506, "Area length error when reading"),
    EVENTID_0x2523(9507, "Area length error when writing"),
    EVENTID_0x2524(9508, "Area error when reading"),
    EVENTID_0x2525(9509, "Area error when writing"),
    EVENTID_0x2526(9510, "Timer number error"),
    EVENTID_0x2527(9511, "Counter number error"),
    EVENTID_0x2528(9512, "Alignment error when reading"),
    EVENTID_0x2529(9513, "Alignment error when writing"),
    EVENTID_0x2530(9520, "Write error when accessing the DB"),
    EVENTID_0x2531(9521, "Write error when accessing the DI"),
    EVENTID_0x2532(9522, "Block number error when opening a DB"),
    EVENTID_0x2533(9523, "Block number error when opening a DI"),
    EVENTID_0x2534(9524, "Block number error when calling an FC"),
    EVENTID_0x2535(9525, "Block number error when calling an FB"),
    EVENTID_0x253A(9530, "DB not loaded"),
    EVENTID_0x253C(9532, "FC not loaded"),
    EVENTID_0x253D(9533, "SFC not loaded"),
    EVENTID_0x253E(9534, "FB not loaded"),
    EVENTID_0x253F(9535, "SFB not loaded"),
    EVENTID_0x2942(10562, "I/O access error, reading"),
    EVENTID_0x2943(10563, "I/O access error, writing"),
    EVENTID_0x3501(13569, "Cycle time exceeded"),
    EVENTID_0x3502(13570, "User interface (OB or FRB) request error"),
    EVENTID_0x3503(13571, "Delay too long processing a priority class"),
    EVENTID_0x3505(13573, "Time-of-day interrupt(s) skipped due to new clock setting"),
    EVENTID_0x3506(13574, "Time-of-day interrupt(s) skipped when changing to RUN after HOLD"),
    EVENTID_0x3507(13575, "Multiple OB request errors caused internal buffer overflow"),
    EVENTID_0x3508(13576, "Synchronous cycle interrupt-timing error"),
    EVENTID_0x3509(13577, "Interrupt loss due to excess interrupt load"),
    EVENTID_0x350A(13578, "Resume RUN mode after CiR"),
    EVENTID_0x350B(13579, "Technology synchronization interrupt - timing error"),
    EVENTID_0x3571(13681, "Nesting depth too high in nesting levels"),
    EVENTID_0x3572(13682, "Nesting depth for Master Control Relays too high"),
    EVENTID_0x3573(13683, "Nesting depth too high after synchronous errors"),
    EVENTID_0x3574(13684, "Nesting depth for block calls (U stack) too high"),
    EVENTID_0x3575(13685, "Nesting depth for block calls (B stack) too high"),
    EVENTID_0x3576(13686, "Local data allocation error"),
    EVENTID_0x3578(13688, "Unknown instruction"),
    EVENTID_0x357A(13690, "Jump instruction to target outside of the block"),
    EVENTID_0x3582(13698, "Memory error detected and corrected by operating system"),
    EVENTID_0x3583(13699, "Accumulation of detected and corrected memo errors"),
    EVENTID_0x3585(13701, "Error in the PC operating system (only for LC RTX)"),
    EVENTID_0x3587(13703, "Multi-bit memory error detected and corrected"),
    EVENTID_0x35A1(13729, "User interface (OB or FRB) not found"),
    EVENTID_0x35A2(13730, "OB not loaded (started by SFC or operating system due to configuration)"),
    EVENTID_0x35A3(13731, "Error when operating system accesses a block"),
    EVENTID_0x35A4(13732, "PROFInet Interface DB cannot be addressed"),
    EVENTID_0x35D2(13778, "Diagnostic entries cannot be sent at present"),
    EVENTID_0x35D3(13779, "Synchronization frames cannot be sent"),
    EVENTID_0x35D4(13780, "Illegal time jump resulting from synchronization"),
    EVENTID_0x35D5(13781, "Error adopting the synchronization time"),
    EVENTID_0x35E1(13793, "Incorrect frame ID in GD"),
    EVENTID_0x35E2(13794, "GD packet status cannot be entered in DB"),
    EVENTID_0x35E3(13795, "Frame length error in GD"),
    EVENTID_0x35E4(13796, "Illegal GD packet number received"),
    EVENTID_0x35E5(13797, "Error accessing DB in communication SFBs for configured S7 connections"),
    EVENTID_0x35E6(13798, "GD total status cannot be entered in DB"),
    EVENTID_0x3821(14369, "BATTF: failure on at least one backup battery of the central rack, problem eliminated"),
    EVENTID_0x3822(14370, "BAF: failure of backup voltage on central rack, problem eliminated"),
    EVENTID_0x3823(14371, "24 volt supply failure on central rack, problem eliminated"),
    EVENTID_0x3825(14373, "BATTF: failure on at least one backup battery of the redundant central rack, problem eliminated"),
    EVENTID_0x3826(14374, "BAF: failure of backup voltage on redundant central rack, problem eliminated"),
    EVENTID_0x3827(14375, "24 volt supply failure on redundant central rack, problem eliminated"),
    EVENTID_0x3831(14385, "BATTF: failure of at least one backup battery of the expansion rack, problem eliminated"),
    EVENTID_0x3832(14386, "BAF: failure of backup voltage on expansion rack, problem eliminated"),
    EVENTID_0x3833(14387, "24 volt supply failure on at least one expansion rack, problem eliminated"),
    EVENTID_0x3842(14402, "Module OK"),
    EVENTID_0x3854(14420, "PROFINET IO interface submodule/submodule and matches the configured interface submodule/submodule"),
    EVENTID_0x3855(14421, "PROFINET IO interface submodule/submodule inserted, but does not match the configured interface submodule/submodule"),
    EVENTID_0x3856(14422, "PROFINET IO interface submodule/submodule inserted, but error in module parameter assignment"),
    EVENTID_0x3858(14424, "PROFINET IO interface submodule access error corrected"),
    EVENTID_0x3861(14433, "Module/interface module inserted, module type OK"),
    EVENTID_0x3863(14435, "Module/interface module plugged in, but wrong module type"),
    EVENTID_0x3864(14436, "Module/interface module plugged in, but causing problem (type ID unreadable)"),
    EVENTID_0x3865(14437, "Module plugged in, but error in module parameter assignment"),
    EVENTID_0x3866(14438, "Module can be addressed again, load voltage error removed"),
    EVENTID_0x3881(14465, "Interface error leaving state"),
    EVENTID_0x3884(14468, "Interface module plugged in"),
    EVENTID_0x38B3(14515, "I/O access error when updating the process image input table"),
    EVENTID_0x38B4(14516, "I/O access error when transferring the process image to the output modules"),
    EVENTID_0x38C1(14529, "Expansion rack operational again (1 to 21), leaving state"),
    EVENTID_0x38C2(14530, "Expansion rack operational again but mismatch between setpoint and actual configuration"),
    EVENTID_0x38C4(14532, "Distributed I/Os: station failure, leaving state"),
    EVENTID_0x38C5(14533, "Distributed I/Os: station fault, leaving state"),
    EVENTID_0x38C6(14534, "Expansion rack operational again, but error(s) in module parameter assignment"),
    EVENTID_0x38C7(14535, "DP: station operational again, but error(s) in module parameter assignment"),
    EVENTID_0x38C8(14536, "DP: station operational again, but mismatch between setpoint and actual configuration"),
    EVENTID_0x38CB(14539, "PROFINET IO station operational again"),
    EVENTID_0x38CC(14540, "PROFINET IO station error corrected"),
    EVENTID_0x3921(14625, "BATTF: failure on at least one backup battery of the central rack"),
    EVENTID_0x3922(14626, "BAF: failure of backup voltage on central rack"),
    EVENTID_0x3923(14627, "24 volt supply failure on central rack"),
    EVENTID_0x3925(14629, "BATTF: failure on at least one backup battery of the redundant central rack"),
    EVENTID_0x3926(14630, "BAF: failure of backup voltage on redundant central rack"),
    EVENTID_0x3927(14631, "24 volt supply failure on redundant central rack"),
    EVENTID_0x3931(14641, "BATTF: failure of at least one backup battery of the expansion rack"),
    EVENTID_0x3932(14642, "BAF: failure of backup voltage on expansion rack"),
    EVENTID_0x3933(14643, "24 volt supply failure on at least one expansion rack"),
    EVENTID_0x3942(14658, "Module error"),
    EVENTID_0x3951(14673, "PROFINET IO submodule removed"),
    EVENTID_0x3954(14676, "PROFINET IO interface submodule/submodule removed"),
    EVENTID_0x3961(14689, "Module/interface module removed, cannot be addressed"),
    EVENTID_0x3966(14694, "Module cannot be addressed, load voltage error"),
    EVENTID_0x3968(14696, "Module reconfiguration has ended with error"),
    EVENTID_0x3981(14721, "Interface error entering state"),
    EVENTID_0x3984(14724, "Interface module removed"),
    EVENTID_0x3986(14726, "Performance of an H-Sync link negatively affected"),
    EVENTID_0x39B1(14769, "I/O access error when updating the process image input table"),
    EVENTID_0x39B2(14770, "I/O access error when transferring the process image to the output modules"),
    EVENTID_0x39B3(14771, "I/O access error when updating the process image input table"),
    EVENTID_0x39B4(14772, "I/O access error when transferring the process image to the output modules"),
    EVENTID_0x39C1(14785, "Expansion rack failure (1 to 21), entering state"),
    EVENTID_0x39C3(14787, "Distributed I/Os: master system failure entering state"),
    EVENTID_0x39C4(14788, "Distributed I/Os: station failure, entering state"),
    EVENTID_0x39C5(14789, "Distributed I/Os: station fault, entering state"),
    EVENTID_0x39CA(14794, "PROFINET IO system failure"),
    EVENTID_0x39CB(14795, "PROFINET IO station failure"),
    EVENTID_0x39CC(14796, "PROFINET IO station error"),
    EVENTID_0x39CD(14797, "PROFINET IO station operational again, but expected configuration does not match actual configuration"),
    EVENTID_0x39CE(14798, "PROFINET IO station operational again, but error(s) in module parameter assignment"),
    EVENTID_0x42F3(17139, "Checksum error detected and corrected by the operating system"),
    EVENTID_0x4300(17152, "Backed-up power on"),
    EVENTID_0x4301(17153, "Mode transition from STOP to STARTUP"),
    EVENTID_0x4302(17154, "Mode transition from STARTUP to RUN"),
    EVENTID_0x4303(17155, "STOP caused by stop switch being activated"),
    EVENTID_0x4304(17156, "STOP caused by PG STOP operation or by SFB 20 STOP"),
    EVENTID_0x4305(17157, "HOLD: breakpoint reached"),
    EVENTID_0x4306(17158, "HOLD: breakpoint exited"),
    EVENTID_0x4307(17159, "Memory reset started by PG operation"),
    EVENTID_0x4308(17160, "Memory reset started by switch setting"),
    EVENTID_0x4309(17161, "Memory reset started automatically (power on not backed up)"),
    EVENTID_0x430A(17162, "HOLD exited, transition to STOP"),
    EVENTID_0x430D(17165, "STOP caused by other CPU in multicomputing"),
    EVENTID_0x430E(17166, "Memory reset executed"),
    EVENTID_0x430F(17167, "STOP on the module due to STOP on a CPU"),
    EVENTID_0x4318(17176, "Start of CiR"),
    EVENTID_0x4319(17177, "CiR completed"),
    EVENTID_0x4357(17239, "Module watchdog started"),
    EVENTID_0x4358(17240, "All modules are ready for operation"),
    EVENTID_0x43B0(17328, "Firmware update was successful"),
    EVENTID_0x43B4(17332, "Error in firmware fuse"),
    EVENTID_0x43B6(17334, "Firmware updates canceled by redundant modules"),
    EVENTID_0x43D3(17363, "STOP on standby CPU"),
    EVENTID_0x43DC(17372, "Abort during link-up with switchover"),
    EVENTID_0x43DE(17374, "Updating aborted due to monitoring time being exceeded during the n-th attempt, new update attempt initiated"),
    EVENTID_0x43DF(17375, "Updating aborted for final time due to monitoring time being exceeded after completing the maximum amount of attempts. User intervention required"),
    EVENTID_0x43E0(17376, "Change from solo mode after link-up"),
    EVENTID_0x43E1(17377, "Change from link-up after updating"),
    EVENTID_0x43E2(17378, "Change from updating to redundant mode"),
    EVENTID_0x43E3(17379, "Master CPU: change from redundant mode to solo mode"),
    EVENTID_0x43E4(17380, "Standby CPU: change from redundant mode after error-search mode"),
    EVENTID_0x43E5(17381, "Standby CPU: change from error-search mode after link-up or STOP"),
    EVENTID_0x43E6(17382, "Link-up aborted on the standby CPU"),
    EVENTID_0x43E7(17383, "Updating aborted on the standby CPU"),
    EVENTID_0x43E8(17384, "Standby CPU: change from link-up after startup"),
    EVENTID_0x43E9(17385, "Standby CPU: change from startup after updating"),
    EVENTID_0x43F1(17393, "Reserve-master switchover"),
    EVENTID_0x43F2(17394, "Coupling of incompatible H-CPUs blocked by system program"),
    EVENTID_0x4510(17680, "STOP violation of the CPU's data range"),
    EVENTID_0x4520(17696, "DEFECTIVE: STOP not possible"),
    EVENTID_0x4521(17697, "DEFECTIVE: failure of instruction processing processor"),
    EVENTID_0x4522(17698, "DEFECTIVE: failure of clock chip"),
    EVENTID_0x4523(17699, "DEFECTIVE: failure of clock pulse generator"),
    EVENTID_0x4524(17700, "DEFECTIVE: failure of timer update function"),
    EVENTID_0x4525(17701, "DEFECTIVE: failure of multicomputing synchronization"),
    EVENTID_0x4527(17703, "DEFECTIVE: failure of I/O access monitoring"),
    EVENTID_0x4528(17704, "DEFECTIVE: failure of scan time monitoring"),
    EVENTID_0x4530(17712, "DEFECTIVE: memory test error in internal memory"),
    EVENTID_0x4532(17714, "DEFECTIVE: failure of core resources"),
    EVENTID_0x4536(17718, "DEFECTIVE: switch defective"),
    EVENTID_0x4540(17728, "STOP: Memory expansion of the internal work memory has gaps. First memory expansion too small or missing"),
    EVENTID_0x4541(17729, "STOP caused by priority class system"),
    EVENTID_0x4542(17730, "STOP caused by object management system"),
    EVENTID_0x4543(17731, "STOP caused by test functions"),
    EVENTID_0x4544(17732, "STOP caused by diagnostic system"),
    EVENTID_0x4545(17733, "STOP caused by communication system"),
    EVENTID_0x4546(17734, "STOP caused by CPU memory management"),
    EVENTID_0x4547(17735, "STOP caused by process image management"),
    EVENTID_0x4548(17736, "STOP caused by I/O management"),
    EVENTID_0x454A(17738, "STOP caused by configuration: an OB deselected with STEP 7 was being loaded into the CPU during STARTUP"),
    EVENTID_0x4550(17744, "DEFECTIVE: internal system error"),
    EVENTID_0x4555(17749, "No restart possible, monitoring time elapsed"),
    EVENTID_0x4556(17750, "STOP: memory reset request from communication system / due to data inconsistency"),
    EVENTID_0x4562(17762, "STOP caused by programming error (OB not loaded or not possible)"),
    EVENTID_0x4563(17763, "STOP caused by I/O access error (OB not loaded or not possible)"),
    EVENTID_0x4567(17767, "STOP caused by H event"),
    EVENTID_0x4568(17768, "STOP caused by time error (OB not loaded or not possible)"),
    EVENTID_0x456A(17770, "STOP caused by diagnostic interrupt (OB not loaded or not possible)"),
    EVENTID_0x456B(17771, "STOP caused by removing/inserting module (OB not loaded or not possible)"),
    EVENTID_0x456C(17772, "STOP caused by CPU hardware error (OB not loaded or not possible, or no FRB)"),
    EVENTID_0x456D(17773, "STOP caused by program sequence error (OB not loaded or not possible)"),
    EVENTID_0x456E(17774, "STOP caused by communication error (OB not loaded or not possible)"),
    EVENTID_0x456F(17775, "STOP caused by rack failure OB (OB not loaded or not possible)"),
    EVENTID_0x4570(17776, "STOP caused by process interrupt (OB not loaded or not possible)"),
    EVENTID_0x4571(17777, "STOP caused by nesting stack error"),
    EVENTID_0x4572(17778, "STOP caused by master control relay stack error"),
    EVENTID_0x4573(17779, "STOP caused by exceeding the nesting depth for synchronous errors"),
    EVENTID_0x4574(17780, "STOP caused by exceeding interrupt stack nesting depth in the priority class stack"),
    EVENTID_0x4575(17781, "STOP caused by exceeding block stack nesting depth in the priority class stack"),
    EVENTID_0x4576(17782, "STOP caused by error when allocating the local data"),
    EVENTID_0x4578(17784, "STOP caused by unknown opcode"),
    EVENTID_0x457A(17786, "STOP caused by code length error"),
    EVENTID_0x457B(17787, "STOP caused by DB not being loaded on on-board I/Os"),
    EVENTID_0x457D(17789, "Reset/clear request because the version of the internal interface to the integrated technology was changed"),
    EVENTID_0x457F(17791, "STOP caused by STOP command"),
    EVENTID_0x4580(17792, "STOP: back-up buffer contents inconsistent (no transition to RUN)"),
    EVENTID_0x4590(17808, "STOP caused by overloading the internal functions"),
    EVENTID_0x45D5(17877, "LINK-UP rejected due to mismatched CPU memory configuration of the sub-PLC"),
    EVENTID_0x45D6(17878, "LINK-UP rejected due to mismatched system program of the sub-PLC"),
    EVENTID_0x45D8(17880, "DEFECTIVE: hardware fault detected due to other error"),
    EVENTID_0x45D9(17881, "STOP due to SYNC module error"),
    EVENTID_0x45DA(17882, "STOP due to synchronization error between H CPUs"),
    EVENTID_0x45DD(17885, "LINK-UP rejected due to running test or other online functions"),
    EVENTID_0x4926(18726, "DEFECTIVE: failure of the watchdog for I/O access"),
    EVENTID_0x4931(18737, "STOP or DEFECTIVE: memory test error in memory submodule"),
    EVENTID_0x4933(18739, "Checksum error"),
    EVENTID_0x4934(18740, "DEFECTIVE: memory not available"),
    EVENTID_0x4935(18741, "DEFECTIVE: cancelled by watchdog/processor exceptions"),
    EVENTID_0x4949(18761, "STOP caused by continuous hardware interrupt"),
    EVENTID_0x494D(18765, "STOP caused by I/O error"),
    EVENTID_0x494E(18766, "STOP caused by power failure"),
    EVENTID_0x494F(18767, "STOP caused by configuration error"),
    EVENTID_0x4959(18777, "One or more modules not ready for operation"),
    EVENTID_0x497C(18812, "STOP caused by integrated technology"),
    EVENTID_0x49A0(18848, "STOP caused by parameter assignment error or non-permissible variation of setpoint and actual extension: Start-up blocked"),
    EVENTID_0x49A1(18849, "STOP caused by parameter assignment error: memory reset request"),
    EVENTID_0x49A2(18850, "STOP caused by error in parameter modification: startup disabled"),
    EVENTID_0x49A3(18851, "STOP caused by error in parameter modification: memory reset request"),
    EVENTID_0x49A4(18852, "STOP: inconsistency in configuration data"),
    EVENTID_0x49A5(18853, "STOP: distributed I/Os: inconsistency in the loaded configuration information"),
    EVENTID_0x49A6(18854, "STOP: distributed I/Os: invalid configuration information"),
    EVENTID_0x49A7(18855, "STOP: distributed I/Os: no configuration information"),
    EVENTID_0x49A8(18856, "STOP: error indicated by the interface module for the distributed I/Os"),
    EVENTID_0x49B1(18865, "Firmware update data incorrect"),
    EVENTID_0x49B2(18866, "Firmware update: hardware version does not match firmware"),
    EVENTID_0x49B3(18867, "Firmware update: module type does not match firmware"),
    EVENTID_0x49D0(18896, "LINK-UP aborted due to violation of coordination rules"),
    EVENTID_0x49D1(18897, "LINK-UP/UPDATE sequence aborted"),
    EVENTID_0x49D2(18898, "Standby CPU changed to STOP due to STOP on the master CPU during link-up"),
    EVENTID_0x49D4(18900, "STOP on a master, since partner CPU is also a master (link-up error)"),
    EVENTID_0x49D7(18903, "LINK-UP rejected due to change in user program or in configuration"),
    EVENTID_0x42F4(17140, "Standby CPU: connection/update via SFC90 is locked in the master CPU"),
    EVENTID_0x530D(21261, "New startup information in the STOP mode"),
    EVENTID_0x510F(20751, "A problem as occurred with WinLC. This problem has caused the CPU to go into STOP mode or has caused a fault in the CPU"),
    EVENTID_0x5311(21265, "Startup despite Not Ready message from module(s)"),
    EVENTID_0x5371(21361, "Distributed I/Os: end of the synchronization with a DP master"),
    EVENTID_0x5380(21376, "Diagnostic buffer entries of interrupt and asynchronous errors disabled"),
    EVENTID_0x5395(21397, "Distributed I/Os: reset of a DP master"),
    EVENTID_0x53A2(21410, "Download of technology firmware successful"),
    EVENTID_0x53A4(21412, "Download of technology DB not successful"),
    EVENTID_0x5445(21573, "Start of System reconfiguration in RUN mode"),
    EVENTID_0x5481(21633, "All licenses for runtime software are complete again"),
    EVENTID_0x5498(21656, "No more inconsistency with DP master systems due to CiR"),
    EVENTID_0x5545(21829, "Start of System reconfiguration in RUN mode"),
    EVENTID_0x5581(21889, "One or several licenses for runtime software are missing"),
    EVENTID_0x558A(21898, "Difference between the MLFB of the configured and inserted CPU"),
    EVENTID_0x558B(21899, "Difference in the firmware version of the configured and inserted CPU"),
    EVENTID_0x5598(21912, "Start of possible inconsistency with DP master systems due to CiR"),
    EVENTID_0x55A5(21925, "Version conflict: internal interface with integrated technology"),
    EVENTID_0x55A6(21926, "The maximum number of technology objects has been exceeded"),
    EVENTID_0x55A7(21927, "A technology DB of this type is already present"),
    EVENTID_0x5879(22649, "Diagnostic message from DP interface: EXTF LED off"),
    EVENTID_0x5960(22880, "Parameter assignment error when switching"),
    EVENTID_0x5961(22881, "Parameter assignment error"),
    EVENTID_0x5962(22882, "Parameter assignment error preventing startup"),
    EVENTID_0x5963(22883, "Parameter assignment error with memory reset request"),
    EVENTID_0x5966(22886, "Parameter assignment error when switching"),
    EVENTID_0x5969(22889, "Parameter assignment error with startup blocked"),
    EVENTID_0x596A(22890, "PROFINET IO: IP address of an IO device already present"),
    EVENTID_0x596B(22891, "IP address of an Ethernet interface already exists"),
    EVENTID_0x596C(22892, "Name of an Ethernet interface already exists"),
    EVENTID_0x596D(22893, "The existing network configuration does not mach the system requirements or configuration"),
    EVENTID_0x5979(22905, "Diagnostic message from DP interface: EXTF LED on"),
    EVENTID_0x597C(22908, "DP Global Control command failed or moved"),
    EVENTID_0x59A0(22944, "The interrupt can not be associated in the CPU"),
    EVENTID_0x59A1(22945, "Configuration error in the integrated technology"),
    EVENTID_0x59A3(22947, "Error when downloading the integrated technology"),
    EVENTID_0x53FF(21503, "Reset to factory setting"),
    EVENTID_0x6316(25366, "Interface error when starting programmable controller"),
    EVENTID_0x6353(25427, "Firmware update: Start of firmware download over the network"),
    EVENTID_0x6390(25488, "Formatting of Micro Memory Card complete"),
    EVENTID_0x6500(25856, "Connection ID exists twice on module"),
    EVENTID_0x6501(25857, "Connection resources inadequate"),
    EVENTID_0x6502(25858, "Error in the connection description"),
    EVENTID_0x6510(25872, "CFB structure error detected in instance DB when evaluating EPROM"),
    EVENTID_0x6514(25876, "GD packet number exists twice on the module"),
    EVENTID_0x6515(25877, "Inconsistent length specifications in GD configuration information"),
    EVENTID_0x6521(25889, "No memory submodule and no internal memory available"),
    EVENTID_0x6522(25890, "Illegal memory submodule: replace submodule and reset memory"),
    EVENTID_0x6523(25891, "Memory reset request due to error accessing submodule"),
    EVENTID_0x6524(25892, "Memory reset request due to error in block header"),
    EVENTID_0x6526(25894, "Memory reset request due to memory replacement"),
    EVENTID_0x6527(25895, "Memory replaced, therefore restart not possible"),
    EVENTID_0x6528(25896, "Object handling function in the STOP/HOLD mode, no restart possible"),
    EVENTID_0x6529(25897, "No startup possible during the load"),
    EVENTID_0x652A(25898, "No startup because block exists twice in user memory user program function"),
    EVENTID_0x652B(25899, "No startup because block is too long for submodule - replace submodule"),
    EVENTID_0x652C(25900, "No startup due to illegal OB on submodule"),
    EVENTID_0x6532(25906, "No startup because illegal configuration information on submodule"),
    EVENTID_0x6533(25907, "Memory reset request because of invalid submodule content"),
    EVENTID_0x6534(25908, "No startup: block exists more than once on submodule"),
    EVENTID_0x6535(25909, "No startup: not enough memory to transfer block from submodule"),
    EVENTID_0x6536(25910, "No startup: submodule contains an illegal block number"),
    EVENTID_0x6537(25911, "No startup: submodule contains a block with an illegal length"),
    EVENTID_0x6538(25912, "Local data or write-protection ID (for DB) of a block illegal for CPU"),
    EVENTID_0x6539(25913, "Illegal command in block (detected by compiler)"),
    EVENTID_0x653A(25914, "Memory reset request because local OB data on submodule too short"),
    EVENTID_0x6543(25923, "No startup: illegal block type"),
    EVENTID_0x6544(25924, "No startup: attribute relevant for processing illegal"),
    EVENTID_0x6545(25925, "Source language illegal"),
    EVENTID_0x6546(25926, "Maximum amount of configuration information reached"),
    EVENTID_0x6547(25927, "Parameter assignment error assigning parameters to modules (not on P bus, cancel download)"),
    EVENTID_0x6548(25928, "Plausibility error during block check"),
    EVENTID_0x6549(25929, "Structure error in block"),
    EVENTID_0x6550(25936, "A block has an error in the CRC"),
    EVENTID_0x6551(25937, "A block has no CRC"),
    EVENTID_0x6253(25171, "Firmware update: End of firmware download over the network"),
    EVENTID_0x6560(25952, "SCAN overflow"),
    EVENTID_0x6805(26629, "Resource problem on configured connections, eliminated"),
    EVENTID_0x6881(26753, "Interface error leaving state"),
    EVENTID_0x6905(26885, "Resource problem on configured connections"),
    EVENTID_0x6981(27009, "Interface error entering state"),
    EVENTID_0x72A2(29346, "Failure of a DP master or a DP master system"),
    EVENTID_0x72A3(29347, "Redundancy restored on the DP slave"),
    EVENTID_0x72DB(29403, "Safety program: safety mode disabled"),
    EVENTID_0x72E0(29408, "Loss of redundancy in communication, problem eliminated"),
    EVENTID_0x7301(29441, "Loss of redundancy (1 of 2) due to failure of a CPU"),
    EVENTID_0x7302(29442, "Loss of redundancy (1 of 2) due to STOP on the standby triggered by user"),
    EVENTID_0x7303(29443, "H system (1 of 2) changed to redundant mode"),
    EVENTID_0x7323(29475, "Discrepancy found in operating system data"),
    EVENTID_0x7331(29489, "Standby-master switchover due to master failure"),
    EVENTID_0x7333(29491, "Standby-master switchover due to system modification during runtime"),
    EVENTID_0x7334(29492, "Standby-master switchover due to communication error at the synchronization module"),
    EVENTID_0x7340(29504, "Synchronization error in user program due to elapsed wait time"),
    EVENTID_0x7341(29505, "Synchronization error in user program due to waiting at different synchronization points"),
    EVENTID_0x7342(29506, "Synchronization error in operating system due to waiting at different synchronization points"),
    EVENTID_0x7343(29507, "Synchronization error in operating system due to elapsed wait time"),
    EVENTID_0x7344(29508, "Synchronization error in operating system due to incorrect data"),
    EVENTID_0x734A(29514, "The \"Re-enable\" job triggered by SFC 90 \"H_CTRL\" was executed"),
    EVENTID_0x73A3(29603, "Loss of redundancy on the DP slave"),
    EVENTID_0x73C1(29633, "Update process canceled"),
    EVENTID_0x73C2(29634, "Updating aborted due to monitoring time being exceeded during the n-th attempt (1 = n = max. possible number of update attempts after abort due to excessive monitoring time)"),
    EVENTID_0x73D8(29656, "Safety mode disabled"),
    EVENTID_0x73DB(29659, "Safety program: safety mode enabled"),
    EVENTID_0x73E0(29664, "Loss of redundancy in communication"),
    EVENTID_0x74DD(29917, "Safety program: Shutdown of a fail-save runtime group disabled"),
    EVENTID_0x74DE(29918, "Safety program: Shutdown of the F program disabled"),
    EVENTID_0x74DF(29919, "Start of F program initialization"),
    EVENTID_0x7520(29984, "Error in RAM comparison"),
    EVENTID_0x7521(29985, "Error in comparison of process image output value"),
    EVENTID_0x7522(29986, "Error in comparison of memory bits, timers, or counters"),
    EVENTID_0x75D1(30161, "Safety program: Internal CPU error"),
    EVENTID_0x75D2(30162, "Safety program error: Cycle time time-out"),
    EVENTID_0x75D6(30166, "Data corrupted in safety program prior to the output to F I/O"),
    EVENTID_0x75D7(30167, "Data corrupted in safety program prior to the output to partner F-CPU"),
    EVENTID_0x75D9(30169, "Invalid REAL number in a DB"),
    EVENTID_0x75DA(30170, "Safety program: Error in safety data format"),
    EVENTID_0x75DC(30172, "Runtime group, internal protocol error"),
    EVENTID_0x75DD(30173, "Safety program: Shutdown of a fail-save runtime group enabled"),
    EVENTID_0x75DE(30174, "Safety program: Shutdown of the F program enabled"),
    EVENTID_0x75DF(30175, "End of F program initialization"),
    EVENTID_0x75E1(30177, "Safety program: Error in FB \"F_PLK\" or \"F_PLK_O\" or \"F_CYC_CO\" or \"F_TEST\" or \"F_TESTC\""),
    EVENTID_0x75E2(30178, "Safety program: Area length error"),
    EVENTID_0x7852(30802, "SYNC module inserted"),
    EVENTID_0x7855(30805, "SYNC module eliminated"),
    EVENTID_0x78D3(30931, "Communication error between PROFIsafe and F I/O"),
    EVENTID_0x78D4(30932, "Error in safety relevant communication between F CPUs"),
    EVENTID_0x78D5(30933, "Error in safety relevant communication between F CPUs"),
    EVENTID_0x78E3(30947, "F-I/O device input channel depassivated"),
    EVENTID_0x78E4(30948, "F-I/O device output channel depassivated"),
    EVENTID_0x78E5(30949, "F-I/O device depassivated"),
    EVENTID_0x7934(31028, "Standby-master switchover due to connection problem at the SYNC module"),
    EVENTID_0x7950(31056, "Synchronization module missing"),
    EVENTID_0x7951(31057, "Change at the SYNC module without Power On"),
    EVENTID_0x7952(31058, "SYNC module removed"),
    EVENTID_0x7953(31059, "Change at the SYNC-module without reset"),
    EVENTID_0x7954(31060, "SYNC module: rack number assigned twice"),
    EVENTID_0x7955(31061, "SYNC module error"),
    EVENTID_0x7956(31062, "Illegal rack number set on SYNC module"),
    EVENTID_0x7960(31072, "Redundant I/O: Time-out of discrepancy time at digital input, error is not yet localized"),
    EVENTID_0x7961(31073, "Redundant I/O, digital input error: Signal change after expiration of the discrepancy time"),
    EVENTID_0x7962(31074, "Redundant I/O: Digital input error"),
    EVENTID_0x796F(31087, "Redundant I/O: The I/O was globally disabled"),
    EVENTID_0x7970(31088, "Redundant I/O: Digital output error"),
    EVENTID_0x7980(31104, "Redundant I/O: Time-out of discrepancy time at analog input"),
    EVENTID_0x7981(31105, "Redundant I/O: Analog input error"),
    EVENTID_0x7990(31120, "Redundant I/O: Analog output error"),
    EVENTID_0x79D3(31187, "Communication error between PROFIsafe and F I/O"),
    EVENTID_0x79D4(31188, "Error in safety relevant communication between F CPUs"),
    EVENTID_0x79D5(31189, "Error in safety relevant communication between F CPUs"),
    EVENTID_0x79E3(31203, "F-I/O device input channel passivated"),
    EVENTID_0x79E4(31204, "F-I/O device output channel passivated"),
    EVENTID_0x79E5(31205, "F-I/O device passivated"),
    EVENTID_0x79E6(31206, "Inconsistent safety program"),
    EVENTID_0x79E7(31207, "Simulation block (F system block) loaded"),
    EVENTID_0x73E8(29672, "Consistency of the safety program verified by testing"),
    EVENTID_0x73E9(29673, "Consistency of the safety program cannot be checked"),
    EVENTID_0x8x00(Short.MIN_VALUE, "Module fault/OK"),
    EVENTID_0x8x01(-32767, "Internal error"),
    EVENTID_0x8x02(-32766, "External error"),
    EVENTID_0x8x03(-32765, "Channel error"),
    EVENTID_0x8x04(-32764, "External error"),
    EVENTID_0x8x05(-32763, "No front connector"),
    EVENTID_0x8x06(-32762, "No parameter assignment"),
    EVENTID_0x8x07(-32761, "Incorrect parameters in module"),
    EVENTID_0x8x30(-32720, "User submodule incorrect/not found"),
    EVENTID_0x8x31(-32719, "Communication problem"),
    EVENTID_0x8x32(-32718, "Operating mode: RUN/STOP (STOP: entering state, RUN: leaving state)"),
    EVENTID_0x8x33(-32717, "Time monitoring responded (watchdog)"),
    EVENTID_0x8x34(-32716, "Internal module power failure"),
    EVENTID_0x8x35(-32715, "BATTF: battery exhausted"),
    EVENTID_0x8x36(-32714, "Total backup failed"),
    EVENTID_0x8x40(-32704, "Expansion rack failed"),
    EVENTID_0x8x41(-32703, "Processor failure"),
    EVENTID_0x8x42(-32702, "EPROM error"),
    EVENTID_0x8x43(-32701, "RAM error"),
    EVENTID_0x8x44(-32700, "ADC/DAC error"),
    EVENTID_0x8x45(-32699, "Fuse blown"),
    EVENTID_0x8x46(-32698, "Hardware interrupt lost"),
    EVENTID_0x8x50(-32688, "Configuration/parameter assignment error. Analog input"),
    EVENTID_0x8x51(-32687, "Common mode error"),
    EVENTID_0x8x52(-32686, "Short circuit to phase"),
    EVENTID_0x8x53(-32685, "Short circuit to ground"),
    EVENTID_0x8x54(-32684, "Wire break"),
    EVENTID_0x8x55(-32683, "Reference channel error"),
    EVENTID_0x8x56(-32682, "Below measuring range"),
    EVENTID_0x8x57(-32681, "Above measuring range"),
    EVENTID_0x8x60(-32672, "Configuration/parameter assignment error. Analog output"),
    EVENTID_0x8x61(-32671, "Common mode error"),
    EVENTID_0x8x62(-32670, "Short circuit to phase"),
    EVENTID_0x8x63(-32669, "Short circuit to ground"),
    EVENTID_0x8x64(-32668, "Wire break"),
    EVENTID_0x8x66(-32666, "No load voltage"),
    EVENTID_0x8x70(-32656, "Configuration/parameter assignment error. Digital input"),
    EVENTID_0x8x71(-32655, "Chassis ground fault"),
    EVENTID_0x8x72(-32654, "Short circuit to phase (sensor)"),
    EVENTID_0x8x73(-32653, "Short circuit to ground (sensor)"),
    EVENTID_0x8x74(-32652, "Wire break"),
    EVENTID_0x8x75(-32651, "No sensor power supply"),
    EVENTID_0x8x80(-32640, "Configuration/parameter assignment error. Digital output"),
    EVENTID_0x8x81(-32639, "Chassis ground fault"),
    EVENTID_0x8x82(-32638, "Short circuit to phase"),
    EVENTID_0x8x83(-32637, "Short circuit to ground"),
    EVENTID_0x8x84(-32636, "Wire break"),
    EVENTID_0x8x85(-32635, "Fuse tripped"),
    EVENTID_0x8x86(-32634, "No load voltage"),
    EVENTID_0x8x87(-32633, "Excess temperature"),
    EVENTID_0x8xB0(-32592, "Counter module, signal A faulty. FM"),
    EVENTID_0x8xB1(-32591, "Counter module, signal B faulty"),
    EVENTID_0x8xB2(-32590, "Counter module, signal N faulty"),
    EVENTID_0x8xB3(-32589, "Counter module, incorrect value passed between the channels"),
    EVENTID_0x8xB4(-32588, "Counter module, 5.2 V sensor supply faulty"),
    EVENTID_0x8xB5(-32587, "Counter module, 24 V sensor supply faulty"),
    EVENTID_0x9001(-28671, "Automatic mode"),
    EVENTID_0x9101(-28415, "Manual mode"),
    EVENTID_0x9x02(-28670, "OPEN/CLOSED, ON/OFF"),
    EVENTID_0x9x03(-28669, "Manual command enable"),
    EVENTID_0x9x04(-28668, "Unit protective command (OPEN/CLOSED)"),
    EVENTID_0x9x05(-28667, "Process enable"),
    EVENTID_0x9x06(-28666, "System protection command"),
    EVENTID_0x9x07(-28665, "Process value monitoring responded"),
    EVENTID_0x9x08(-28664, "Manipulated variable monitoring responded"),
    EVENTID_0x9x09(-28663, "System deviation greater than permitted"),
    EVENTID_0x9x0A(-28662, "Limit position error"),
    EVENTID_0x9x0B(-28661, "Runtime error"),
    EVENTID_0x9x0C(-28660, "Command execution error (sequencer)"),
    EVENTID_0x9x0D(-28659, "Operating status running > OPEN"),
    EVENTID_0x9x0E(-28658, "Operating status running > CLOSED"),
    EVENTID_0x9x0F(-28657, "Command blocking"),
    EVENTID_0x9x11(-28655, "Process status OPEN/ON"),
    EVENTID_0x9x12(-28654, "Process status CLOSED/OFF"),
    EVENTID_0x9x13(-28653, "Process status intermediate position"),
    EVENTID_0x9x14(-28652, "Process status ON via AUTO"),
    EVENTID_0x9x15(-28651, "Process status ON via manual"),
    EVENTID_0x9x16(-28650, "Process status ON via protective command"),
    EVENTID_0x9x17(-28649, "Process status OFF via AUTO"),
    EVENTID_0x9x18(-28648, "Process status OFF via manual"),
    EVENTID_0x9x19(-28647, "Process status OFF via protective command"),
    EVENTID_0x9x21(-28639, "Function error on approach"),
    EVENTID_0x9x22(-28638, "Function error on leaving"),
    EVENTID_0x9x31(-28623, "Actuator (DE/WE) limit position OPEN"),
    EVENTID_0x9x32(-28622, "Actuator (DE/WE) limit position not OPEN"),
    EVENTID_0x9x33(-28621, "Actuator (DE/WE) limit position CLOSED"),
    EVENTID_0x9x34(-28620, "Actuator (DE/WE) limit position not CLOSED"),
    EVENTID_0x9x41(-28607, "Illegal status, tolerance time elapsed"),
    EVENTID_0x9x42(-28606, "Illegal status, tolerance time not elapsed"),
    EVENTID_0x9x43(-28605, "Interlock error, tolerance time = 0"),
    EVENTID_0x9x44(-28604, "Interlock error, tolerance time > 0"),
    EVENTID_0x9x45(-28603, "No reaction"),
    EVENTID_0x9x46(-28602, "Final status exited illegally, tolerance time = 0"),
    EVENTID_0x9x47(-28601, "Final status exited illegally, tolerance time > 0"),
    EVENTID_0x9x50(-28592, "Upper limit of signal range USR"),
    EVENTID_0x9x51(-28591, "Upper limit of measuring range UMR"),
    EVENTID_0x9x52(-28590, "Lower limit of signal range LSR"),
    EVENTID_0x9x53(-28589, "Lower limit of measuring range LMR"),
    EVENTID_0x9x54(-28588, "Upper alarm limit UAL"),
    EVENTID_0x9x55(-28587, "Upper warning limit UWL"),
    EVENTID_0x9x56(-28586, "Upper tolerance limit UTL"),
    EVENTID_0x9x57(-28585, "Lower tolerance limit LTL"),
    EVENTID_0x9x58(-28584, "Lower warning limit LWL"),
    EVENTID_0x9x59(-28583, "Lower alarm limit LAL"),
    EVENTID_0x9x60(-28576, "GRAPH7 step entering/leaving"),
    EVENTID_0x9x61(-28575, "GRAPH7 interlock error"),
    EVENTID_0x9x62(-28574, "GRAPH7 execution error"),
    EVENTID_0x9x63(-28573, "GRAPH7 error noted"),
    EVENTID_0x9x64(-28572, "GRAPH7 error acknowledged"),
    EVENTID_0x9x70(-28560, "Trend exceeded in positive direction"),
    EVENTID_0x9x71(-28559, "Trend exceeded in negative direction"),
    EVENTID_0x9x72(-28558, "No reaction"),
    EVENTID_0x9x73(-28557, "Final state exited illegally"),
    EVENTID_0x9x80(-28544, "Limit value exceeded, tolerance time = 0"),
    EVENTID_0x9x81(-28543, "Limit value exceeded, tolerance time > 0"),
    EVENTID_0x9x82(-28542, "Below limit value, tolerance time = 0"),
    EVENTID_0x9x83(-28541, "Below limit value, tolerance time > 0"),
    EVENTID_0x9x84(-28540, "Gradient exceeded, tolerance time = 0"),
    EVENTID_0x9x85(-28539, "Gradient exceeded, tolerance time > 0"),
    EVENTID_0x9x86(-28538, "Below gradient, tolerance time = 0"),
    EVENTID_0x9x87(-28537, "Below gradient, tolerance time > 0"),
    EVENTID_0x9090(-28528, "User parameter assignment error entering/leaving"),
    EVENTID_0x9190(-28272, "User parameter assignment error entering/leaving"),
    EVENTID_0x91F0(-28176, "Overflow"),
    EVENTID_0x91F1(-28175, "Underflow"),
    EVENTID_0x91F2(-28174, "Division by 0"),
    EVENTID_0x91F3(-28173, "Illegal calculation operation"),
    EVENTID_0x0000(0, "NULL: Check for user information.");

    private static final Map<Integer, S7DiagnosticEventId> map;
    private static final Map<Integer, String> idstr;
    private final String description;
    private final short code;

    static {
        map = new HashMap<Integer, S7DiagnosticEventId>();
        idstr = new HashMap<Integer, String>();
        S7DiagnosticEventId[] s7DiagnosticEventIdArray = S7DiagnosticEventId.values();
        int n = s7DiagnosticEventIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            S7DiagnosticEventId event = s7DiagnosticEventIdArray[n2];
            map.put(Short.toUnsignedInt(event.code), event);
            ++n2;
        }
        idstr.put(0, "Event leaving state. ");
        idstr.put(256, "Event entering state. ");
        idstr.put(512, "Entry in diagnostic buffer. ");
        idstr.put(1024, "Internal error. ");
        idstr.put(2048, "External error. ");
    }

    private S7DiagnosticEventId(short code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public short getCode() {
        return this.code;
    }

    public static S7DiagnosticEventId valueOf(String string) {
        return Enum.valueOf(S7DiagnosticEventId.class, string);
    }
}

