/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.env;

import com.alibaba.nacos.client.env.AbstractPropertySource;
import com.alibaba.nacos.client.env.SourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;

class PropertiesPropertySource
extends AbstractPropertySource {
    private final Properties properties = new Properties();
    private final PropertiesPropertySource parent;

    PropertiesPropertySource() {
        this.parent = null;
    }

    PropertiesPropertySource(PropertiesPropertySource parent) {
        this.parent = parent;
    }

    @Override
    SourceType getType() {
        return SourceType.PROPERTIES;
    }

    @Override
    String getProperty(String key) {
        return this.getProperty(this, key);
    }

    private String getProperty(PropertiesPropertySource propertiesPropertySource, String key) {
        String value = propertiesPropertySource.properties.getProperty(key);
        if (value != null) {
            return value;
        }
        PropertiesPropertySource parent = propertiesPropertySource.parent;
        if (parent == null) {
            return null;
        }
        return this.getProperty(parent, key);
    }

    @Override
    boolean containsKey(String key) {
        return this.containsKey(this, key);
    }

    boolean containsKey(PropertiesPropertySource propertiesPropertySource, String key) {
        boolean exist = propertiesPropertySource.properties.containsKey(key);
        if (exist) {
            return true;
        }
        PropertiesPropertySource parent = propertiesPropertySource.parent;
        if (parent == null) {
            return false;
        }
        return this.containsKey(parent, key);
    }

    @Override
    Properties asProperties() {
        List<Properties> propertiesList = new ArrayList<Properties>(8);
        propertiesList = this.lookForProperties(this, propertiesList);
        Properties ret = new Properties();
        ListIterator<Properties> iterator = propertiesList.listIterator(propertiesList.size());
        while (iterator.hasPrevious()) {
            Properties properties = iterator.previous();
            ret.putAll((Map<?, ?>)properties);
        }
        return ret;
    }

    List<Properties> lookForProperties(PropertiesPropertySource propertiesPropertySource, List<Properties> propertiesList) {
        propertiesList.add(propertiesPropertySource.properties);
        PropertiesPropertySource parent = propertiesPropertySource.parent;
        if (parent == null) {
            return propertiesList;
        }
        return this.lookForProperties(parent, propertiesList);
    }

    synchronized void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    synchronized void addProperties(Properties source) {
        this.properties.putAll((Map<?, ?>)source);
    }
}

