/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import org.pcap4j.packet.DnsDomainName;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.DnsClass;
import org.pcap4j.packet.namednumber.DnsResourceRecordType;
import org.pcap4j.util.ByteArrays;

public final class DnsQuestion
implements Serializable {
    private static final long serialVersionUID = -709060058515052575L;
    private final DnsDomainName qName;
    private final DnsResourceRecordType qType;
    private final DnsClass qClass;

    public static DnsQuestion newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new DnsQuestion(rawData, offset, length);
    }

    private DnsQuestion(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        int cursor = 0;
        this.qName = DnsDomainName.newInstance(rawData, offset, length);
        if (length - (cursor += this.qName.length()) < 4) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build qType an qClass of DnsQuestion. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length).append(", cursor: ").append(cursor);
            throw new IllegalRawDataException(sb.toString());
        }
        this.qType = DnsResourceRecordType.getInstance(ByteArrays.getShort(rawData, offset + cursor));
        this.qClass = DnsClass.getInstance(ByteArrays.getShort(rawData, offset + (cursor += 2)));
    }

    private DnsQuestion(Builder builder) {
        if (builder == null || builder.qName == null || builder.qType == null || builder.qClass == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder").append(builder).append(" builder.qName: ").append(builder.qName).append(" builder.qType: ").append(builder.qType).append(" builder.qClass: ").append(builder.qClass);
            throw new NullPointerException(sb.toString());
        }
        this.qName = builder.qName;
        this.qType = builder.qType;
        this.qClass = builder.qClass;
    }

    public DnsDomainName getQName() {
        return this.qName;
    }

    public DnsResourceRecordType getQType() {
        return this.qType;
    }

    public DnsClass getQClass() {
        return this.qClass;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public byte[] getRawData() {
        byte[] data = new byte[this.length()];
        int cursor = 0;
        byte[] rawQName = this.qName.getRawData();
        System.arraycopy(rawQName, 0, data, 0, rawQName.length);
        System.arraycopy(ByteArrays.toByteArray((Short)this.qType.value()), 0, data, cursor += rawQName.length, 2);
        System.arraycopy(ByteArrays.toByteArray((Short)this.qClass.value()), 0, data, cursor += 2, 2);
        return data;
    }

    public int length() {
        return this.qName.length() + 4;
    }

    public String toString() {
        return this.convertToString("", null);
    }

    public String toString(String indent) {
        return this.convertToString(indent, null);
    }

    public String toString(String indent, byte[] headerRawData) {
        if (headerRawData == null) {
            throw new NullPointerException("headerRawData is null.");
        }
        return this.convertToString(indent, headerRawData);
    }

    private String convertToString(String indent, byte[] headerRawData) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("QNAME: ").append(headerRawData != null ? this.qName.toString(headerRawData) : this.qName).append(ls).append(indent).append("QTYPE: ").append(this.qType).append(ls).append(indent).append("QCLASS: ").append(this.qClass).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.qClass.hashCode();
        result = 31 * result + this.qName.hashCode();
        result = 31 * result + this.qType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DnsQuestion other = (DnsQuestion)obj;
        if (!this.qClass.equals(other.qClass)) {
            return false;
        }
        if (!this.qName.equals(other.qName)) {
            return false;
        }
        return this.qType.equals(other.qType);
    }

    public static final class Builder {
        private DnsDomainName qName;
        private DnsResourceRecordType qType;
        private DnsClass qClass;

        public Builder() {
        }

        private Builder(DnsQuestion obj) {
            this.qName = obj.qName;
            this.qType = obj.qType;
            this.qClass = obj.qClass;
        }

        public Builder qName(DnsDomainName qName) {
            this.qName = qName;
            return this;
        }

        public Builder qType(DnsResourceRecordType qType) {
            this.qType = qType;
            return this;
        }

        public Builder qClass(DnsClass qClass) {
            this.qClass = qClass;
            return this;
        }

        public DnsQuestion build() {
            return new DnsQuestion(this);
        }
    }
}

